/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.servlet3.rs.ext.paramconverter.autodiscovery;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.provider.PrintingErrorHandler;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanParamConverter;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanParamConverterProvider;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.servlet3.rs.ext.paramconverter.autodiscovery.Resource;
import ee.jakarta.tck.ws.rs.servlet3.rs.ext.paramconverter.autodiscovery.TSAppConfig;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 8764917394183731977L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_servlet3_rs_ext_paramconverter_autodiscovery/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/servlet3/rs/ext/paramconverter/autodiscovery/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_servlet3_rs_ext_paramconverter_autodiscovery.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, StringBeanParamConverter.class, StringBeanParamConverterProvider.class, PrintingErrorHandler.class, StringBean.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void isParamCoverterFoundByAutodiscoveryUsedTest() throws JAXRSCommonClient.Fault {
        String query = "ABCDEFGH";
        this.setPropertyRequest(JAXRSCommonClient.Request.GET, "sbquery?query=", query);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Converted value: ");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, query);
        this.invoke();
    }

    private void setPropertyRequest(JAXRSCommonClient.Request request, String ... resource) {
        StringBuilder sb = new StringBuilder();
        for (String r : resource) {
            sb.append(r);
        }
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(request, sb.toString()));
    }
}

