/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.resourceconstructor;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.resourceconstructor.CookieResource;
import ee.jakarta.tck.ws.rs.spec.resourceconstructor.HeaderResource;
import ee.jakarta.tck.ws.rs.spec.resourceconstructor.MatrixResource;
import ee.jakarta.tck.ws.rs.spec.resourceconstructor.PathResource;
import ee.jakarta.tck.ws.rs.spec.resourceconstructor.QueryResource;
import ee.jakarta.tck.ws.rs.spec.resourceconstructor.Resource;
import ee.jakarta.tck.ws.rs.spec.resourceconstructor.TSAppConfig;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_resourceconstructor_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/resourceconstructor/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/resourceconstructor/beans.xml");
        String beansXml = JAXRSClientIT.toString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_resourceconstructor_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, CookieResource.class, HeaderResource.class, MatrixResource.class, PathResource.class, QueryResource.class});
        archive.addAsWebInfResource((Asset)new StringAsset(beansXml), "beans.xml");
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void visibleTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "mostAttributes"));
        this.invoke();
    }

    @Test
    public void packageVisibilityTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "packageVisibility"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NOT_FOUND));
        this.invoke();
    }

    @Test
    public void protectedVisibilityTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "protectedVisibility"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NOT_FOUND));
        this.invoke();
    }

    @Test
    public void privateVisibilityTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "privateVisibility"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NOT_FOUND));
        this.invoke();
    }

    @Test
    public void constructorWithHeaderParamUsedTest() throws JAXRSCommonClient.Fault {
        String param = "ABCDEFGH";
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "param:" + param);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "header"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, param);
        this.invoke();
    }

    @Test
    public void constructorWithCookieParamUsedTest() throws JAXRSCommonClient.Fault {
        String param = "ABCDEFGH";
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Cookie: param=" + param);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "cookie"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, param);
        this.invoke();
    }

    @Test
    public void constructorWithMatrixParamUsedTest() throws JAXRSCommonClient.Fault {
        String param = "ABCDEFGH";
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "matrix;param=" + param));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, param);
        this.invoke();
    }

    @Test
    public void constructorWithQueryParamUsedTest() throws JAXRSCommonClient.Fault {
        String param = "ABCDEFGH";
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "query?param=" + param));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, param);
        this.invoke();
    }

    @Test
    public void constructorWithPathParamUsedTest() throws JAXRSCommonClient.Fault {
        String param = "ABCDEFGH";
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "path/" + param));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, param);
        this.invoke();
    }
}

