/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class PropertyUtils {
    private static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void store(Map<String, String> stringProps, OutputStream out, String comments) throws IOException {
        Properties properties = new Properties();
        properties.putAll(stringProps);
        properties.store(out, comments);
    }

    public static Map<String, String> load(InputStream inputStream) throws IOException {
        return PropertyUtils.populate(new HashMap(), inputStream);
    }

    public static Map<String, String> load(Reader reader) throws IOException {
        return PropertyUtils.load0(new HashMap(), new LineReader(reader));
    }

    public static SortedMap<String, String> loadSorted(InputStream inputStream) throws IOException {
        return PropertyUtils.populate(new TreeMap(), inputStream);
    }

    private static <M extends Map<String, String>> M populate(M stringProps, InputStream inputStream) throws IOException {
        return PropertyUtils.load0(stringProps, new LineReader(inputStream));
    }

    public static Map<String, String> convertToStringProps(Properties properties) {
        return PropertyUtils.extractStringPropsTo(new HashMap(), properties);
    }

    private static <M extends Map<String, String>> M extractStringPropsTo(M stringProps, Properties p) {
        for (String name : p.stringPropertyNames()) {
            stringProps.put((String)name, (String)p.getProperty(name));
        }
        return stringProps;
    }

    static Vector<String> load0(Reader in, boolean breakOnEmptyLine) throws IOException {
        Vector<String> v = new Vector<String>();
        int ch = 0;
        ch = 10;
        block9: while (true) {
            switch (ch) {
                case -1: {
                    break block9;
                }
                case 33: 
                case 35: {
                    while ((ch = in.read()) >= 0 && ch != 10 && ch != 13) {
                    }
                    continue block9;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    int lines = 0;
                    while (!breakOnEmptyLine || ch != 10 || ++lines <= 1) {
                        ch = in.read();
                        if (ch == 10 || ch == 13 || ch == 9 || ch == 32) continue;
                        continue block9;
                    }
                    break block9;
                }
                default: {
                    StringBuilder key = new StringBuilder();
                    StringBuilder val = new StringBuilder();
                    boolean hasSep = false;
                    boolean precedingBackslash = false;
                    while (ch >= 0 && ch != 10 && ch != 13) {
                        if (!(ch != 61 && ch != 58 || precedingBackslash)) {
                            ch = in.read();
                            hasSep = true;
                            break;
                        }
                        if (!(ch != 32 && ch != 9 && ch != 12 || precedingBackslash)) {
                            ch = in.read();
                            break;
                        }
                        precedingBackslash = ch == 92 ? !precedingBackslash : false;
                        key.append((char)ch);
                        ch = in.read();
                    }
                    while (ch >= 0 && ch != 10 && ch != 13) {
                        if (ch != 32 && ch != 9 && ch != 12) {
                            if (hasSep || ch != 61 && ch != 58) break;
                            hasSep = true;
                        }
                        ch = in.read();
                    }
                    block14: while (ch >= 0 && ch != 10 && ch != 13) {
                        if (ch == 92) {
                            ch = in.read();
                            switch (ch) {
                                case 13: {
                                    ch = in.read();
                                    if (ch != 10 && ch != 32 && ch != 9) continue block14;
                                }
                                case 10: {
                                    while ((ch = in.read()) == 32 || ch == 9) {
                                    }
                                    continue block14;
                                }
                            }
                            val.append('\\');
                        }
                        val.append((char)ch);
                        ch = in.read();
                    }
                    char[] cKey = new char[key.length()];
                    char[] cVal = new char[val.length()];
                    key.getChars(0, key.length(), cKey, 0);
                    val.getChars(0, val.length(), cVal, 0);
                    v.add(PropertyUtils.loadConvert(cKey));
                    v.add(PropertyUtils.loadConvert(cVal));
                    continue block9;
                }
            }
            break;
        }
        return v;
    }

    private static String loadConvert(char ... in) {
        int len = in.length;
        char[] out = new char[len];
        int outLen = 0;
        int off = 0;
        while (off < len) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    static String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(PropertyUtils.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(PropertyUtils.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(PropertyUtils.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(PropertyUtils.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private static <M extends Map<String, String>> M load0(M map, LineReader lr) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        while ((limit = lr.readLine()) >= 0) {
            int keyLen;
            char c = '\u0000';
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = PropertyUtils.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
            String value = PropertyUtils.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            map.put((String)key, (String)value);
        }
        return map;
    }

    private static String loadConvert(char[] in, int off, int len, char ... convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    private static class LineReader {
        byte[] inByteBuf;
        char[] inCharBuf;
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;
        Reader reader;

        public LineReader(InputStream inStream) {
            this.inStream = inStream;
            this.inByteBuf = new byte[8192];
        }

        public LineReader(Reader reader) {
            this.reader = reader;
            this.inCharBuf = new char[8192];
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                c = this.inStream != null ? (char)(this.inByteBuf[this.inOff++] & 0xFF) : this.inCharBuf[this.inOff++];
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        if (this.inStream != null) {
                            while (this.inOff < this.inLimit) {
                                byte b;
                                if ((b = this.inByteBuf[this.inOff++]) != 10 && b != 13 && b != 92) continue;
                                c = (char)(b & 0xFF);
                                break;
                            }
                        } else {
                            while (this.inOff < this.inLimit && (c = this.inCharBuf[this.inOff++]) != '\n' && c != '\r' && c != '\\') {
                            }
                        }
                        isCommentLine = true;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

