/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.httpd;

import java.util.Dictionary;
import java.util.Properties;

public class httpURL {
    protected static final boolean debug = Boolean.getBoolean("debug." + httpURL.class.getName());
    private String lHost;
    private int lPort = -1;
    private String rHost;
    private int pathPos;
    private int firstQ;
    private String file;
    private int fileLen;
    private Properties urlValues = new Properties();

    public httpURL(String url) {
        this.firstQ = url.indexOf(63);
        this.file = url;
        this.fileLen = this.file.length();
        this.resetIterator();
        if (this.firstQ != -1) {
            this.parseURLKeys();
        }
    }

    public static String reassemblePath(String[] path, boolean leadingSlash, boolean trailSlash) {
        if (path == null || path.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (leadingSlash) {
            result.append("/");
        }
        for (String aPath : path) {
            if (aPath == null) continue;
            result.append(aPath);
            result.append("/");
        }
        if (!trailSlash && result.length() > 1) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    public String getNextFile() {
        String ss;
        if (this.pathPos == this.fileLen) {
            return null;
        }
        if (this.pathPos == this.fileLen - 1) {
            if (this.fileLen == 1 && this.file.charAt(0) == '/') {
                ss = "/";
                this.pathPos = this.fileLen;
            } else {
                ss = this.file.substring(this.pathPos, this.fileLen);
                this.pathPos = this.fileLen;
            }
        } else {
            int nextPos = this.file.indexOf(47, this.pathPos + 1);
            if (nextPos == -1) {
                String result = this.file.substring(this.pathPos, this.firstQ == -1 ? this.fileLen : this.firstQ);
                this.pathPos = this.fileLen;
                ss = result;
            } else {
                ss = this.file.substring(this.pathPos, nextPos);
                this.pathPos = nextPos + 1;
            }
        }
        return ss;
    }

    public void resetIterator() {
        this.pathPos = this.file.indexOf(47) == 0 && this.fileLen > 1 ? 1 : 0;
    }

    public String getFullPath() {
        return this.file;
    }

    public String getLocalHost() throws Fault {
        if (this.lHost == null) {
            throw new Fault("Local hostname for URL not available");
        }
        return this.lHost;
    }

    void setLocalHost(String name) {
        this.lHost = name;
    }

    public int getLocalPort() throws Fault {
        if (this.lPort == -1) {
            throw new Fault("Local port for URL not available");
        }
        return this.lPort;
    }

    void setLocalPort(int port) {
        this.lPort = port;
    }

    public String getRemoteHost() throws Fault {
        if (this.rHost == null) {
            throw new Fault("Remote hostname for URL not available");
        }
        return this.rHost;
    }

    void setRemoteHost(String name) {
        this.rHost = name;
    }

    public void setProperties(Dictionary<String, String> props) {
    }

    public String[] getKeys() {
        return null;
    }

    public String[] getValues() {
        return null;
    }

    public String getValue(String key) {
        return this.urlValues.getProperty(key);
    }

    private void parseURLKeys() {
        String data = this.file.substring(this.firstQ + 1, this.fileLen);
        if (data.isEmpty()) {
            return;
        }
        String key = null;
        int pos = 0;
        int dataLen = data.length();
        while ((key = this.readSegment(data, pos, dataLen)) != null) {
            pos += key.length();
            if (debug) {
                System.out.println("   Read key: " + key);
            }
            if (pos >= dataLen || data.charAt(pos) == '&') {
                if (debug) {
                    System.out.println("key: " + key + "  value: null");
                }
                this.urlValues.put(key, "true");
                continue;
            }
            String val = this.readSegment(data, ++pos, dataLen);
            if (debug) {
                System.out.println("key: " + key + "  value: " + val);
            }
            this.urlValues.put(key, val);
            if ((pos = pos + val.length() + 1) <= dataLen) continue;
            break;
        }
    }

    private String readSegment(String data, int position, int dataLen) {
        StringBuilder buf = new StringBuilder();
        for (int i = position; i < dataLen && data.charAt(i) != '&' && data.charAt(i) != '='; ++i) {
            buf.append(data.charAt(i));
        }
        return buf.length() == 0 ? null : buf.toString();
    }

    public static class Fault
    extends Exception {
        private Throwable orig;

        public Fault(String s) {
            super(s);
        }

        public Fault(String s, Throwable e) {
            super(s);
        }

        public Throwable getException() {
            return this.orig;
        }
    }
}

