/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.jthelp.JHelpContentViewer;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

class FocusMonitor {
    private static final Color STD_COLOR = Color.black;
    private static final Color ERR_COLOR = Color.red;
    private static final Color WARN_COLOR = Color.yellow;
    private static final Color HILITE_COLOR = new Color(255, 255, 200);
    private static final String NEWLINE = System.getProperty("line.separator");
    private static FocusMonitor focusMonitor;
    private KeyStroke activateKey;
    private KeyStroke reportKey;
    private String reportFile;
    private JFrame frame;
    private SummaryPanel prevFocusPanel;
    private DetailPanel currFocusPanel;
    private Action reportAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FocusMonitor.this.report();
        }
    };
    private SummaryPanel nextFocusPanel;
    private Component currentComponent;
    private boolean highlighting;
    private boolean savedOpaque;
    private Color savedBackground;
    private Action activateAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FocusMonitor.this.setVisible(true);
        }
    };

    private FocusMonitor() {
        KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        fm.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("focusOwner")) {
                this.update();
            }
        });
    }

    public static FocusMonitor access() {
        if (focusMonitor == null) {
            focusMonitor = new FocusMonitor();
        }
        return focusMonitor;
    }

    private static String getKeysString(Component c, int mode) {
        if (c == null) {
            return null;
        }
        Set<AWTKeyStroke> s = c.getFocusTraversalKeys(mode);
        StringBuilder sb = new StringBuilder();
        for (AWTKeyStroke value : s) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(value);
        }
        if (!c.areFocusTraversalKeysSet(mode)) {
            sb.append(" (inherited)");
        }
        return sb.toString();
    }

    private static String getPath(Component c) {
        StringBuffer sb = new StringBuffer();
        FocusMonitor.appendPath(sb, c);
        return sb.toString();
    }

    private static void appendPath(StringBuffer sb, Component c) {
        Container p = c.getParent();
        if (p != null) {
            FocusMonitor.appendPath(sb, p);
        }
        sb.append('/');
        String name = c.getName();
        if (name == null || name.isEmpty()) {
            if (p == null) {
                sb.append("(Root component)");
            } else {
                for (int i = 0; i < p.getComponentCount(); ++i) {
                    if (p.getComponent(i) != c) continue;
                    sb.append(i);
                    break;
                }
            }
        } else {
            sb.append(name);
        }
    }

    public void setOptions(String ... opts) {
        for (String opt : opts) {
            if (opt.equals("-open")) {
                this.setVisible(true);
                continue;
            }
            if (opt.equals("-bg")) {
                this.setHighlightEnabled(true);
                continue;
            }
            System.err.println("Warning: bad option for FocusMonitor: " + opt);
        }
    }

    public void setActivateKey(String key) {
        this.activateKey = KeyStroke.getKeyStroke(key);
    }

    public void setReportKey(String key) {
        this.reportKey = KeyStroke.getKeyStroke(key);
    }

    public void setReportFile(String file) {
        this.reportFile = file;
    }

    public void monitor(Component c) {
        if (c == null || this.frame != null && (this.frame == c || this.frame.isAncestorOf(c))) {
            return;
        }
        if (this.activateKey != null || this.reportKey != null) {
            JRootPane root;
            Window w = (Window)(c instanceof Window ? c : SwingUtilities.getAncestorOfClass(Window.class, c));
            if (w == null) {
                return;
            }
            if (w instanceof JFrame) {
                root = ((JFrame)w).getRootPane();
            } else if (w instanceof JDialog) {
                root = ((JDialog)w).getRootPane();
            } else {
                return;
            }
            if (root == null) {
                return;
            }
            InputMap inputMap = root.getInputMap(2);
            inputMap.put(this.activateKey, "focusMonitor.activate");
            inputMap.put(this.reportKey, "focusMonitor.report");
            ActionMap actionMap = root.getActionMap();
            actionMap.put("focusMonitor.activate", this.activateAction);
            actionMap.put("focusMonitor.report", this.reportAction);
        }
    }

    public void report() {
        try {
            Writer out = this.reportFile == null ? new OutputStreamWriter(System.out, StandardCharsets.UTF_8){

                @Override
                public void close() throws IOException {
                    this.flush();
                }
            } : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.reportFile, true), StandardCharsets.UTF_8));
            out.write("---------------------------------------");
            out.write(NEWLINE);
            this.report(out);
            out.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            if (this.frame == null) {
                this.initGUI();
            }
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            focusMonitor.monitor(fm.getFocusOwner());
            this.frame.setVisible(true);
            focusMonitor.update();
        } else if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }

    private void deactivate() {
        this.frame.setVisible(false);
        this.frame.dispose();
        this.frame = null;
    }

    private void update() {
        if (this.frame == null || !this.frame.isVisible()) {
            return;
        }
        KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component c = fm.getFocusOwner();
        if (c == null || this.frame == c || this.frame.isAncestorOf(c)) {
            this.prevFocusPanel.setEnabled(false);
            this.currFocusPanel.setEnabled(false);
            this.nextFocusPanel.setEnabled(false);
        } else {
            Window w;
            if (this.highlighting) {
                this.setHighlight(this.currentComponent, false);
                this.setHighlight(c, true);
            }
            this.currentComponent = c;
            this.prevFocusPanel.setComponent(this.getPreviousFocus(c));
            this.currFocusPanel.setComponent(c);
            this.nextFocusPanel.setComponent(this.getNextFocus(c));
            for (w = fm.getFocusedWindow(); w != null && !(w instanceof Frame); w = w.getOwner()) {
            }
            String title = "Focus Monitor";
            if (w instanceof Frame) {
                title = title + " - " + ((Frame)w).getTitle();
            }
            this.frame.setTitle(title);
        }
    }

    private void setHighlightEnabled(boolean b) {
        if (b != this.highlighting) {
            this.highlighting = b;
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component c = fm.getFocusOwner();
            if (this.frame == null || !this.frame.isAncestorOf(c)) {
                this.setHighlight(c, this.highlighting);
            }
        }
    }

    private void setHighlight(Component c, boolean b) {
        if (c == null) {
            return;
        }
        if (b) {
            this.savedOpaque = c.isOpaque();
            this.savedBackground = c.getBackground();
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(true);
            }
            c.setBackground(HILITE_COLOR);
        } else {
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(this.savedOpaque);
            }
            c.setBackground(this.savedBackground);
        }
    }

    private void report(Writer out) throws IOException {
        if (this.currFocusPanel == null) {
            System.err.println("focus monitor not open: no component selected");
            return;
        }
        this.currFocusPanel.write(out);
    }

    private void initGUI() {
        JMenuBar menuBar = new JMenuBar();
        JMenu viewMenu = new JMenu("View");
        final JCheckBoxMenuItem showBackgroundMenuItem = new JCheckBoxMenuItem("background");
        viewMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                showBackgroundMenuItem.setSelected(FocusMonitor.this.highlighting);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        showBackgroundMenuItem.addChangeListener(e -> this.setHighlightEnabled(showBackgroundMenuItem.isSelected()));
        viewMenu.add(showBackgroundMenuItem);
        menuBar.add(viewMenu);
        this.prevFocusPanel = new SummaryPanel();
        this.prevFocusPanel.setBorder(BorderFactory.createTitledBorder("previous focus"));
        this.currFocusPanel = new DetailPanel();
        this.currFocusPanel.setBorder(BorderFactory.createTitledBorder("current focus"));
        this.nextFocusPanel = new SummaryPanel();
        this.nextFocusPanel.setBorder(BorderFactory.createTitledBorder("next focus"));
        JPanel main = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        main.add((Component)this.prevFocusPanel, c);
        c.insets.top = 10;
        main.add((Component)this.currFocusPanel, c);
        main.add((Component)this.nextFocusPanel, c);
        JFrame f = new JFrame("Focus Monitor");
        f.setJMenuBar(menuBar);
        f.setContentPane(main);
        f.pack();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                FocusMonitor.this.deactivate();
            }
        });
        this.frame = f;
    }

    private Component getNextFocus(Component c) {
        if (c == null) {
            return null;
        }
        Container rootAncestor = c.getFocusCycleRootAncestor();
        Component comp = c;
        while (!(rootAncestor == null || rootAncestor.isShowing() && rootAncestor.isFocusable() && rootAncestor.isEnabled())) {
            comp = rootAncestor;
            rootAncestor = comp.getFocusCycleRootAncestor();
        }
        if (rootAncestor == null) {
            return null;
        }
        FocusTraversalPolicy policy = rootAncestor.getFocusTraversalPolicy();
        Component toFocus = policy.getComponentAfter(rootAncestor, comp);
        if (toFocus == null) {
            toFocus = policy.getDefaultComponent(rootAncestor);
        }
        return toFocus;
    }

    private Component getPreviousFocus(Component c) {
        if (c == null) {
            return null;
        }
        Container rootAncestor = c.getFocusCycleRootAncestor();
        Component comp = c;
        while (!(rootAncestor == null || rootAncestor.isShowing() && rootAncestor.isFocusable() && rootAncestor.isEnabled())) {
            comp = rootAncestor;
            rootAncestor = comp.getFocusCycleRootAncestor();
        }
        if (rootAncestor == null) {
            return null;
        }
        FocusTraversalPolicy policy = rootAncestor.getFocusTraversalPolicy();
        Component toFocus = policy.getComponentBefore(rootAncestor, comp);
        if (toFocus == null) {
            toFocus = policy.getDefaultComponent(rootAncestor);
        }
        return toFocus;
    }

    private Component getUpFocus(Component c) {
        Container window;
        Container rootAncestor;
        if (c == null) {
            return null;
        }
        for (rootAncestor = c.getFocusCycleRootAncestor(); !(rootAncestor == null || rootAncestor.isShowing() && rootAncestor.isFocusable() && rootAncestor.isEnabled()); rootAncestor = rootAncestor.getFocusCycleRootAncestor()) {
        }
        if (rootAncestor != null) {
            return rootAncestor;
        }
        Container container = window = c instanceof Container ? (Container)c : c.getParent();
        while (window != null && !(window instanceof Window)) {
            window = window.getParent();
        }
        if (window == null) {
            return null;
        }
        return window.getFocusTraversalPolicy().getDefaultComponent(window);
    }

    private static class DetailPanel
    extends SummaryPanel {
        private Entry accName = new Entry("acc. name");
        private Entry accDesc;
        private Entry toolTip;
        private Entry text;
        private Entry labelFor;
        private Entry mnemonic;
        private Entry fwdKeys;
        private Entry bwdKeys;
        private Entry upKeys;
        private Entry downKeys;

        DetailPanel() {
            this.add(this.accName);
            this.accDesc = new Entry("acc. desc");
            this.add(this.accDesc);
            this.toolTip = new Entry("tooltip");
            this.add(this.toolTip);
            this.text = new Entry("text");
            this.add(this.text);
            this.labelFor = new Entry("label for");
            this.add(this.labelFor);
            this.mnemonic = new Entry("mnemonic");
            this.add(this.mnemonic);
            this.fwdKeys = new Entry("> keys");
            this.add(this.fwdKeys);
            this.bwdKeys = new Entry("< keys");
            this.add(this.bwdKeys);
            this.upKeys = new Entry("^ keys");
            this.add(this.upKeys);
            this.downKeys = new Entry("v keys");
            this.add(this.downKeys);
        }

        @Override
        void setComponent(Component c) {
            AccessibleContext ac;
            super.setComponent(c);
            AccessibleContext accessibleContext = ac = c == null ? null : c.getAccessibleContext();
            if (ac == null) {
                this.accName.setText(null, "not accessible");
                this.accDesc.setText(null, "not accessible");
            } else {
                boolean sb = c instanceof JScrollBar;
                String an = ac.getAccessibleName();
                this.accName.setText(an != null ? an : "no accessible name", an != null || sb);
                String ad = ac.getAccessibleDescription();
                this.accDesc.setText(ad != null ? ad : "no accessible description", ad != null || sb);
            }
            if (c != null && c instanceof JComponent) {
                String ttText = ((JComponent)c).getToolTipText();
                boolean ttEmpty = ttText == null || ttText.isEmpty();
                boolean toolTipOK = !ttEmpty || c instanceof JTree || c instanceof JEditorPane || c instanceof JHelpContentViewer || c instanceof JList || c instanceof JRootPane || c instanceof JScrollBar || c instanceof JTextComponent && !((JTextComponent)c).isEditable();
                this.toolTip.setText(ttEmpty ? "no tooltip" : ttText, toolTipOK);
            } else {
                this.toolTip.setEnabled(false);
            }
            if (c instanceof JButton) {
                this.text.setText(((JButton)c).getText());
            } else if (c instanceof JLabel) {
                this.text.setText(((JLabel)c).getText());
            } else if (c instanceof JTextComponent) {
                JTextComponent tc = (JTextComponent)c;
                Document d = tc.getDocument();
                try {
                    this.text.setText(d.getText(0, Math.min(80, d.getLength())));
                }
                catch (Exception e) {
                    this.text.setText(null, e.toString());
                }
            } else {
                this.text.setEnabled(false);
            }
            if (c != null && c instanceof JLabel) {
                this.labelFor.setText(c.getClass().getName() + " " + c.getName());
            } else {
                this.labelFor.setEnabled(false);
            }
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                int mne = l.getDisplayedMnemonic();
                boolean mnemonicOK = mne != 0 || l.getLabelFor() == null;
                this.mnemonic.setText(mne == 0 ? "no mnemonic" : String.valueOf((char)mne), mnemonicOK);
            } else if (c instanceof JButton) {
                JButton b = (JButton)c;
                int mne = b.getMnemonic();
                String cmd = b.getActionCommand();
                boolean mnemonicOK = mne != 0 || cmd != null && cmd.equals("cancel");
                this.mnemonic.setText(mne == 0 ? "no mnemonic" : String.valueOf((char)mne), mnemonicOK);
            } else {
                this.mnemonic.setEnabled(false);
            }
            this.fwdKeys.setText(FocusMonitor.getKeysString(c, 0));
            this.bwdKeys.setText(FocusMonitor.getKeysString(c, 1));
            this.upKeys.setText(FocusMonitor.getKeysString(c, 2));
            this.downKeys.setText(FocusMonitor.getKeysString(c, 3));
        }
    }

    private static class SummaryPanel
    extends JPanel {
        private Vector<Entry> entries = new Vector();
        private Entry name;
        private Entry path;
        private Entry type;

        SummaryPanel() {
            this.setName("summary");
            this.setLayout(new GridBagLayout());
            this.type = new Entry("type");
            this.add(this.type);
            this.name = new Entry("name");
            this.add(this.name);
            this.path = new Entry("path");
            this.add(this.path);
        }

        void setComponent(Component c) {
            if (c == null) {
                this.setEnabled(false);
                this.type.setEnabled(false);
                this.name.setEnabled(false);
                this.path.setEnabled(false);
            } else {
                this.setEnabled(true);
                this.type.setText(c.getClass().getName());
                this.name.setText(c.getName(), "no name", STD_COLOR, WARN_COLOR);
                this.path.setText(FocusMonitor.getPath(c));
            }
        }

        void write(Writer out) throws IOException {
            for (Entry e : this.entries) {
                e.write(out);
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            for (Entry e : this.entries) {
                e.setParentEnabled(enabled);
            }
        }

        protected void add(Entry entry) {
            GridBagConstraints lc = new GridBagConstraints();
            this.add((Component)entry.label, lc);
            GridBagConstraints fc = new GridBagConstraints();
            fc.fill = 2;
            fc.gridwidth = 0;
            fc.weightx = 1.0;
            this.add((Component)entry.field, fc);
            this.entries.add(entry);
        }
    }

    private static class Entry {
        JLabel label;
        JTextField field;
        boolean enabled;

        Entry(String name) {
            this.label = new JLabel(name + ": ");
            this.label.setName(name);
            this.field = new JTextField(60);
            this.field.setName(name + ".value");
            this.field.setEditable(false);
            this.label.setLabelFor(this.field);
        }

        void setParentEnabled(boolean parentEnabled) {
            this.label.setEnabled(parentEnabled && this.enabled);
            this.field.setEnabled(parentEnabled && this.enabled);
        }

        void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.label.setEnabled(enabled);
            this.field.setEnabled(enabled);
            this.field.setText("");
        }

        void setText(String s) {
            this.setEnabled(true);
            this.field.setText(s);
            this.field.setForeground(STD_COLOR);
        }

        void setText(String s, boolean ok) {
            this.setText(s, ok, STD_COLOR, ERR_COLOR);
        }

        void setText(String s, boolean ok, Color okColor, Color notOKColor) {
            this.setEnabled(true);
            this.field.setText(s);
            this.field.setForeground(ok ? okColor : notOKColor);
        }

        void setText(String s, String err) {
            if (s == null || s.isEmpty()) {
                this.setText(err, false);
            } else {
                this.setText(s, true);
            }
        }

        void setText(String s, String err, Color okColor, Color notOKColor) {
            if (s == null || s.isEmpty()) {
                this.setText(err, false, okColor, notOKColor);
            } else {
                this.setText(s, true, okColor, notOKColor);
            }
        }

        void write(Writer out) throws IOException {
            if (this.field.isEnabled()) {
                out.write(this.field.getForeground() == ERR_COLOR ? "** " : "   ");
                out.write(this.label.getText());
                out.write(this.field.getText());
                out.write(NEWLINE);
            }
        }
    }
}

