/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.usecases;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee20.cditests.usecases.CMBean1IF;
import com.sun.ts.tests.jms.ee20.cditests.usecases.CMBean2IF;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBException;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.inject.Inject;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConnectionFactory;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.util.Properties;

@TransactionManagement(value=TransactionManagementType.CONTAINER)
@Stateless(name="CDIUseCasesCMBEAN1")
public class CMBean1
implements CMBean1IF {
    private static final long serialVersionUID = 1L;
    long timeout;
    @Inject
    @JMSConnectionFactory(value="jms/ConnectionFactory")
    JMSContext context;
    @Resource(name="jms/MyConnectionFactory")
    ConnectionFactory cfactory;
    @Resource(name="jms/MY_QUEUE")
    Queue queue;
    @Resource(name="jms/MY_TOPIC")
    Topic topic;
    @EJB(name="ejb/CDIUseCasesCMBEAN2")
    CMBean2IF cmbean2;

    @PostConstruct
    public void postConstruct() {
        System.out.println("CMBean1:postConstruct()");
        System.out.println("queue=" + this.queue);
        System.out.println("topic=" + this.topic);
        System.out.println("cfactory=" + this.cfactory);
        System.out.println("cmbean2=" + this.cmbean2);
        if (this.queue == null || this.topic == null || this.context == null || this.cfactory == null || this.cmbean2 == null) {
            throw new EJBException("postConstruct failed: injection failure");
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void init(Properties p) {
        TestUtil.logMsg((String)"CMBean1.init()");
        try {
            TestUtil.init((Properties)p);
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("CMBean1.init: failed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("CMBean1.init: failed");
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public boolean cleanupQueue(int numOfMsgs) {
        int count = 0;
        String message = null;
        TestUtil.logMsg((String)"CMBean1.cleanupQueue()");
        try {
            JMSConsumer consumer = this.context.createConsumer((Destination)this.queue);
            for (int i = 0; i < numOfMsgs; ++i) {
                message = (String)consumer.receiveBody(String.class, this.timeout);
                if (message == null) continue;
                TestUtil.logMsg((String)("Cleanup message: [" + message + "]"));
                ++count;
            }
            while ((message = (String)consumer.receiveBody(String.class, this.timeout)) != null) {
                TestUtil.logMsg((String)("Cleanup message: [" + message + "]"));
                ++count;
            }
            consumer.close();
            TestUtil.logMsg((String)("Cleaned up " + count + " messages from Queue (numOfMsgs=" + numOfMsgs + ")"));
            return count == numOfMsgs;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("CMBean1.cleanupQueue: failed");
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void method1a() {
        TestUtil.logMsg((String)("CMBean1.method1a(): JMSContext context=" + this.context));
        TestUtil.logMsg((String)"Sending message [Message 1]");
        this.context.createProducer().send((Destination)this.queue, "Message 1");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void method1b() {
        TestUtil.logMsg((String)("CMBean1.method1b(): JMSContext context=" + this.context));
        TestUtil.logMsg((String)"Sending message [Message 2]");
        this.context.createProducer().send((Destination)this.queue, "Message 2");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void method2() {
        TestUtil.logMsg((String)("CMBean1.method2(): JMSContext context=" + this.context));
        TestUtil.logMsg((String)"Calling CMBean2.method2a() followed by Bean2.method2b()");
        this.cmbean2.method2a();
        this.cmbean2.method2b();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void method3() {
        TestUtil.logMsg((String)("CMBean1.method3(): JMSContext context=" + this.context));
        TestUtil.logMsg((String)"Sending message [Message 1]");
        this.context.createProducer().send((Destination)this.queue, "Message 1");
        TestUtil.logMsg((String)"Calling CMBean2.method3()");
        this.cmbean2.method3();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void method4() {
        TestUtil.logMsg((String)("CMBean1.method4(): JMSContext context=" + this.context));
        JMSProducer producer = this.context.createProducer();
        TestUtil.logMsg((String)"Sending message [Message 1]");
        producer.send((Destination)this.queue, "Message 1");
        TestUtil.logMsg((String)"Sending message [Message 2]");
        producer.send((Destination)this.queue, "Message 2");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void method5() {
        TestUtil.logMsg((String)("CMBean1.method5(): JMSContext context=" + this.context));
        JMSProducer producer = this.context.createProducer();
        TestUtil.logMsg((String)"Sending message [Message 1]");
        producer.send((Destination)this.queue, "Message 1");
        this.cmbean2.method5();
        TestUtil.logMsg((String)"Sending message [Message 3]");
        producer.send((Destination)this.queue, "Message 3");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void method6() {
        TestUtil.logMsg((String)("CMBean1.method6(): JMSContext context=" + this.context));
        TestUtil.logMsg((String)"Sending message [Message 1]");
        this.context.createProducer().send((Destination)this.queue, "Message 1");
        this.cmbean2.method6();
    }
}

