/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.bidirmanyxmany;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.bidirmanyxmany.BiDirMXMPerson;
import ee.jakarta.tck.persistence.core.relationship.bidirmanyxmany.BiDirMXMProject;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

public class Client
extends PMClientBase {
    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void biDirMXMTest1() throws Exception {
        this.logTrace("Begin biDirMXMTest1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BiDirMXMProject project1 = new BiDirMXMProject(1L, "JavaEE", Float.valueOf(500.0f));
            BiDirMXMProject project2 = new BiDirMXMProject(2L, "Identity", Float.valueOf(300.0f));
            BiDirMXMPerson person1 = new BiDirMXMPerson(1L, "Duke");
            BiDirMXMPerson person2 = new BiDirMXMPerson(2L, "Foo");
            this.getEntityManager().persist((Object)project1);
            this.getEntityManager().persist((Object)project2);
            this.getEntityManager().persist((Object)person1);
            this.getEntityManager().persist((Object)person2);
            Vector<BiDirMXMProject> projects = new Vector<BiDirMXMProject>();
            projects.add(project1);
            projects.add(project2);
            person1.setProjects(projects);
            Vector<BiDirMXMProject> projects2 = new Vector<BiDirMXMProject>();
            projects2.add(project2);
            person2.setProjects(projects2);
            this.getEntityManager().merge((Object)person1);
            this.getEntityManager().merge((Object)person2);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.logTrace("persisted Persons and Project");
            this.getEntityTransaction().begin();
            this.logTrace("persisted Persons and Project");
            boolean pass1 = false;
            boolean pass2 = false;
            BiDirMXMPerson newPerson = (BiDirMXMPerson)this.getEntityManager().find(BiDirMXMPerson.class, (Object)1L);
            if (newPerson != null) {
                Collection<BiDirMXMProject> newProjects = newPerson.getProjects();
                for (BiDirMXMProject prj : newProjects) {
                    if (prj.getName().equals("Identity")) {
                        this.logTrace("Found Searched Project Identity");
                        pass1 = true;
                        continue;
                    }
                    if (!prj.getName().equals("JavaEE")) continue;
                    this.logTrace("Found Searched Project JavaEE");
                    pass2 = true;
                }
            }
            boolean pass3 = false;
            BiDirMXMPerson newPerson2 = (BiDirMXMPerson)this.getEntityManager().find(BiDirMXMPerson.class, (Object)2L);
            if (newPerson2 != null) {
                Collection<BiDirMXMProject> newProjects2 = newPerson2.getProjects();
                for (BiDirMXMProject prj : newProjects2) {
                    if (!prj.getName().equals("Identity")) continue;
                    this.logTrace("Found Searched Project for Person id=2");
                    pass3 = true;
                }
            }
            if (pass1 && pass2 && pass3) {
                this.logTrace("biDirMXMTest1: Expected results received");
                pass = true;
            } else {
                this.logErr("Unexpected results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("biDirMXMTest1 failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIRMXMPERSON_BIDIRMXMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIRMXMPERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIRMXMPROJECT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

