/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_exceptT;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import com.sun.ts.tests.jms.commonee.ParentMsgBeanNoTx;
import jakarta.ejb.EJBHome;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueSession;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.UserTransaction;
import java.security.Principal;
import java.util.Properties;

public class MsgBean
extends ParentMsgBeanNoTx {
    protected void runTests(Message msg, QueueSession qSession, String testName, Properties p) {
        try {
            if (msg.getIntProperty("TestCaseNum") > 0) {
                switch (msg.getIntProperty("TestCaseNum")) {
                    case 1: {
                        this.runGetRollbackOnlyBMT(msg, qSession, testName);
                        break;
                    }
                    case 2: {
                        this.runSetRollbackOnlyBMT(msg, qSession, testName);
                        break;
                    }
                    case 3: {
                        this.runSetRollbackOnlyCMT(msg, qSession, testName);
                        break;
                    }
                    case 4: {
                        this.runGetRollbackOnlyCMT(msg, qSession, testName);
                        break;
                    }
                    case 5: 
                    case 6: {
                        this.runGetUserTransaction(msg, qSession, testName);
                        break;
                    }
                    case 7: 
                    case 8: {
                        this.runGetCallerPrincipal(msg, qSession, testName);
                        break;
                    }
                    case 11: 
                    case 12: {
                        this.runGetEJBHome(msg, qSession, testName);
                        break;
                    }
                    case 13: {
                        this.runBeginAgain(msg, qSession, testName);
                        break;
                    }
                    default: {
                        TestUtil.logTrace((String)"Error in mdb - ");
                        TestUtil.logTrace((String)("No test match for TestCaseNum: " + msg.getIntProperty("TestCaseNum")));
                    }
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void runGetRollbackOnlyBMT(Message msg, QueueSession qSession, String testName) {
        this.result = false;
        try {
            UserTransaction ut = this.mdc.getUserTransaction();
            ut.begin();
            try {
                this.mdc.getRollbackOnly();
                TestUtil.logErr((String)"BMT MDB getRollbackOnly() Test Failed!");
            }
            catch (IllegalStateException e) {
                TestUtil.logTrace((String)"BMT MDB getRollbackOnly() Test Succeeded!");
                TestUtil.logTrace((String)"Got expected IllegalStateException!");
                this.result = true;
            }
            ut.rollback();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception: ", (Throwable)e);
        }
        JmsUtil.sendTestResults((String)testName, (boolean)this.result, (QueueSession)qSession, (Queue)this.queueR);
    }

    public void runSetRollbackOnlyBMT(Message msg, QueueSession qSession, String testName) {
        this.result = false;
        try {
            UserTransaction ut = this.mdc.getUserTransaction();
            ut.begin();
            try {
                this.mdc.setRollbackOnly();
                TestUtil.logErr((String)"BMT MDB setRollbackOnly() Test Failed!");
            }
            catch (IllegalStateException e) {
                TestUtil.logTrace((String)"BMT MDB setRollbackOnly() Test Succeeded!");
                TestUtil.logTrace((String)"Got expected IllegalStateException!");
                this.result = true;
            }
            ut.rollback();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception: ", (Throwable)e);
        }
        JmsUtil.sendTestResults((String)testName, (boolean)this.result, (QueueSession)qSession, (Queue)this.queueR);
    }

    public void runSetRollbackOnlyCMT(Message msg, QueueSession qSession, String testName) {
        this.result = false;
        try {
            this.mdc.setRollbackOnly();
            TestUtil.logErr((String)"CMT MDB setRollbackOnly() Test Failed!");
        }
        catch (IllegalStateException e) {
            TestUtil.logTrace((String)"CMT MDB setRollbackOnly() Test Succeeded!");
            TestUtil.logTrace((String)"Got expected IllegalStateException!");
            this.result = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception: ", (Throwable)e);
        }
        JmsUtil.sendTestResults((String)testName, (boolean)this.result, (QueueSession)qSession, (Queue)this.queueR);
    }

    public void runGetRollbackOnlyCMT(Message msg, QueueSession qSession, String testName) {
        try {
            this.mdc.getRollbackOnly();
            TestUtil.logErr((String)"CMT MDB getRollbackOnly() Test Failed!");
        }
        catch (IllegalStateException e) {
            TestUtil.logTrace((String)"CMT MDB getRollbackOnly() Test Succeeded!");
            TestUtil.logTrace((String)"Got expected IllegalStateException!");
            this.result = true;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        JmsUtil.sendTestResults((String)testName, (boolean)this.result, (QueueSession)qSession, (Queue)this.queueR);
    }

    public void runGetUserTransaction(Message msg, QueueSession qSession, String testName) {
        this.result = false;
        try {
            UserTransaction ut = this.mdc.getUserTransaction();
            TestUtil.logErr((String)"CMT MDB getUserTransaction() Test Failed!");
        }
        catch (IllegalStateException e) {
            TestUtil.logTrace((String)"CMT MDB getUserTransaction() Test Succeeded!");
            TestUtil.logTrace((String)"Got expected IllegalStateException!");
            this.result = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception: ", (Throwable)e);
        }
        JmsUtil.sendTestResults((String)testName, (boolean)this.result, (QueueSession)qSession, (Queue)this.queueR);
    }

    public void runGetCallerPrincipal(Message msg, QueueSession qSession, String testName) {
        this.result = false;
        try {
            Principal cp = this.mdc.getCallerPrincipal();
            TestUtil.logTrace((String)"CMT MDB getCallerPrincipal() Test Succeeded!");
            this.result = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CMT MDB getCallerPrincipal() Test Failed!", (Throwable)e);
        }
        JmsUtil.sendTestResults((String)testName, (boolean)this.result, (QueueSession)qSession, (Queue)this.queueR);
    }

    public void runGetEJBHome(Message msg, QueueSession qSession, String testName) {
        this.result = false;
        try {
            EJBHome home = this.mdc.getEJBHome();
            TestUtil.logErr((String)"CMT MDB getEJBHome() Test Failed!");
        }
        catch (IllegalStateException e) {
            TestUtil.logTrace((String)"CMT MDB getEJBHome() Test Succeeded!");
            TestUtil.logTrace((String)"Got expected IllegalStateException!");
            this.result = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception: ", (Throwable)e);
        }
        JmsUtil.sendTestResults((String)testName, (boolean)this.result, (QueueSession)qSession, (Queue)this.queueR);
    }

    public void runBeginAgain(Message msg, QueueSession qSession, String testName) {
        this.result = false;
        try {
            UserTransaction ut = this.mdc.getUserTransaction();
            ut.begin();
            try {
                ut.begin();
                TestUtil.logErr((String)"BMT MDB getRollbackOnly() Test Failed!");
            }
            catch (NotSupportedException e) {
                TestUtil.logTrace((String)"BMT MDB getRollbackOnly() Test Succeeded!");
                TestUtil.logTrace((String)"Got expected NotSupportedException!");
                this.result = true;
            }
            ut.rollback();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception: ", (Throwable)e);
        }
        JmsUtil.sendTestResults((String)testName, (boolean)this.result, (QueueSession)qSession, (Queue)this.queueR);
    }
}

