/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.appclient.jmscontexttopictests;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.core20.appclient.jmscontexttopictests.MyCompletionListener;
import com.sun.ts.tests.jms.core20.appclient.jmscontexttopictests.MyCompletionListener2;
import com.sun.ts.tests.jms.core20.appclient.jmscontexttopictests.MyExceptionListener;
import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidClientIDRuntimeException;
import jakarta.jms.InvalidDestinationRuntimeException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

public class Client
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core20.appclient.jmscontexttopictests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private transient JmsTool tool2 = null;
    private transient ConnectionFactory cf = null;
    private transient ConnectionFactory cf2 = null;
    private transient Topic topic = null;
    private transient Destination destination = null;
    private transient JMSContext context = null;
    private transient JMSContext context2 = null;
    private transient JMSContext contextD = null;
    private transient JMSConsumer consumer = null;
    private transient JMSProducer producer = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    ArrayList connections = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private String printSessionMode(int sessionMode) {
        switch (sessionMode) {
            case 0: {
                return "SESSION_TRANSACTED";
            }
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
        }
        return "UNEXPECTED_SESSIONMODE";
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            String lookupDurableTopicFactory = "DURABLE_SUB_CONNECTION_FACTORY";
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.connections = new ArrayList(5);
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_T setup");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.topic = (Topic)this.destination;
            this.tool.getDefaultConnection().close();
            TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_T and durable topic connection factory");
            this.tool2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.tool2.getDefaultConnection().close();
            this.cf2 = this.tool2.getConnectionFactory();
            this.contextD = this.cf2.createContext(this.user, this.password, 1);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new Exception("setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            TestUtil.logMsg((String)"Close JMSContext objects");
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
            if (this.contextD != null) {
                this.contextD.close();
                this.contextD = null;
            }
            TestUtil.logMsg((String)"Close JMSConsumer objects");
            if (this.consumer != null) {
                this.consumer.close();
                this.consumer = null;
            }
            this.tool.closeAllResources();
            this.tool2.closeAllResources();
            this.producer = null;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new Exception("cleanup failed!", e);
        }
    }

    public void setGetClientIDTest() throws Exception {
        boolean pass = true;
        try {
            String clientid = "myclientid";
            TestUtil.logMsg((String)("Calling setClientID(" + clientid + ")"));
            this.context.setClientID(clientid);
            TestUtil.logMsg((String)("Calling getClientID and expect " + clientid + " to be returned"));
            String cid = this.context.getClientID();
            if (!cid.equals(clientid)) {
                TestUtil.logErr((String)("getClientID() returned " + cid + ", expected " + clientid));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new Exception("setGetClientIDTest");
        }
        if (!pass) {
            throw new Exception("setGetClientIDTest failed");
        }
    }

    public void setClientIDLateTest() throws Exception {
        boolean pass = true;
        try {
            String message = "This is my message.";
            TestUtil.logMsg((String)"Creating JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"Creating JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "setClientIDLateTest");
            TestUtil.logMsg((String)"Calling JMSProduce.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                TestUtil.logMsg((String)("actTextMessage=" + actTextMessage.getText()));
            }
            TestUtil.logTrace((String)"Attempt to set Client ID too late (expect IllegalStateRuntimeException)");
            try {
                this.context.setClientID("setClientIDLateTest");
                pass = false;
                TestUtil.logErr((String)"IllegalStateRuntimeException was not thrown");
            }
            catch (IllegalStateRuntimeException is) {
                TestUtil.logMsg((String)"IllegalStateRuntimeException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Incorrect exception received: " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("setClientIDLateTest", e);
        }
        if (!pass) {
            throw new Exception("setClientIDLateTest failed");
        }
    }

    public void setClientIDOnAdminConfiguredIDTest() throws Exception {
        boolean pass = true;
        try {
            String clientid = "myclientid";
            TestUtil.logMsg((String)"Try setting ClientID on JMSContext administratively configured with ClientID (expect IllegalStateRuntimeException)");
            this.contextD.setClientID(clientid);
            TestUtil.logErr((String)"Did not throw expected IllegalStateRuntimeException");
            pass = false;
            String cid = this.contextD.getClientID();
            if (cid == null) {
                TestUtil.logErr((String)"getClientID returned null (expected cts)");
                pass = false;
            } else if (!cid.equals("cts")) {
                TestUtil.logErr((String)("getClientID() returned " + cid + ", expected cts"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"getClientID returned cts (Correct)");
            }
        }
        catch (IllegalStateRuntimeException is) {
            TestUtil.logMsg((String)"IllegalStateRuntimeException thrown as expected");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Incorrect exception received: " + e));
            throw new Exception("setClientIDOnAdminConfiguredIDTest");
        }
        if (!pass) {
            throw new Exception("setClientIDOnAdminConfiguredIDTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGetChangeClientIDTest() throws Exception {
        boolean pass = true;
        String lookup = "MyTopicConnectionFactory";
        try {
            TestUtil.logMsg((String)"Create second JMSContext with AUTO_ACKNOWLEDGE");
            this.context2 = this.cf.createContext(this.user, this.password, 1);
            TestUtil.logMsg((String)"Setting clientID!");
            this.context.setClientID("ctstest");
            TestUtil.logMsg((String)"Getting clientID!");
            String clientid = this.context.getClientID();
            if (!clientid.equals("ctstest")) {
                TestUtil.logErr((String)("getClientID() returned " + clientid + ", expected ctstest"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"setClientID/getClientID correct");
            }
            TestUtil.logMsg((String)"Resetting clientID! (expect IllegalStateRuntimeException)");
            this.context.setClientID("changeIt");
            TestUtil.logErr((String)"No exception was thrown on ClientID reset");
            pass = false;
        }
        catch (IllegalStateRuntimeException e) {
            TestUtil.logMsg((String)"IllegalStateRuntimeException thrown as expected");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Incorrect exception received: " + e));
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"Set clientID on second context to value of clientID on first context (expect InvalidClientIDRuntimeException)");
            this.context2.setClientID("ctstest");
            TestUtil.logErr((String)"No exception was thrown on ClientID that already exists");
            pass = false;
        }
        catch (InvalidClientIDRuntimeException e) {
            TestUtil.logMsg((String)"InvalidClientIDRuntimeException thrown as expected");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Incorrect exception received: " + e));
            pass = false;
        }
        finally {
            try {
                if (this.context2 != null) {
                    this.context2.close();
                    this.context2 = null;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception in finally block: " + e));
                throw new Exception("setGetChangeClientIDTest", e);
            }
        }
        if (!pass) {
            throw new Exception("setGetChangeClientIDTest");
        }
    }

    public void setGetExceptionListenerTest() throws Exception {
        boolean pass = true;
        try {
            MyExceptionListener expExceptionListener = new MyExceptionListener();
            TestUtil.logMsg((String)("Calling setExceptionListener(" + expExceptionListener + ")"));
            this.context.setExceptionListener((ExceptionListener)expExceptionListener);
            TestUtil.logMsg((String)("Calling getExceptionListener and expect " + expExceptionListener + " to be returned"));
            MyExceptionListener actExceptionListener = (MyExceptionListener)this.context.getExceptionListener();
            if (!actExceptionListener.equals(expExceptionListener)) {
                TestUtil.logErr((String)("getExceptionListener() returned " + actExceptionListener + ", expected " + expExceptionListener));
                pass = false;
            }
            TestUtil.logMsg((String)"Calling setExceptionListener(null)");
            this.context.setExceptionListener(null);
            if (this.context.getExceptionListener() != null) {
                TestUtil.logErr((String)("getExceptionListener() returned " + this.context.getExceptionListener() + ", expected null"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("setGetExceptionListenerTest");
        }
        if (!pass) {
            throw new Exception("setGetExceptionListenerTest failed");
        }
    }

    public void setGetAsyncTest() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Creating JMSProducer");
            this.producer = this.context.createProducer();
            MyCompletionListener expCompletionListener = new MyCompletionListener();
            TestUtil.logMsg((String)("Calling JMSProducer.setAsync(" + expCompletionListener + ")"));
            this.producer.setAsync((CompletionListener)expCompletionListener);
            TestUtil.logMsg((String)("Calling JMSProducer.getAsync() and expect " + expCompletionListener + " to be returned"));
            MyCompletionListener actCompletionListener = (MyCompletionListener)this.producer.getAsync();
            if (!actCompletionListener.equals(expCompletionListener)) {
                TestUtil.logErr((String)("getAsync() returned " + actCompletionListener + ", expected " + expCompletionListener));
                pass = false;
            }
            TestUtil.logMsg((String)"Calling setAsync(null)");
            this.producer.setAsync(null);
            TestUtil.logMsg((String)"Calling JMSProducer.getAsync() and expect NULL to be returned");
            if (this.producer.getAsync() != null) {
                TestUtil.logErr((String)("getAsync() returned " + this.producer.getAsync() + ", expected null"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("setGetAsyncTest");
        }
        if (!pass) {
            throw new Exception("setGetAsyncTest failed");
        }
    }

    public void startStopTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage tempMsg = null;
            TestUtil.logMsg((String)"Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"Call stop() to stop delivery of incoming messages");
            this.context.stop();
            TestUtil.logMsg((String)"Creating JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Send 3 messages to Topic");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "startStopTest" + i);
                this.producer.send(this.destination, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Try consuming a message on a STOPPED connection");
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            if (tempMsg != null) {
                TestUtil.logErr((String)"Received a message on a STOPPED connection");
                TestUtil.logErr((String)("Message is: " + tempMsg.getText()));
                pass = false;
            }
            TestUtil.logMsg((String)"Call start() to start delivery of incoming messages");
            this.context.start();
            TestUtil.logMsg((String)"Consume all the messages in the Topic on a STARTED connection");
            for (int msgCount = 1; msgCount <= 3; ++msgCount) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
                if (tempMsg == null) {
                    TestUtil.logErr((String)"JMSConsumer.receive() returned NULL");
                    TestUtil.logErr((String)("Message " + msgCount + " missing from Topic"));
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]"));
                    pass = false;
                    continue;
                }
                TestUtil.logMsg((String)("Received message: " + tempMsg.getText()));
            }
            TestUtil.logMsg((String)"Topic should now be empty");
            TestUtil.logMsg((String)"Try consuming one more message should return NULL");
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            if (tempMsg != null) {
                TestUtil.logErr((String)"JMSConsumer.receive() did not return NULL");
                TestUtil.logErr((String)"JMSConsumer.receive() returned a message (unexpected)");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("startStopTest");
        }
        if (!pass) {
            throw new Exception("startStopTest failed");
        }
    }

    public void createContextTest() throws Exception {
        boolean pass = true;
        try {
            JMSContext newContext = null;
            int[] expSessionMode = new int[]{0, 1, 2, 3};
            for (int i = 0; i < expSessionMode.length; ++i) {
                TestUtil.logMsg((String)("Creating context with session mode (" + this.printSessionMode(expSessionMode[i]) + ")"));
                TestUtil.logMsg((String)"Call API TopicConnectionFactory.createContext(int)");
                newContext = this.context.createContext(expSessionMode[i]);
                TestUtil.logMsg((String)"Now call API JMSContext.getSessionMode()");
                TestUtil.logMsg((String)("Calling getSessionMode and expect " + this.printSessionMode(expSessionMode[i]) + " to be returned"));
                int actSessionMode = newContext.getSessionMode();
                if (actSessionMode != expSessionMode[i]) {
                    TestUtil.logErr((String)("getSessionMode() returned " + this.printSessionMode(actSessionMode) + ", expected " + this.printSessionMode(expSessionMode[i])));
                    pass = false;
                }
                newContext.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("createContextTest");
        }
        if (!pass) {
            throw new Exception("createContextTest failed");
        }
    }

    public void sendAndRecvCLTest1() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        try {
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvCLTest1");
            MyCompletionListener listener = new MyCompletionListener();
            TestUtil.logMsg((String)"Creating JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Set primitive property types on JMSProducer");
            this.producer.setProperty("TESTBOOLEAN", bool);
            this.producer.setProperty("TESTBYTE", bValue);
            this.producer.setProperty("TESTDOUBLE", nDouble);
            this.producer.setProperty("TESTFLOAT", nFloat);
            this.producer.setProperty("TESTINT", nInt);
            this.producer.setProperty("TESTLONG", nLong);
            this.producer.setProperty("TESTSHORT", nShort);
            this.producer.setProperty("TESTSTRING", "test");
            TestUtil.logMsg((String)"Set Object property types on JMSProducer");
            this.producer.setProperty("OBJTESTBOOLEAN", (Object)bool);
            this.producer.setProperty("OBJTESTBYTE", (Object)bValue);
            this.producer.setProperty("OBJTESTDOUBLE", (Object)nDouble);
            this.producer.setProperty("OBJTESTFLOAT", (Object)Float.valueOf(nFloat));
            this.producer.setProperty("OBJTESTINT", (Object)nInt);
            this.producer.setProperty("OBJTESTLONG", (Object)nLong);
            this.producer.setProperty("OBJTESTSHORT", (Object)nShort);
            this.producer.setProperty("OBJTESTSTRING", "test");
            TestUtil.logMsg((String)"Calling JMSProducer.setAsync(CompletionListener)");
            this.producer.setAsync((CompletionListener)listener);
            TestUtil.logMsg((String)"Calling JMSProducer.send(Destination,Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Poll listener until we receive TextMessage");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
            TestUtil.logMsg((String)"Retrieve and verify that TextMessage message properties were set correctly");
            if (actTextMessage.getBooleanProperty("TESTBOOLEAN") == bool) {
                TestUtil.logMsg((String)"Pass: getBooleanProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getBooleanProperty");
                pass = false;
            }
            if (actTextMessage.getByteProperty("TESTBYTE") == bValue) {
                TestUtil.logMsg((String)"Pass: getByteProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getByteProperty");
                pass = false;
            }
            if (actTextMessage.getLongProperty("TESTLONG") == nLong) {
                TestUtil.logMsg((String)"Pass: getLongProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getLongProperty");
                pass = false;
            }
            if (actTextMessage.getStringProperty("TESTSTRING").equals(testString)) {
                TestUtil.logMsg((String)"Pass: getStringProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getStringProperty");
                pass = false;
            }
            if (actTextMessage.getDoubleProperty("TESTDOUBLE") == nDouble) {
                TestUtil.logMsg((String)"Pass: getDoubleProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getDoubleProperty");
                pass = false;
            }
            if (actTextMessage.getFloatProperty("TESTFLOAT") == nFloat) {
                TestUtil.logMsg((String)"Pass: getFloatProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getFloatProperty");
                pass = false;
            }
            if (actTextMessage.getIntProperty("TESTINT") == nInt) {
                TestUtil.logMsg((String)"Pass: getIntProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getIntProperty");
                pass = false;
            }
            if (actTextMessage.getShortProperty("TESTSHORT") == nShort) {
                TestUtil.logMsg((String)"Pass: getShortProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect value returned from getShortProperty");
                pass = false;
            }
            if ((Boolean)actTextMessage.getObjectProperty("OBJTESTBOOLEAN") == bool) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct Boolean value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect Boolean value returned from getObjectProperty");
                pass = false;
            }
            if ((Byte)actTextMessage.getObjectProperty("OBJTESTBYTE") == bValue) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct Byte value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect Byte value returned from getObjectProperty");
                pass = false;
            }
            if ((Long)actTextMessage.getObjectProperty("OBJTESTLONG") == nLong) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct Long value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect Long value returned from getObjectProperty");
                pass = false;
            }
            if (((String)actTextMessage.getObjectProperty("OBJTESTSTRING")).equals(testString)) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct String value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect String value returned from getObjectProperty");
                pass = false;
            }
            if ((Double)actTextMessage.getObjectProperty("OBJTESTDOUBLE") == nDouble) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct Double value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect Double value returned from getObjectProperty");
                pass = false;
            }
            if (((Float)actTextMessage.getObjectProperty("OBJTESTFLOAT")).floatValue() == nFloat) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct Float value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect Float value returned from getObjectProperty");
                pass = false;
            }
            if ((Integer)actTextMessage.getObjectProperty("OBJTESTINT") == nInt) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct Integer value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect Integer value returned from getObjectProperty");
                pass = false;
            }
            if ((Short)actTextMessage.getObjectProperty("OBJTESTSHORT") == nShort) {
                TestUtil.logMsg((String)"Pass: getObjectProperty returned correct Short value");
            } else {
                TestUtil.logMsg((String)"Fail: incorrect Short value returned from getObjectProperty");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvCLTest1", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvCLTest1 failed");
        }
    }

    public void sendAndRecvCLTest2() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvCLTest2");
            MyCompletionListener listener = new MyCompletionListener();
            TestUtil.logMsg((String)"Creating JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Calling JMSProducer.setAsync(CompletionListener)");
            this.producer.setAsync((CompletionListener)listener);
            TestUtil.logMsg((String)"Set delivery mode, priority, and time to live");
            this.producer.setDeliveryMode(2);
            this.producer.setPriority(4);
            this.producer.setTimeToLive(0L);
            TestUtil.logMsg((String)"Calling JMSProducer.send(Destination,Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Poll listener until we receive TextMessage");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 2 || actTextMessage.getJMSPriority() != 4 || actTextMessage.getJMSExpiration() != 0L) {
                TestUtil.logErr((String)"Didn't get the right message.");
                TestUtil.logErr((String)("text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText()));
                TestUtil.logErr((String)("DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode()));
                TestUtil.logErr((String)("Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority()));
                TestUtil.logErr((String)("TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration()));
                pass = false;
            } else {
                TestUtil.logMsg((String)"TextMessage is correct");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvCLTest2", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvCLTest2 failed");
        }
    }

    public void sendAndRecvMsgOfEachTypeCLTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Send and receive Message");
            Message msg = this.context.createMessage();
            TestUtil.logMsg((String)"Set some values in Message");
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            msg.setBooleanProperty("booleanProperty", true);
            MyCompletionListener2 listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, msg);
            TestUtil.logMsg((String)"Poll listener until we receive Message");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            Message actMessage = null;
            if (listener.isComplete()) {
                actMessage = listener.getMessage();
            }
            if (actMessage == null) {
                TestUtil.logErr((String)"Did not receive Message");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in Message");
                if (actMessage.getBooleanProperty("booleanProperty")) {
                    TestUtil.logMsg((String)"booleanproperty is correct");
                } else {
                    TestUtil.logMsg((String)"booleanproperty is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send and receive BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            TestUtil.logMsg((String)"Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            bMsg.reset();
            listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, (Message)bMsg);
            TestUtil.logMsg((String)"Poll listener until we receive BytesMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            BytesMessage bMsgRecv = null;
            if (listener.isComplete()) {
                bMsgRecv = (BytesMessage)listener.getMessage();
            }
            if (bMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive BytesMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in BytesMessage");
                if (bMsgRecv.readByte() == 1) {
                    TestUtil.logMsg((String)"bytevalue is correct");
                } else {
                    TestUtil.logMsg((String)"bytevalue is incorrect");
                    pass = false;
                }
                if (bMsgRecv.readInt() == 22) {
                    TestUtil.logMsg((String)"intvalue is correct");
                } else {
                    TestUtil.logMsg((String)"intvalue is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send and receive MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            TestUtil.logMsg((String)"Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, (Message)mMsg);
            TestUtil.logMsg((String)"Poll listener until we receive MapMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            MapMessage mMsgRecv = null;
            if (listener.isComplete()) {
                mMsgRecv = (MapMessage)listener.getMessage();
            }
            if (mMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive MapMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in MapMessage");
                Enumeration list = mMsgRecv.getMapNames();
                String name = null;
                while (list.hasMoreElements()) {
                    name = (String)list.nextElement();
                    if (name.equals("booleanvalue")) {
                        if (mMsgRecv.getBoolean(name)) {
                            TestUtil.logMsg((String)"booleanvalue is correct");
                            continue;
                        }
                        TestUtil.logErr((String)"booleanvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    if (name.equals("intvalue")) {
                        if (mMsgRecv.getInt(name) == 10) {
                            TestUtil.logMsg((String)"intvalue is correct");
                            continue;
                        }
                        TestUtil.logErr((String)"intvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    TestUtil.logErr((String)("Unexpected name of [" + name + "] in MapMessage"));
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send and receive ObjectMessage");
            StringBuffer sb1 = new StringBuffer("This is a StringBuffer");
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            ObjectMessage oMsg = this.context.createObjectMessage();
            oMsg.setObject((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, (Message)oMsg);
            TestUtil.logMsg((String)"Poll listener until we receive ObjectMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            ObjectMessage oMsgRecv = null;
            if (listener.isComplete()) {
                oMsgRecv = (ObjectMessage)listener.getMessage();
            }
            if (oMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive ObjectMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in ObjectMessage");
                StringBuffer sb2 = (StringBuffer)oMsgRecv.getObject();
                if (sb2.toString().equals(sb1.toString())) {
                    TestUtil.logMsg((String)"objectvalue is correct");
                } else {
                    TestUtil.logErr((String)"objectvalue is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send and receive StreamMessage");
            StreamMessage sMsg = this.context.createStreamMessage();
            TestUtil.logMsg((String)"Set some values in StreamMessage");
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            sMsg.writeBoolean(true);
            sMsg.writeInt(22);
            sMsg.reset();
            listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, (Message)sMsg);
            TestUtil.logMsg((String)"Poll listener until we receive StreamMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            StreamMessage sMsgRecv = null;
            if (listener.isComplete()) {
                sMsgRecv = (StreamMessage)listener.getMessage();
            }
            if (sMsgRecv == null) {
                TestUtil.logErr((String)"Did not receive StreamMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in StreamMessage");
                if (sMsgRecv.readBoolean()) {
                    TestUtil.logMsg((String)"booleanvalue is correct");
                } else {
                    TestUtil.logMsg((String)"booleanvalue is incorrect");
                    pass = false;
                }
                if (sMsgRecv.readInt() == 22) {
                    TestUtil.logMsg((String)"intvalue is correct");
                } else {
                    TestUtil.logMsg((String)"intvalue is incorrect");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Send and receive TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            TestUtil.logMsg((String)"Calling JMSProducer.send(Destination,Message)");
            listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Poll listener until we receive TextMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            TextMessage actTextMessage = null;
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the values in TextMessage");
            if (!actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logErr((String)"Didn't get the right message.");
                TestUtil.logErr((String)("text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText()));
                pass = false;
            } else {
                TestUtil.logMsg((String)"TextMessage is correct");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvMsgOfEachTypeCLTest", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvMsgOfEachTypeCLTest failed");
        }
    }

    public void messageOrderCLTopicTest() throws Exception {
        boolean pass = true;
        try {
            int i;
            String[] text = new String[3];
            TestUtil.logMsg((String)"Creating MyCompletionListener");
            MyCompletionListener listener = new MyCompletionListener(3);
            TestUtil.logMsg((String)"Creating JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Calling JMSProducer.setAsync(CompletionListener)");
            this.producer.setAsync((CompletionListener)listener);
            TestUtil.logMsg((String)"Sending 3 asynchronous messages to topic");
            for (i = 0; i < 3; ++i) {
                text[i] = "message order test " + i;
                TextMessage sentTextMessage = this.context.createTextMessage();
                sentTextMessage.setText(text[i]);
                sentTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "messageOrderCLTopicTest" + i);
                TestUtil.logMsg((String)("Sending TextMessage: " + sentTextMessage.getText()));
                this.producer.send(this.destination, (Message)sentTextMessage);
            }
            TestUtil.logMsg((String)"Poll listener until we receive all 3 TextMessage's from topic");
            for (i = 0; !listener.gotAllMsgs() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            for (i = 0; i < 3; ++i) {
                TextMessage actTextMessage = null;
                if (listener.haveMsg(i)) {
                    actTextMessage = (TextMessage)listener.getMessage(i);
                }
                if (actTextMessage == null) {
                    TestUtil.logMsg((String)("Did not receive TextMessage " + i + " (unexpected)"));
                    pass = false;
                    continue;
                }
                TestUtil.logMsg((String)("Received message: " + actTextMessage.getText()));
                if (actTextMessage.getText().equals(text[i])) continue;
                TestUtil.logMsg((String)("Received message: " + actTextMessage.getText()));
                TestUtil.logMsg((String)("Should have received: " + text[i]));
                TestUtil.logErr((String)"Received wrong message (wrong order)");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("messageOrderCLTopicTest", e);
        }
        if (!pass) {
            throw new Exception("messageOrderCLTopicTest failed");
        }
    }

    public void acknowledgeTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        JMSContext msgcontext = null;
        JMSProducer msgproducer = null;
        JMSConsumer msgconsumer = null;
        try {
            msgcontext = this.cf.createContext(this.user, this.password, 2);
            msgproducer = msgcontext.createProducer();
            msgconsumer = msgcontext.createConsumer((Destination)this.topic);
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = msgcontext.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "acknowledgeTest");
            TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Message)");
            msgproducer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)msgconsumer.receive(this.timeout);
            TestUtil.logMsg((String)("Received message: " + actTextMessage.getText()));
            TestUtil.logMsg((String)"Calling acknowlege to acknowledge message.");
            msgcontext.acknowledge();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("acknowledgeTest", e);
        }
        finally {
            try {
                if (msgconsumer != null) {
                    msgconsumer.close();
                }
                if (msgcontext != null) {
                    msgcontext.close();
                }
                msgproducer = null;
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("acknowledgeTest failed");
        }
    }

    public void commitRollbackTest() throws Exception {
        boolean pass = true;
        try {
            int i;
            TextMessage tempMsg = null;
            this.context.close();
            TestUtil.logMsg((String)"Create transacted JMSContext, JMSConsumer and JMSProducer");
            this.context = this.cf.createContext(this.user, this.password, 0);
            this.producer = this.context.createProducer();
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"Send 3 messages to Topic and call rollback()");
            for (i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "commitRollbackTest" + i);
                this.producer.send(this.destination, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Calling rollback() to rollback the sent messages");
            this.context.rollback();
            TestUtil.logMsg((String)"Should not consume any messages in Topic since rollback() was called");
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            if (tempMsg != null) {
                TestUtil.logErr((String)("Received message " + tempMsg.getText() + ", expected NULL (NO MESSAGES)"));
                pass = false;
            }
            TestUtil.logMsg((String)"Send 3 messages to Topic and call commit()");
            for (i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "commitRollbackTest" + i);
                this.producer.send(this.destination, (Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            TestUtil.logMsg((String)"Calling commit() to commit the sent messages");
            this.context.commit();
            TestUtil.logMsg((String)"Should consume all messages in Topic since commit() was called");
            for (int msgCount = 1; msgCount <= 3; ++msgCount) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
                if (tempMsg == null) {
                    TestUtil.logErr((String)"JMSConsumer.receive() returned NULL");
                    TestUtil.logErr((String)("Message " + msgCount + " missing from Topic"));
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]"));
                    pass = false;
                    continue;
                }
                TestUtil.logMsg((String)("Received message: " + tempMsg.getText()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("commitRollbackTest");
        }
        if (!pass) {
            throw new Exception("commitRollbackTest failed");
        }
    }

    public void invalidDestinationRuntimeExceptionTests() throws Exception {
        boolean pass;
        block9: {
            pass = true;
            Destination invalidDestination = null;
            Object invalidTopic = null;
            String message = "Where are you!";
            HashMap<String, Object> mapMsgSend = new HashMap<String, Object>();
            mapMsgSend.put("StringValue", "sendAndRecvTest7");
            mapMsgSend.put("BooleanValue", true);
            mapMsgSend.put("IntValue", 10);
            try {
                TestUtil.logMsg((String)"Creating JMSConsumer");
                this.consumer = this.context.createConsumer(this.destination);
                TestUtil.logMsg((String)"Creating JMSProducer");
                this.producer = this.context.createProducer();
                TestUtil.logMsg((String)"Creating TextMessage");
                TextMessage expTextMessage = this.context.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "invalidDestinationRuntimeExceptionTests");
                MyCompletionListener listener = new MyCompletionListener();
                TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, Message) for InvalidDestinationRuntimeException");
                try {
                    TestUtil.logMsg((String)"Calling JMSProducer.setAsync(CompletionListener)");
                    this.producer.setAsync((CompletionListener)listener);
                    TestUtil.logMsg((String)"Calling JMSProducer.send(Destination, Message) -> expect InvalidDestinationRuntimeException");
                    this.producer.send(invalidDestination, (Message)expTextMessage);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    Exception exception = null;
                    for (int i = 0; i < 30 && !listener.isComplete(); ++i) {
                        TestUtil.sleepSec((int)2);
                    }
                    exception = listener.getException();
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block9;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof InvalidDestinationRuntimeException) {
                        TestUtil.logMsg((String)"Exception is expected InvalidDestinationRuntimeException");
                        break block9;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected InvalidDestinationRuntimeException, received " + exception.getCause()));
                    pass = false;
                }
                catch (InvalidDestinationRuntimeException e) {
                    TestUtil.logMsg((String)"Got InvalidDestinationRuntimeException as expected.");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected InvalidDestinationRuntimeException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                throw new Exception("invalidDestinationRuntimeExceptionTests", e);
            }
        }
        if (!pass) {
            throw new Exception("invalidDestinationRuntimeExceptionTests failed");
        }
    }

    public void messageFormatRuntimeExceptionTests() throws Exception {
        boolean pass;
        block9: {
            pass = true;
            try {
                TestUtil.logMsg((String)"Creating JMSConsumer");
                this.consumer = this.context.createConsumer(this.destination);
                TestUtil.logMsg((String)"Creating JMSProducer");
                this.producer = this.context.createProducer();
                MyCompletionListener listener = new MyCompletionListener();
                TestUtil.logMsg((String)"Testing JMSProducer.send(Destination, Message) for MessageFormatRuntimeException");
                try {
                    TestUtil.logMsg((String)"Calling JMSProducer.setAsync(CompletionListener)");
                    this.producer.setAsync((CompletionListener)listener);
                    TestUtil.logMsg((String)"Calling JMSProducer.send(Destination, Message) -> expect MessageFormatRuntimeException");
                    this.producer.send(this.destination, (Message)null);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    Throwable exception = null;
                    for (int i = 0; i < 30 && !listener.isComplete(); ++i) {
                        TestUtil.sleepSec((int)2);
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block9;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof MessageFormatRuntimeException) {
                        TestUtil.logMsg((String)"Exception is expected MessageFormatRuntimeException");
                        break block9;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected MessageFormatRuntimeException, received " + exception.getCause()));
                    pass = false;
                }
                catch (MessageFormatRuntimeException e) {
                    TestUtil.logMsg((String)"Got MessageFormatRuntimeException as expected.");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected MessageFormatRuntimeException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                throw new Exception("messageFormatRuntimeExceptionTests", e);
            }
        }
        if (!pass) {
            throw new Exception("messageFormatRuntimeExceptionTests failed");
        }
    }

    public void jMSRuntimeExceptionTests() throws Exception {
        boolean pass;
        block17: {
            pass = true;
            String message = "Where are you!";
            try {
                int i;
                Throwable exception;
                TestUtil.logMsg((String)"Creating JMSConsumer");
                this.consumer = this.context.createConsumer(this.destination);
                TestUtil.logMsg((String)"Creating JMSProducer");
                this.producer = this.context.createProducer();
                MyCompletionListener listener = new MyCompletionListener();
                TestUtil.logMsg((String)"Creating TextMessage");
                TextMessage expTextMessage = this.context.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "jMSRuntimeExceptionTests");
                try {
                    TestUtil.logMsg((String)"Set completion listener");
                    TestUtil.logMsg((String)"Calling JMSProducer.setAsync(CompletionListener)");
                    this.producer.setAsync((CompletionListener)listener);
                    TestUtil.logMsg((String)"Try and set an invalid delivery mode of -1 on send");
                    this.producer.setDeliveryMode(-1);
                    TestUtil.logMsg((String)"Calling JMSProducer.send(Destination, Message) -> expect JMSRuntimeException");
                    this.producer.send(this.destination, (Message)expTextMessage);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30 && !listener.isComplete(); ++i) {
                        TestUtil.sleepSec((int)2);
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof JMSRuntimeException) {
                            TestUtil.logMsg((String)"Exception is expected JMSRuntimeException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected JMSRuntimeException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (JMSRuntimeException e) {
                    TestUtil.logMsg((String)"Caught expected JMSRuntimeException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected JMSRuntimeException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Set completion listener");
                    TestUtil.logMsg((String)"Calling JMSProducer.setAsync(CompletionListener)");
                    this.producer.setAsync((CompletionListener)listener);
                    TestUtil.logMsg((String)"Try and set an invalid priority of -1 on send");
                    this.producer.setDeliveryMode(1);
                    this.producer.setPriority(-1);
                    TestUtil.logMsg((String)"Calling JMSProducer.send(Destination, Message) -> expect JMSRuntimeException");
                    this.producer.send(this.destination, (Message)expTextMessage);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30 && !listener.isComplete(); ++i) {
                        TestUtil.sleepSec((int)2);
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block17;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof JMSRuntimeException) {
                        TestUtil.logMsg((String)"Exception is expected JMSRuntimeException");
                        break block17;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected JMSRuntimeException, received " + exception.getCause()));
                    pass = false;
                }
                catch (JMSRuntimeException e) {
                    TestUtil.logMsg((String)"Caught expected JMSRuntimeException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected JMSRuntimeException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                throw new Exception("jMSRuntimeExceptionTests", e);
            }
        }
        if (!pass) {
            throw new Exception("jMSRuntimeExceptionTests failed");
        }
    }
}

