/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.propagation.am;

import ee.jakarta.tck.persistence.ee.propagation.am.Stateful3IF;
import ee.jakarta.tck.persistence.ee.propagation.am.Stateful3IF2;
import ee.jakarta.tck.persistence.ee.propagation.am.Stateless3IF;
import jakarta.ejb.EJB;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.jupiter.api.Test;

@Dependent
public class Client {
    private static Logger log = Logger.getLogger(Client.class.getName());
    @Dependent
    @Inject
    Instance<Stateful3IF> statefulBeanInstance;
    Stateful3IF statefulBean;
    @Dependent
    @Inject
    Instance<Stateful3IF2> statefulBean2Instance;
    Stateful3IF2 statefulBean2;
    @EJB(name="ejb/Stateless3Bean", beanInterface=Stateless3IF.class)
    Stateless3IF statelessBean;
    private Properties props;

    public void setup() throws Exception {
    }

    @Test
    public void test1() throws Exception {
        log.info("Begin test1");
        boolean pass = false;
        try {
            this.statelessBean.init(this.props);
            this.statelessBean.doCleanup();
            pass = this.statelessBean.test1();
            this.statelessBean.doCleanup();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unexpected Exception :", e);
            throw e;
        }
        if (!pass) {
            throw new Exception("test1 failed");
        }
    }

    @Test
    public void test2() throws Exception {
        log.info("Begin test2");
        boolean pass = false;
        try {
            this.statelessBean.init(this.props);
            this.statelessBean.doCleanup();
            pass = this.statelessBean.test2();
            this.statelessBean.doCleanup();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unexpected Exception :", e);
            throw e;
        }
        if (!pass) {
            throw new Exception("test2 failed");
        }
    }

    @Test
    public void test3() throws Exception {
        log.info("Begin test3");
        boolean pass = false;
        try {
            this.statefulBean = (Stateful3IF)this.statefulBeanInstance.get();
            this.statefulBean.init(this.props);
            pass = this.statefulBean.test3();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unexpected Exception :", e);
            throw e;
        }
        if (!pass) {
            throw new Exception("test3 failed");
        }
    }

    @Test
    public void test4() throws Exception {
        log.info("Begin test4");
        boolean pass = false;
        try {
            this.statefulBean = (Stateful3IF)this.statefulBeanInstance.get();
            this.statefulBean.init(this.props);
            pass = this.statefulBean.test4();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unexpected Exception :", e);
            throw e;
        }
        finally {
            this.cleanup();
        }
        if (!pass) {
            throw new Exception("test4 failed");
        }
    }

    @Test
    public void test5() throws Exception {
        boolean pass = false;
        try {
            this.statefulBean2 = (Stateful3IF2)this.statefulBean2Instance.get();
            this.statefulBean2.init(this.props);
            pass = this.statefulBean2.test5();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unexpected Exception :", e);
            throw e;
        }
        finally {
            this.cleanup();
        }
        if (!pass) {
            throw new Exception("test5 failed");
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.statefulBean != null) {
                this.statefulBeanInstance.destroy((Object)this.statefulBean);
                this.statefulBean = null;
            }
        }
        catch (Exception re) {
            log.log(Level.WARNING, "Unexpected Exception in entity cleanup:", re);
        }
        try {
            if (this.statefulBean2 != null) {
                this.statefulBean2Instance.destroy((Object)this.statefulBean2);
                this.statefulBean2 = null;
            }
        }
        catch (Exception re) {
            log.log(Level.WARNING, "Unexpected Exception in entity cleanup:", re);
        }
        log.info("cleanup complete");
    }
}

