/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.basictype;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.basictype.Order;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.Type;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void getJavaType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                this.logTrace("Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("id");
                if (attrib != null) {
                    String type = attrib.getJavaType().getName();
                    if (type.equals("int")) {
                        this.logTrace("Received expected type: int");
                        pass = true;
                    } else {
                        this.logErr("Expected: int, actual:" + type);
                    }
                } else {
                    this.logErr("getDeclaredAttribute(...) returned null");
                }
            } else {
                this.logErr("managedType(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaType Test failed");
        }
    }

    public void getPersistenceType() throws Exception {
        boolean pass = false;
        String expected = Type.PersistenceType.ENTITY.name();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(Order.class);
            if (eType != null) {
                Type.PersistenceType type = eType.getPersistenceType();
                if (type != null) {
                    String sType = type.name();
                    if (sType.equals(expected)) {
                        this.logTrace("Received:" + sType);
                        pass = true;
                    } else {
                        this.logErr("Expected: " + expected + ", actual:" + sType);
                    }
                } else {
                    this.logErr("getPersistenceType() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getPersistenceType failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

