/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class PieChart
extends JComponent {
    private int[] slices;
    private Color[] colors;
    private static final int OFFSETX = 7;
    private static final int OFFSETY = 7;
    private static final float MIN_SLICE = 2.0f;

    private PieChart() {
    }

    public PieChart(int[] dist, Color[] colors) {
        this();
        this.setValue(dist, colors);
    }

    public void setValue(int[] dist, Color[] c) {
        if (dist.length != c.length) {
            throw new IllegalArgumentException();
        }
        this.colors = c;
        this.slices = dist;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D imageG = (Graphics2D)((Image)image).getGraphics();
        this.paintPie(imageG);
        imageG.dispose();
        g.drawImage(image, 0, 0, null);
        g.dispose();
    }

    private void paintPie(Graphics2D g2d) {
        int i;
        if (this.isOpaque()) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.slices == null || this.slices.length == 0) {
            return;
        }
        float sum = 0.0f;
        int minIndex = 0;
        int maxIndex = 0;
        for (int i2 = 0; i2 < this.slices.length; ++i2) {
            sum += (float)this.slices[i2];
            if (this.slices[i2] > this.slices[maxIndex]) {
                maxIndex = i2;
            }
            if (this.slices[i2] <= this.slices[minIndex]) continue;
            minIndex = i2;
        }
        if (sum < 0.1f) {
            return;
        }
        Insets inset = this.getInsets();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int maxDia = Math.min(this.getWidth() - inset.left - inset.right, this.getHeight() - inset.top - inset.bottom);
        float targetDia = (float)maxDia * 0.8f;
        float boxX = (float)inset.left + 0.1f * ((float)maxDia - targetDia);
        float boxY = (float)inset.top + 0.1f * ((float)maxDia - targetDia);
        if (this.getWidth() <= this.getHeight()) {
            boxY = (float)(this.getHeight() / 2) - 0.5f * targetDia;
        }
        float gradx = boxX + 7.0f;
        float grady = boxY + 7.0f;
        GradientPaint grad = new GradientPaint(0.0f, 0.0f, Color.decode("#dddddd"), this.getWidth(), this.getHeight(), this.getBackground());
        g2d.setPaint(grad);
        g2d.fill(new Ellipse2D.Float(gradx, grady, targetDia * 0.98f, targetDia * 0.98f));
        float[] dist = new float[this.slices.length];
        for (i = 0; i < this.slices.length; ++i) {
            dist[i] = this.slices[i] == 0 ? 0.0f : ((double)Math.abs((float)this.slices[i] - sum) < 1.0E-7 ? 360.0f : 360.0f * ((float)this.slices[i] / sum));
        }
        for (i = 0; i < dist.length; ++i) {
            if (!(dist[i] > 0.0f) || !(dist[i] < 2.0f)) continue;
            dist[maxIndex] = dist[maxIndex] - (2.0f - dist[i]);
            dist[i] = 2.0f;
        }
        float pos = 90.0f;
        for (int i3 = 0; i3 < this.slices.length; ++i3) {
            if (!((double)dist[i3] > 0.0)) continue;
            g2d.setPaint(this.colors[i3]);
            g2d.fill(new Arc2D.Float(boxX, boxY, targetDia, targetDia, pos, -1.0f * dist[i3], 2));
            if (this.colors[i3].equals(Color.WHITE)) {
                g2d.setPaint(Color.BLACK);
                if (dist[i3] == 360.0f) {
                    g2d.draw(new Ellipse2D.Float(boxX, boxY, targetDia, targetDia));
                } else {
                    g2d.draw(new Arc2D.Float(boxX, boxY, targetDia, targetDia, pos, -1.0f * dist[i3], 2));
                }
            }
            pos -= dist[i3];
        }
    }
}

