/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.module.soap;

import com.sun.ts.tests.jaspic.tssv.util.ClientCallbackSupport;
import com.sun.ts.tests.jaspic.tssv.util.CommonCallbackSupport;
import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.module.ClientAuthModule;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;

public class TSClientAuthModule
implements ClientAuthModule {
    private static TSLogger logger = null;
    private static CallbackHandler callbackHandler = null;
    private static Map options = null;

    public void initialize(MessagePolicy reqPolicy, MessagePolicy resPolicy, CallbackHandler handler, Map optns) throws AuthException {
        callbackHandler = handler;
        options = optns;
        if (options.get("TSLogger") != null) {
            logger = (TSLogger)options.get("TSLogger");
        }
    }

    public Class[] getSupportedMessageTypes() {
        Class[] classarray = new Class[]{SOAPMessage.class};
        this.logMsg("TSClientAuthModule.getSupportedMessageTypes called");
        return classarray;
    }

    public AuthStatus secureRequest(MessageInfo messageInfo, Subject clientSubject) throws AuthException {
        String msg = "";
        msg = clientSubject != null ? "TSClientAuthModule.secureRequest called with client Subject :" + this.getPrincipalNameFromSubject(clientSubject) : "TSClientAuthModule.secureRequest called with null client Subject";
        this.logMsg(msg);
        this.logMessageTypes(messageInfo, "secureRequest");
        ClientCallbackSupport clientCallbackSupport = new ClientCallbackSupport(logger, callbackHandler, "SOAP");
        clientCallbackSupport.verify();
        CommonCallbackSupport commonCallbacks = new CommonCallbackSupport(logger, callbackHandler, "SOAP", "ClientRuntime");
        commonCallbacks.verify();
        Map messageInfoMap = messageInfo.getMap();
        QName qName = (QName)messageInfoMap.get("javax.xml.ws.wsdl.service");
        if (qName != null) {
            String qNameToString = qName.toString();
            msg = "TSClientAuthModule.secureRequest messageInfo :javax.xml.ws.wsdl.service=" + qNameToString;
        } else {
            msg = "TSClientAuthModule.secureRequest messageInfo :** ERROR ** No value found for key javax.xml.ws.wsdl.service in MessageInfoMap : Expected a QName";
        }
        this.logMsg(msg);
        return AuthStatus.SEND_SUCCESS;
    }

    public AuthStatus validateResponse(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        String msg = "";
        msg = clientSubject != null ? "TSClientAuthModule.validateResponse called with client Subject :" + this.getPrincipalNameFromSubject(clientSubject) : "TSClientAuthModule.validateResponse called with null client Subject";
        msg = serviceSubject != null ? msg + " with serviceSubject :" + this.getPrincipalNameFromSubject(serviceSubject) : msg + " with null serviceSubject";
        this.logMsg(msg);
        this.logMessageTypes(messageInfo, "validateResponse");
        Map messageInfoMap = messageInfo.getMap();
        QName qName = (QName)messageInfoMap.get("javax.xml.ws.wsdl.service");
        if (qName != null) {
            String qNameToString = qName.toString();
            msg = "TSClientAuthModule.validateResponse messageInfo :javax.xml.ws.wsdl.service=" + qNameToString;
        } else {
            msg = "TSClientAuthModule.validateResponse messageInfo :** ERROR ** No value found for key javax.xml.ws.wsdl.service in MessageInfoMap : Expected a QName ";
        }
        this.logMsg(msg);
        return AuthStatus.SUCCESS;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        this.logMsg("TSClientAuthModule.cleanSubject called");
        subject = null;
    }

    public void logMsg(String str) {
        if (logger != null) {
            logger.log(Level.INFO, str);
        } else {
            System.out.println("*** TSLogger Not Initialized properly ***");
            System.out.println("*** TSSVLogMessage : ***" + str);
        }
    }

    public String getPrincipalNameFromSubject(Subject sub) {
        Principal principal2 = null;
        String concatPrincipalName = "";
        Set<Principal> principalSet = sub.getPrincipals();
        for (Principal principal2 : principalSet) {
            concatPrincipalName = concatPrincipalName + principal2.getName();
        }
        return concatPrincipalName;
    }

    private void logMessageTypes(MessageInfo messageInfo, String methodName) {
        String msg = null;
        Object requestMessage = messageInfo.getRequestMessage();
        Object responseMessage = messageInfo.getResponseMessage();
        if (requestMessage != null) {
            if (requestMessage instanceof SOAPMessage) {
                msg = methodName + " : MessageInfo.getRequestMessage() is of type javax.xml.soap.SOAPMessage";
                this.logMsg(msg);
            } else {
                msg = methodName + " : MessageInfo.getRequestMessage() is of type " + requestMessage.getClass().getName();
                this.logMsg(msg);
            }
        }
        if (responseMessage != null) {
            if (responseMessage instanceof SOAPMessage) {
                msg = methodName + " : MessageInfo.getResponseMessage() is of type javax.xml.soap.SOAPMessage";
                this.logMsg(msg);
            } else {
                msg = methodName + " : MessageInfo.getResponseMessage() is of type " + responseMessage.getClass().getName();
                this.logMsg(msg);
            }
        }
    }
}

