/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javasoft.sqe.apiCheck.Setup;

public class BatchSetup {
    private static String MAP_FILE_PROP_NAME = "map.file.path";
    private static String SIG_REP_DIR = "signature.repository.dir";
    private static String SIG_EXT = ".sig_";
    private static String PACKAGE_FLAG = "-package";
    private static String OUTPUT_FILE_FLAG = "-out";
    private List defaultArgs = new LinkedList();
    private String repositoryDir;
    private String mapFile;
    private Properties recordPackages;

    private void addDefaultArgs(String[] args) {
        int numArgs = args != null ? args.length : 0;
        for (int i = 0; i < numArgs; ++i) {
            this.defaultArgs.add(args[i]);
        }
    }

    public BatchSetup(String[] args) throws Exception {
        this.addDefaultArgs(args);
        this.repositoryDir = System.getProperty(SIG_REP_DIR);
        if (this.repositoryDir == null) {
            throw new Exception("Error, the property \"" + SIG_REP_DIR + "\" is not defined.");
        }
        if (!this.repositoryDir.endsWith(File.separator)) {
            this.repositoryDir = this.repositoryDir + File.separator;
        }
        this.mapFile = System.getProperty(MAP_FILE_PROP_NAME);
        if (this.mapFile == null) {
            throw new Exception("Error, the property \"" + MAP_FILE_PROP_NAME + "\" is not defined.");
        }
        FileInputStream in = new FileInputStream(this.mapFile);
        this.recordPackages = new Properties();
        this.recordPackages.load(in);
    }

    private String createOutputFile(String packageName, String version) {
        return this.repositoryDir + packageName + SIG_EXT + version;
    }

    private String[] createArgs(String packageName, String outFile) {
        LinkedList<String> args = new LinkedList<String>(this.defaultArgs);
        args.add(PACKAGE_FLAG);
        args.add(packageName);
        args.add(OUTPUT_FILE_FLAG);
        args.add(outFile);
        return args.toArray(new String[args.size()]);
    }

    private void invokeSetup(String[] args) {
        System.out.println("Invoking javasoft.sqe.apiCheck.Setup with args:");
        System.out.println("\t" + Arrays.asList(args));
        Setup.main(args);
    }

    public void go() throws Exception {
        Enumeration<?> e = this.recordPackages.propertyNames();
        while (e.hasMoreElements()) {
            String packageName = (String)e.nextElement();
            String version = this.recordPackages.getProperty(packageName);
            String sigOutputFile = this.createOutputFile(packageName, version);
            String[] args = this.createArgs(packageName, sigOutputFile);
            this.invokeSetup(args);
        }
    }

    public static void main(String[] args) {
        try {
            BatchSetup bs = new BatchSetup(args);
            bs.go();
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
        }
    }
}

