/*
 * Copyright (c) 2017, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.ts.tests.jaxrs.jaxrs21.ee.priority;

import java.util.HashSet;
import java.util.Set;

import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;

@ApplicationPath("/")
public class TSAppConfig extends Application {

  public java.util.Set<java.lang.Class<?>> getClasses() {
    Set<Class<?>> resources = new HashSet<Class<?>>();
    resources.add(ExceptionMapperTwo.class);
    resources.add(ExceptionMapperOne.class);
    resources.add(ExceptionMapperThree.class);
    resources.add(ExceptionResource.class);
    resources.add(ParamConverterResource.class);
    resources.add(ParamConverterProviderTwo.class);
    return resources;
  }

  @Override
  public Set<Object> getSingletons() {
    Set<Object> resources = new HashSet<Object>();
    resources.add(new ParamConverterProviderAnother());
    resources.add(new ParamConverterProviderOne());
    return resources;
  }
}
