/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.frame;

import java.nio.ByteBuffer;
import java.util.Arrays;
import jdk.incubator.http.internal.frame.Http2Frame;

public class SettingsFrame
extends Http2Frame {
    private final int[] parameters = new int[6];
    public static final int TYPE = 4;
    public static final int ACK = 1;
    public static final int HEADER_TABLE_SIZE = 1;
    public static final int ENABLE_PUSH = 2;
    public static final int MAX_CONCURRENT_STREAMS = 3;
    public static final int INITIAL_WINDOW_SIZE = 4;
    public static final int MAX_FRAME_SIZE = 5;
    public static final int MAX_HEADER_LIST_SIZE = 6;
    public static final int MAX_PARAM = 6;
    private static final int K = 1024;

    @Override
    public String flagAsString(int n) {
        switch (n) {
            case 1: {
                return "ACK";
            }
        }
        return super.flagAsString(n);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString()).append(" Settings: ");
        for (int i = 0; i < 6; ++i) {
            if (this.parameters[i] == -1) continue;
            stringBuilder.append(this.name(i)).append("=").append(Integer.toString(this.parameters[i])).append(' ');
        }
        return stringBuilder.toString();
    }

    private String name(int n) {
        switch (n + 1) {
            case 1: {
                return "HEADER_TABLE_SIZE";
            }
            case 2: {
                return "ENABLE_PUSH";
            }
            case 3: {
                return "MAX_CONCURRENT_STREAMS";
            }
            case 4: {
                return "INITIAL_WINDOW_SIZE";
            }
            case 5: {
                return "MAX_FRAME_SIZE";
            }
            case 6: {
                return "MAX_HEADER_LIST_SIZE";
            }
        }
        return "unknown parameter";
    }

    public SettingsFrame(int n) {
        super(0, n);
        Arrays.fill(this.parameters, -1);
    }

    public SettingsFrame() {
        this(0);
    }

    @Override
    public int type() {
        return 4;
    }

    public int getParameter(int n) {
        if (n > 6) {
            throw new IllegalArgumentException("illegal parameter");
        }
        return this.parameters[n - 1];
    }

    public SettingsFrame setParameter(int n, int n2) {
        if (n > 6) {
            throw new IllegalArgumentException("illegal parameter");
        }
        this.parameters[n - 1] = n2;
        return this;
    }

    @Override
    int length() {
        int n = 0;
        for (int n2 : this.parameters) {
            if (n2 == -1) continue;
            n += 6;
        }
        return n;
    }

    void toByteBuffer(ByteBuffer byteBuffer) {
        for (int i = 0; i < 6; ++i) {
            if (this.parameters[i] == -1) continue;
            byteBuffer.putShort((short)(i + 1));
            byteBuffer.putInt(this.parameters[i]);
        }
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.length()];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.toByteBuffer(byteBuffer);
        return byArray;
    }

    public static SettingsFrame getDefaultSettings() {
        SettingsFrame settingsFrame = new SettingsFrame();
        settingsFrame.setParameter(2, 1);
        settingsFrame.setParameter(1, 4096);
        settingsFrame.setParameter(3, 35);
        settingsFrame.setParameter(4, 65535);
        settingsFrame.setParameter(5, 16384);
        return settingsFrame;
    }
}

