/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPStatisticsMonitorEntry
extends MonitorEntry {
    static final String LDAP_STATISTICS_MONITOR_OC = "ds-ldap-statistics-monitor-entry";
    private static final String ATTR_ABANDON_REQUESTS = "abandonRequests";
    private static final String ATTR_ADD_REQUESTS = "addRequests";
    private static final String ATTR_ADD_RESPONSES = "addResponses";
    private static final String ATTR_BIND_REQUESTS = "bindRequests";
    private static final String ATTR_BIND_RESPONSES = "bindResponses";
    private static final String ATTR_BYTES_READ = "bytesRead";
    private static final String ATTR_BYTES_WRITTEN = "bytesWritten";
    private static final String ATTR_COMPARE_REQUESTS = "compareRequests";
    private static final String ATTR_COMPARE_RESPONSES = "compareResponses";
    private static final String ATTR_CONNECTIONS_CLOSED = "connectionsClosed";
    private static final String ATTR_CONNECTIONS_ESTABLISHED = "connectionsEstablished";
    private static final String ATTR_DELETE_REQUESTS = "deleteRequests";
    private static final String ATTR_DELETE_RESPONSES = "deleteResponses";
    private static final String ATTR_EXTENDED_REQUESTS = "extendedRequests";
    private static final String ATTR_EXTENDED_RESPONSES = "extendedResponses";
    private static final String ATTR_LDAP_MESSAGES_READ = "ldapMessagesRead";
    private static final String ATTR_LDAP_MESSAGES_WRITTEN = "ldapMessagesWritten";
    private static final String ATTR_MODIFY_REQUESTS = "modifyRequests";
    private static final String ATTR_MODIFY_RESPONSES = "modifyResponses";
    private static final String ATTR_MODIFY_DN_REQUESTS = "modifyDNRequests";
    private static final String ATTR_MODIFY_DN_RESPONSES = "modifyDNResponses";
    private static final String ATTR_OPS_ABANDONED = "operationsAbandoned";
    private static final String ATTR_OPS_COMPLETED = "operationsCompleted";
    private static final String ATTR_OPS_INITIATED = "operationsInitiated";
    private static final String ATTR_SEARCH_REQUESTS = "searchRequests";
    private static final String ATTR_SEARCH_RESULT_DONE_RESPONSES = "searchResultsDone";
    private static final String ATTR_SEARCH_RESULT_ENTRY_RESPONSES = "searchResultEntries";
    private static final String ATTR_SEARCH_RESULT_REFERENCE_RESPONSES = "searchResultReferences";
    private static final String ATTR_UNBIND_REQUESTS = "unbindRequests";
    private static final long serialVersionUID = 4869341619766489249L;
    private final Long abandonRequests = this.getLong("abandonRequests");
    private final Long addRequests = this.getLong("addRequests");
    private final Long addResponses = this.getLong("addResponses");
    private final Long bindRequests = this.getLong("bindRequests");
    private final Long bindResponses = this.getLong("bindResponses");
    private final Long bytesRead = this.getLong("bytesRead");
    private final Long bytesWritten = this.getLong("bytesWritten");
    private final Long compareRequests = this.getLong("compareRequests");
    private final Long compareResponses = this.getLong("compareResponses");
    private final Long connectionsClosed = this.getLong("connectionsClosed");
    private final Long connectionsEstablished = this.getLong("connectionsEstablished");
    private final Long deleteRequests = this.getLong("deleteRequests");
    private final Long deleteResponses = this.getLong("deleteResponses");
    private final Long extendedRequests = this.getLong("extendedRequests");
    private final Long extendedResponses = this.getLong("extendedResponses");
    private final Long ldapMessagesRead = this.getLong("ldapMessagesRead");
    private final Long ldapMessagesWritten = this.getLong("ldapMessagesWritten");
    private final Long modifyRequests = this.getLong("modifyRequests");
    private final Long modifyResponses = this.getLong("modifyResponses");
    private final Long modifyDNRequests = this.getLong("modifyDNRequests");
    private final Long modifyDNResponses = this.getLong("modifyDNResponses");
    private final Long opsAbandoned = this.getLong("operationsAbandoned");
    private final Long opsCompleted = this.getLong("operationsCompleted");
    private final Long opsInitiated = this.getLong("operationsInitiated");
    private final Long searchRequests = this.getLong("searchRequests");
    private final Long searchDoneResponses = this.getLong("searchResultsDone");
    private final Long searchEntryResponses = this.getLong("searchResultEntries");
    private final Long searchReferenceResponses = this.getLong("searchResultReferences");
    private final Long unbindRequests = this.getLong("unbindRequests");

    public LDAPStatisticsMonitorEntry(Entry entry) {
        super(entry);
    }

    public Long getConnectionsEstablished() {
        return this.connectionsEstablished;
    }

    public Long getConnectionsClosed() {
        return this.connectionsClosed;
    }

    public Long getOperationsInitiated() {
        return this.opsInitiated;
    }

    public Long getOperationsCompleted() {
        return this.opsCompleted;
    }

    public Long getOperationsAbandoned() {
        return this.opsAbandoned;
    }

    public Long getBytesRead() {
        return this.bytesRead;
    }

    public Long getBytesWritten() {
        return this.bytesWritten;
    }

    public Long getLDAPMessagesRead() {
        return this.ldapMessagesRead;
    }

    public Long getLDAPMessagesWritten() {
        return this.ldapMessagesWritten;
    }

    public Long getAbandonRequests() {
        return this.abandonRequests;
    }

    public Long getAddRequests() {
        return this.addRequests;
    }

    public Long getAddResponses() {
        return this.addResponses;
    }

    public Long getBindRequests() {
        return this.bindRequests;
    }

    public Long getBindResponses() {
        return this.bindResponses;
    }

    public Long getCompareRequests() {
        return this.compareRequests;
    }

    public Long getCompareResponses() {
        return this.compareResponses;
    }

    public Long getDeleteRequests() {
        return this.deleteRequests;
    }

    public Long getDeleteResponses() {
        return this.deleteResponses;
    }

    public Long getExtendedRequests() {
        return this.extendedRequests;
    }

    public Long getExtendedResponses() {
        return this.extendedResponses;
    }

    public Long getModifyRequests() {
        return this.modifyRequests;
    }

    public Long getModifyResponses() {
        return this.modifyResponses;
    }

    public Long getModifyDNRequests() {
        return this.modifyDNRequests;
    }

    public Long getModifyDNResponses() {
        return this.modifyDNResponses;
    }

    public Long getSearchRequests() {
        return this.searchRequests;
    }

    public Long getSearchResultEntries() {
        return this.searchEntryResponses;
    }

    public Long getSearchResultReferences() {
        return this.searchReferenceResponses;
    }

    public Long getSearchDoneResponses() {
        return this.searchDoneResponses;
    }

    public Long getUnbindRequests() {
        return this.unbindRequests;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_LDAP_STATS_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_LDAP_STATS_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>();
        if (this.connectionsEstablished != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_CONNECTIONS_ESTABLISHED, MonitorMessages.INFO_LDAP_STATS_DISPNAME_CONNECTIONS_ESTABLISHED.get(), MonitorMessages.INFO_LDAP_STATS_DESC_CONNECTIONS_ESTABLISHED.get(), this.connectionsEstablished);
        }
        if (this.connectionsClosed != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_CONNECTIONS_CLOSED, MonitorMessages.INFO_LDAP_STATS_DISPNAME_CONNECTIONS_CLOSED.get(), MonitorMessages.INFO_LDAP_STATS_DESC_CONNECTIONS_CLOSED.get(), this.connectionsClosed);
        }
        if (this.bytesRead != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_BYTES_READ, MonitorMessages.INFO_LDAP_STATS_DISPNAME_BYTES_READ.get(), MonitorMessages.INFO_LDAP_STATS_DESC_BYTES_READ.get(), this.bytesRead);
        }
        if (this.bytesWritten != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_BYTES_WRITTEN, MonitorMessages.INFO_LDAP_STATS_DISPNAME_BYTES_WRITTEN.get(), MonitorMessages.INFO_LDAP_STATS_DESC_BYTES_WRITTEN.get(), this.bytesWritten);
        }
        if (this.ldapMessagesRead != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_LDAP_MESSAGES_READ, MonitorMessages.INFO_LDAP_STATS_DISPNAME_LDAP_MESSAGES_READ.get(), MonitorMessages.INFO_LDAP_STATS_DESC_LDAP_MESSAGES_READ.get(), this.ldapMessagesRead);
        }
        if (this.ldapMessagesWritten != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_LDAP_MESSAGES_WRITTEN, MonitorMessages.INFO_LDAP_STATS_DISPNAME_LDAP_MESSAGES_WRITTEN.get(), MonitorMessages.INFO_LDAP_STATS_DESC_LDAP_MESSAGES_WRITTEN.get(), this.ldapMessagesWritten);
        }
        if (this.opsInitiated != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_OPS_INITIATED, MonitorMessages.INFO_LDAP_STATS_DISPNAME_OPS_INITIATED.get(), MonitorMessages.INFO_LDAP_STATS_DESC_OPS_INITIATED.get(), this.opsInitiated);
        }
        if (this.opsCompleted != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_OPS_COMPLETED, MonitorMessages.INFO_LDAP_STATS_DISPNAME_OPS_COMPLETED.get(), MonitorMessages.INFO_LDAP_STATS_DESC_OPS_COMPLETED.get(), this.opsCompleted);
        }
        if (this.opsAbandoned != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_OPS_ABANDONED, MonitorMessages.INFO_LDAP_STATS_DISPNAME_OPS_ABANDONED.get(), MonitorMessages.INFO_LDAP_STATS_DESC_OPS_ABANDONED.get(), this.opsAbandoned);
        }
        if (this.abandonRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_ABANDON_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_ABANDON_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_ABANDON_REQUESTS.get(), this.abandonRequests);
        }
        if (this.addRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_ADD_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_ADD_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_ADD_REQUESTS.get(), this.addRequests);
        }
        if (this.addResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_ADD_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_ADD_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_ADD_RESPONSES.get(), this.addResponses);
        }
        if (this.bindRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_BIND_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_BIND_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_BIND_REQUESTS.get(), this.bindRequests);
        }
        if (this.bindResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_BIND_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_BIND_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_BIND_RESPONSES.get(), this.bindResponses);
        }
        if (this.compareRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_COMPARE_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_COMPARE_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_COMPARE_REQUESTS.get(), this.compareRequests);
        }
        if (this.compareResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_COMPARE_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_COMPARE_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_COMPARE_RESPONSES.get(), this.compareResponses);
        }
        if (this.deleteRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_DELETE_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_DELETE_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_DELETE_REQUESTS.get(), this.deleteRequests);
        }
        if (this.deleteResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_DELETE_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_DELETE_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_DELETE_RESPONSES.get(), this.deleteResponses);
        }
        if (this.extendedRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_EXTENDED_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_EXTENDED_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_EXTENDED_REQUESTS.get(), this.extendedRequests);
        }
        if (this.extendedResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_EXTENDED_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_EXTENDED_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_EXTENDED_RESPONSES.get(), this.extendedResponses);
        }
        if (this.modifyRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_MODIFY_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_MODIFY_REQUESTS.get(), this.modifyRequests);
        }
        if (this.modifyResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_MODIFY_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_MODIFY_RESPONSES.get(), this.modifyResponses);
        }
        if (this.modifyDNRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_DN_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_MODIFY_DN_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_MODIFY_DN_REQUESTS.get(), this.modifyDNRequests);
        }
        if (this.modifyDNResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_DN_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_MODIFY_DN_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_MODIFY_DN_RESPONSES.get(), this.modifyDNResponses);
        }
        if (this.searchRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_SEARCH_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_SEARCH_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_SEARCH_REQUESTS.get(), this.searchRequests);
        }
        if (this.searchEntryResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_SEARCH_RESULT_ENTRY_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_SEARCH_ENTRY_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_SEARCH_ENTRY_RESPONSES.get(), this.searchEntryResponses);
        }
        if (this.searchReferenceResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_SEARCH_RESULT_REFERENCE_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_SEARCH_REFERENCE_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_SEARCH_REFERENCE_RESPONSES.get(), this.searchReferenceResponses);
        }
        if (this.searchDoneResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_SEARCH_RESULT_DONE_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_SEARCH_DONE_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_SEARCH_DONE_RESPONSES.get(), this.searchDoneResponses);
        }
        if (this.unbindRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_UNBIND_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_UNBIND_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_UNBIND_REQUESTS.get(), this.unbindRequests);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

