/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeMap;
import jdk.incubator.http.HttpHeaders;

public class HttpHeadersImpl
implements HttpHeaders {
    private final TreeMap<String, List<String>> headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    @Override
    public Optional<String> firstValue(String string) {
        List<String> list = this.headers.get(string);
        return Optional.ofNullable(list == null ? null : list.get(0));
    }

    @Override
    public List<String> allValues(String string) {
        return this.headers.get(string);
    }

    @Override
    public Map<String, List<String>> map() {
        return Collections.unmodifiableMap(this.headers);
    }

    public Map<String, List<String>> directMap() {
        return this.headers;
    }

    public HttpHeadersImpl deepCopy() {
        HttpHeadersImpl httpHeadersImpl = new HttpHeadersImpl();
        TreeMap<String, List<String>> treeMap = httpHeadersImpl.headers;
        Set<String> set = this.headers.keySet();
        for (String string : set) {
            List<String> list = this.headers.get(string);
            ArrayList<String> arrayList = new ArrayList<String>(list);
            treeMap.put(string, arrayList);
        }
        return httpHeadersImpl;
    }

    public void addHeader(String string2, String string3) {
        this.headers.computeIfAbsent(string2, string -> new ArrayList(1)).add(string3);
    }

    public void setHeader(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string2);
        this.headers.put(string, arrayList);
    }

    @Override
    public OptionalLong firstValueAsLong(String string) {
        List<String> list = this.headers.get(string);
        if (list == null) {
            return OptionalLong.empty();
        }
        String string2 = list.get(0);
        return OptionalLong.of(Long.parseLong(string2));
    }

    public void clear() {
        this.headers.clear();
    }
}

