/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.common;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.frame.DataFrame;
import jdk.incubator.http.internal.frame.Http2Frame;
import jdk.incubator.http.internal.frame.WindowUpdateFrame;

public abstract class Log {
    static final String logProp = "jdk.httpclient.HttpClient.log";
    public static final int OFF = 0;
    public static final int ERRORS = 1;
    public static final int REQUESTS = 2;
    public static final int HEADERS = 4;
    public static final int CONTENT = 8;
    public static final int FRAMES = 16;
    public static final int SSL = 32;
    public static final int TRACE = 64;
    static int logging;
    public static final int CONTROL = 1;
    public static final int DATA = 2;
    public static final int WINDOW_UPDATES = 4;
    public static final int ALL = 7;
    static int frametypes;
    static final PrintStream logger;

    public static boolean errors() {
        return (logging & 1) != 0;
    }

    public static boolean requests() {
        return (logging & 2) != 0;
    }

    public static boolean headers() {
        return (logging & 4) != 0;
    }

    public static boolean trace() {
        return (logging & 0x40) != 0;
    }

    public static boolean ssl() {
        return (logging & 0x20) != 0;
    }

    public static boolean frames() {
        return (logging & 0x10) != 0;
    }

    public static void logError(String string, Object ... objectArray) {
        if (Log.errors()) {
            logger.printf("ERROR: " + string, objectArray);
        }
    }

    public static void logError(Throwable throwable) {
        if (Log.errors()) {
            String string = Utils.stackTrace(throwable);
            logger.printf("ERROR: " + string + "\n", new Object[0]);
        }
    }

    public static void logSSL(String string, Object ... objectArray) {
        if (Log.ssl()) {
            logger.printf("SSL: " + string, objectArray);
        }
    }

    public static void logSSL(Supplier<String> supplier) {
        if (Log.ssl()) {
            logger.printf("SSL: " + supplier.get() + "\n", new Object[0]);
        }
    }

    public static void logTrace(String string, Object ... objectArray) {
        if (Log.trace()) {
            logger.printf("TRACE: " + string, objectArray);
        }
    }

    public static void logRequest(String string, Object ... objectArray) {
        if (Log.requests()) {
            logger.printf("REQUEST: " + string, objectArray);
        }
    }

    public static void logResponse(String string, Object ... objectArray) {
        if (Log.requests()) {
            logger.printf("RESPONSE: " + string, objectArray);
        }
    }

    public static void logHeaders(String string, Object ... objectArray) {
        if (Log.headers()) {
            logger.printf("HEADERS: " + string, objectArray);
        }
    }

    public static boolean loggingFrame(Class<? extends Http2Frame> clazz) {
        if (frametypes == 7) {
            return true;
        }
        if (clazz == DataFrame.class) {
            return (frametypes & 2) != 0;
        }
        if (clazz == WindowUpdateFrame.class) {
            return (frametypes & 4) != 0;
        }
        return (frametypes & 1) != 0;
    }

    public static void logFrames(Http2Frame http2Frame, String string) {
        if (Log.frames() && Log.loggingFrame(http2Frame.getClass())) {
            logger.printf("FRAME: " + string + ": " + http2Frame.toString() + "\n", new Object[0]);
        }
    }

    public static void dumpHeaders(StringBuilder stringBuilder, String string, HttpHeaders httpHeaders) {
        if (httpHeaders != null) {
            Map<String, List<String>> map = httpHeaders.map();
            Set<Map.Entry<String, List<String>>> set = map.entrySet();
            for (Map.Entry<String, List<String>> entry : set) {
                String string2 = entry.getKey();
                List<String> list = entry.getValue();
                stringBuilder.append(string).append(string2).append(":");
                for (String string3 : list) {
                    stringBuilder.append(' ').append(string3);
                }
                stringBuilder.append('\n');
            }
        }
    }

    private Log() {
    }

    static {
        Object object;
        String string = Utils.getNetProperty(logProp);
        if (string == null) {
            logging = 0;
        } else {
            for (String string2 : object = string.split(",")) {
                switch (string2.toLowerCase(Locale.US)) {
                    case "errors": {
                        logging |= 1;
                        break;
                    }
                    case "requests": {
                        logging |= 2;
                        break;
                    }
                    case "headers": {
                        logging |= 4;
                        break;
                    }
                    case "content": {
                        logging |= 8;
                        break;
                    }
                    case "ssl": {
                        logging |= 0x20;
                        break;
                    }
                    case "trace": {
                        logging |= 0x40;
                        break;
                    }
                    case "all": {
                        logging |= 0x7F;
                    }
                }
                if (!string2.startsWith("frames")) continue;
                logging |= 0x10;
                String[] stringArray = string2.split(":");
                if (stringArray.length == 1) {
                    frametypes = 7;
                    continue;
                }
                block33: for (String string3 : stringArray) {
                    switch (string3.toLowerCase()) {
                        case "control": {
                            frametypes |= 1;
                            continue block33;
                        }
                        case "data": {
                            frametypes |= 2;
                            continue block33;
                        }
                        case "window": {
                            frametypes |= 4;
                            continue block33;
                        }
                        case "all": {
                            frametypes = 7;
                        }
                    }
                }
            }
        }
        object = null;
        if (logging != 0) {
            try {
                File iOException = File.createTempFile("http_client_log", ".txt");
                object = new PrintStream(iOException);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        logger = object;
    }
}

