/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.client;

import com.sun.ant.TSBuildListener;
import com.sun.ant.taskdefs.client.ClientDescriptorHandler;
import com.sun.ant.taskdefs.common.InnerClassFilenameFilter;
import com.sun.ant.taskdefs.common.Packager;
import com.sun.ant.taskdefs.common.SunRITool;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import org.apache.tools.ant.BuildException;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AppclientTool
extends SunRITool {
    private String descriptorXmlFileName = "";
    private String descriptorRuntimeXmlFileName = "";
    protected ClientDescriptorHandler clientHandler;
    private boolean bIncludeLastEJBFiles = false;

    protected void registerKnownDTDs(ClientDescriptorHandler handler) {
        handler.registerDTD(PUBLICID_APP_CLIENT, TSBuildListener.getDtdDir(this.getTask().getProject()) + File.separator + DEFAULT_SUNRI13_APP_CLIENT_DTD_LOCATION);
    }

    protected ClientDescriptorHandler getClientDescriptorHandler(File srcDir) {
        this.clientHandler = new ClientDescriptorHandler(this.getTask(), srcDir);
        this.registerKnownDTDs(this.clientHandler);
        for (Packager.DTDLocation dtdLocation : this.getConfig().dtdLocations) {
            this.clientHandler.registerDTD(dtdLocation.getPublicId(), dtdLocation.getLocation());
        }
        return this.clientHandler;
    }

    public void includeLastJarredFiles(boolean bIncludeLastEJBFiles) {
        this.bIncludeLastEJBFiles = bIncludeLastEJBFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable parseClientFiles(String descriptorFileName, SAXParser saxParser) throws IOException, SAXException {
        FileInputStream descriptorStream = null;
        Hashtable clientFiles = null;
        try {
            descriptorStream = new FileInputStream(new File(this.config.descriptorDir, descriptorFileName));
            saxParser.parse(new InputSource(descriptorStream), (HandlerBase)this.clientHandler);
            clientFiles = this.clientHandler.getFiles();
        }
        finally {
            if (descriptorStream != null) {
                try {
                    descriptorStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return clientFiles;
    }

    public void processDescriptor(String descriptorFileName, SAXParser saxParser) {
        String baseName = this.config.name + "_client";
        String jarFileName = baseName + ".jar";
        this.descriptorXmlFileName = this.config.name + "_client.xml";
        this.descriptorRuntimeXmlFileName = this.config.name + "_client.runtime.xml";
        this.checkConfiguration(this.descriptorXmlFileName, saxParser);
        try {
            this.clientHandler = this.getClientDescriptorHandler(this.config.srcDir);
            Hashtable clientFiles = this.parseClientFiles(this.descriptorXmlFileName, saxParser);
            this.autoCheckExclude(clientFiles);
            String className = this.config.mainClass;
            className = className.replace('.', File.separatorChar);
            className = className + ".class";
            File classFile = new File(this.config.srcDir, className);
            clientFiles.put(className, classFile);
            this.addSupportClasses(clientFiles);
            this.checkAndAddInherited(clientFiles);
            File jarFile = new File(this.destDir, jarFileName);
            if (this.needToRebuild(clientFiles, jarFile)) {
                this.log("building " + jarFile.getName() + " with " + String.valueOf(clientFiles.size()) + " files", 3);
                String publicId = this.clientHandler.getPublicId();
                this.writeClientJar(baseName, jarFile, clientFiles, publicId);
            } else {
                this.log(jarFile.toString() + " is up to date.", 3);
            }
        }
        catch (SAXException se) {
            String msg = "SAXException while parsing '" + this.descriptorXmlFileName.toString() + "'. This probably indicates badly-formed XML.  Details: " + se.getMessage();
            throw new BuildException(msg, (Throwable)se);
        }
        catch (IOException ioe) {
            String msg = "IOException while parsing'" + this.descriptorXmlFileName.toString() + "'.  This probably indicates that the descriptor doesn't exist. Details: " + ioe.getMessage();
            throw new BuildException(msg, (Throwable)ioe);
        }
    }

    protected void writeClientJar(String baseName, File jarfile, Hashtable files, String publicId) throws BuildException {
        String sFilesToAdd = "";
        String sJarFile = jarfile.getPath();
        if (jarfile.exists()) {
            jarfile.delete();
        }
        for (String entryName : files.keySet()) {
            File entryFile = (File)files.get(entryName);
            this.log("adding file '" + entryName + "'", 3);
            sFilesToAdd = !sFilesToAdd.equals("") ? sFilesToAdd + ":" + entryName : sFilesToAdd + entryName;
            InnerClassFilenameFilter flt = new InnerClassFilenameFilter(entryFile.getName());
            File entryDir = entryFile.getParentFile();
            String[] innerfiles = entryDir.list(flt);
            int n = innerfiles.length;
            for (int i = 0; i < n; ++i) {
                int entryIndex = entryName.lastIndexOf(entryFile.getName()) - 1;
                entryName = entryIndex < 0 ? innerfiles[i] : entryName.substring(0, entryIndex) + File.separatorChar + innerfiles[i];
                entryFile = new File(this.config.srcDir, entryName);
                this.log("adding innerclass file '" + entryName + "'", 3);
                sFilesToAdd = sFilesToAdd + ":" + entryName;
            }
        }
        System.out.println("clienttool: bIncludeLastEJBFiles = " + this.bIncludeLastEJBFiles);
        System.out.println("clienttool: sLastFilesAdded = " + sLastFilesAdded);
        if (this.bIncludeLastEJBFiles) {
            sFilesToAdd = sFilesToAdd + ":" + sLastFilesAdded;
        }
        this.log("Adding files to appclient jar " + sFilesToAdd, 3);
        String args = "";
        args = "-applicationClient ";
        args = args + this.config.srcDir.getPath() + " ";
        args = args + sFilesToAdd + " ";
        args = args + this.config.mainClass + " ";
        args = args + this.config.descriptorDir.getPath() + File.separator + this.descriptorXmlFileName + " ";
        args = args + jarfile.getPath();
        this.invokePackager(jarfile, args);
    }
}

