/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.core_syntax.actions.root;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setContextRoot("/jsp_core_act_root_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_core_act_root_web.war");
        archive.addClasses(new Class[]{JspTestUtil.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_core_act_root_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspRootJspBodyTag.tagx", "tags/JspRootJspBodyTag.tagx");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspRootUsageContextTag1.tagx", "tags/JspRootUsageContextTag1.tagx");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspRootUsageContextTag2.tag", "tags/JspRootUsageContextTag2.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspRootVersionInvalidValueTag.tagx", "tags/JspRootVersionInvalidValueTag.tagx");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspRootVersionReqAttrTag.tagx", "tags/JspRootVersionReqAttrTag.tagx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspRootVersionReqAttrTest2.jsp")), "JspRootVersionReqAttrTest2.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspRootVersionReqAttrTest1.jspx")), "JspRootVersionReqAttrTest1.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspRootVersionAttrInvalidValueTest2.jsp")), "JspRootVersionAttrInvalidValueTest2.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspRootVersionAttrInvalidValueTest1.jspx")), "JspRootVersionAttrInvalidValueTest1.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspRootVersionAttrAllowableValuesTest2.jspx")), "JspRootVersionAttrAllowableValuesTest2.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspRootVersionAttrAllowableValuesTest1.jspx")), "JspRootVersionAttrAllowableValuesTest1.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspRootUsageContextTest4.jsp")), "JspRootUsageContextTest4.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspRootUsageContextTest3.jsp")), "JspRootUsageContextTest3.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspRootUsageContextTest2.jspx")), "JspRootUsageContextTest2.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspRootUsageContextTest1.jsp")), "JspRootUsageContextTest1.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspRootJspBodyTest2.jsp")), "JspRootJspBodyTest2.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspRootJspBodyTest1.jspx")), "JspRootJspBodyTest1.jspx");
        return archive;
    }

    @Test
    public void jspRootUsageContextTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_root_web/JspRootUsageContextTest1.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_root_web/JspRootUsageContextTest2.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<status>Test PASSED</status>");
        TEST_PROPS.setProperty("unexpected_response_match", "jsp:root");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_root_web/JspRootUsageContextTest3.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<status>Test PASSED</status>");
        TEST_PROPS.setProperty("unexpected_response_match", "jsp:root");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_root_web/JspRootUsageContextTest4.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void jspRootVersionAttrAllowableValuesTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_root_web/JspRootVersionAttrAllowableValuesTest1.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<status>Test PASSED</status>");
        TEST_PROPS.setProperty("unexpected_response_match", "jsp:root");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_root_web/JspRootVersionAttrAllowableValuesTest2.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<status>Test PASSED</status>");
        TEST_PROPS.setProperty("unexpected_response_match", "jsp:root");
        this.invoke();
    }

    @Test
    public void jspRootVersionAttrInvalidValueTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_root_web/JspRootVersionAttrInvalidValueTest1.jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_root_web/JspRootVersionAttrInvalidValueTest2.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void jspRootVersionReqAttrTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_root_web/JspRootVersionReqAttrTest1.jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_root_web/JspRootVersionReqAttrTest2.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void jspRootJspBodyTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_root_web/JspRootJspBodyTest1.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<status>Test PASSED</status>");
        TEST_PROPS.setProperty("unexpected_response_match", "jsp:root");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_root_web/JspRootJspBodyTest2.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<status>Test PASSED</status>");
        TEST_PROPS.setProperty("unexpected_response_match", "jsp:root");
        this.invoke();
    }
}

