/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.frontend;

import com.sun.prism.ResourceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.eclipse.fx.drift.PresentationMode;
import org.eclipse.fx.drift.TransferType;
import org.eclipse.fx.drift.Vec2i;
import org.eclipse.fx.drift.internal.FPSCounter;
import org.eclipse.fx.drift.internal.common.ImageData;
import org.eclipse.fx.drift.internal.frontend.FrontSwapChain;
import org.eclipse.fx.drift.internal.frontend.FxImage;
import org.eclipse.fx.drift.internal.frontend.FxImageFactory;

public class SimpleFrontSwapChain
implements FrontSwapChain {
    private UUID id;
    private List<FxImage<?>> images = new ArrayList();
    private Map<ImageData, FxImage<?>> imageMap = new HashMap();
    private AtomicReference<ImageData> mailbox = new AtomicReference();
    private BiConsumer<UUID, ImageData> onRelease;
    private Vec2i size;
    private int imageCount;
    private PresentationMode presentationMode;
    public FPSCounter fpsCounter = new FPSCounter(100);
    private boolean disposeScheduled;

    public SimpleFrontSwapChain(UUID id, List<ImageData> images, PresentationMode presentationMode, BiConsumer<UUID, ImageData> onRelease) {
        this.id = id;
        for (ImageData image : images) {
            FxImage fxImage = FxImageFactory.createFxImage(image);
            this.images.add(fxImage);
            this.imageMap.put(image, fxImage);
        }
        this.presentationMode = presentationMode;
        this.onRelease = onRelease;
    }

    @Override
    public Vec2i getSize() {
        return ((ImageData)this.images.get((int)0).getData()).size;
    }

    @Override
    public TransferType getTransferType() {
        return ((ImageData)this.images.get((int)0).getData()).type;
    }

    @Override
    public void allocate(ResourceFactory rf) throws Exception {
        for (FxImage<?> fxImage : this.images) {
            fxImage.allocate(rf);
        }
    }

    @Override
    public void release() {
        for (FxImage<?> fxImage : this.images) {
            fxImage.release();
        }
    }

    @Override
    public void scheduleDispose() {
        this.disposeScheduled = true;
    }

    @Override
    public boolean isDisposeScheduled() {
        return this.disposeScheduled;
    }

    @Override
    public Optional<FxImage<?>> getNext() {
        return this.getNextData().map(this.imageMap::get);
    }

    public Optional<ImageData> getNextData() {
        return Optional.ofNullable(this.mailbox.getAndSet(null));
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void present(ImageData image) {
        ImageData old = this.mailbox.getAndSet(image);
        if (old != null) {
            this.release(old);
        }
        this.fpsCounter.tick();
    }

    @Override
    public void release(FxImage<?> image) {
        this.onRelease.accept(this.id, (ImageData)image.getData());
    }

    public void release(ImageData image) {
        this.onRelease.accept(this.id, image);
    }
}

