/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable;

import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.DecoratingObservableList;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.map.DecoratingObservableMap;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.set.DecoratingObservableSet;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.value.DecoratingObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.observable.ConstantObservableValue;
import org.eclipse.core.internal.databinding.observable.DelayedObservableValue;
import org.eclipse.core.internal.databinding.observable.EmptyObservableList;
import org.eclipse.core.internal.databinding.observable.EmptyObservableSet;
import org.eclipse.core.internal.databinding.observable.MapEntryObservableValue;
import org.eclipse.core.internal.databinding.observable.StalenessObservableValue;
import org.eclipse.core.internal.databinding.observable.UnmodifiableObservableList;
import org.eclipse.core.internal.databinding.observable.UnmodifiableObservableMap;
import org.eclipse.core.internal.databinding.observable.UnmodifiableObservableSet;
import org.eclipse.core.internal.databinding.observable.UnmodifiableObservableValue;
import org.eclipse.core.runtime.Assert;

public class Observables {
    public static <T> IObservableValue<T> observeDelayedValue(int delay, IObservableValue<T> observable) {
        return new DelayedObservableValue<T>(delay, observable);
    }

    public static <T> IObservableValue<T> unmodifiableObservableValue(IObservableValue<T> value) {
        Assert.isNotNull(value, (String)"Argument 'value' cannot be null");
        return new UnmodifiableObservableValue<T>(value);
    }

    public static <T> IObservableValue<T> constantObservableValue(Realm realm, T value, Object valueType) {
        return new ConstantObservableValue<T>(realm, value, valueType);
    }

    public static <T> IObservableValue<T> constantObservableValue(Realm realm, T value) {
        return Observables.constantObservableValue(realm, value, null);
    }

    public static <T> IObservableValue<T> constantObservableValue(T value, T valueType) {
        return Observables.constantObservableValue(Realm.getDefault(), value, valueType);
    }

    public static <T> IObservableValue<T> constantObservableValue(T value) {
        return Observables.constantObservableValue(Realm.getDefault(), value, null);
    }

    public static <E> IObservableList<E> unmodifiableObservableList(IObservableList<E> list) {
        if (list == null) {
            throw new IllegalArgumentException("List parameter cannot be null.");
        }
        return new UnmodifiableObservableList<E>(list);
    }

    public static <E> IObservableSet<E> unmodifiableObservableSet(IObservableSet<E> set) {
        if (set == null) {
            throw new IllegalArgumentException("Set parameter cannot be null");
        }
        return new UnmodifiableObservableSet<E>(set);
    }

    public static <K, V> IObservableMap<K, V> unmodifiableObservableMap(IObservableMap<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("Map parameter cannot be null");
        }
        return new UnmodifiableObservableMap<K, V>(map);
    }

    public static <E> IObservableList<E> emptyObservableList() {
        return Observables.emptyObservableList(Realm.getDefault(), null);
    }

    public static <E> IObservableList<E> emptyObservableList(Object elementType) {
        return Observables.emptyObservableList(Realm.getDefault(), elementType);
    }

    public static <E> IObservableList<E> emptyObservableList(Realm realm) {
        return Observables.emptyObservableList(realm, null);
    }

    public static <E> IObservableList<E> emptyObservableList(Realm realm, Object elementType) {
        return new EmptyObservableList(realm, elementType);
    }

    public static <E> IObservableSet<E> emptyObservableSet() {
        return Observables.emptyObservableSet(Realm.getDefault(), null);
    }

    public static <E> IObservableSet<E> emptyObservableSet(Object elementType) {
        return Observables.emptyObservableSet(Realm.getDefault(), elementType);
    }

    public static <E> IObservableSet<E> emptyObservableSet(Realm realm) {
        return Observables.emptyObservableSet(realm, null);
    }

    public static <E> IObservableSet<E> emptyObservableSet(Realm realm, Object elementType) {
        return new EmptyObservableSet(realm, elementType);
    }

    public static <E> IObservableSet<E> staticObservableSet(Set<E> set) {
        return Observables.staticObservableSet(Realm.getDefault(), set, Object.class);
    }

    public static <E> IObservableSet<E> staticObservableSet(Set<E> set, Object elementType) {
        return Observables.staticObservableSet(Realm.getDefault(), set, elementType);
    }

    public static <E> IObservableSet<E> staticObservableSet(Realm realm, Set<E> set) {
        return Observables.staticObservableSet(realm, set, Object.class);
    }

    public static <E> IObservableSet<E> staticObservableSet(Realm realm, Set<E> set, Object elementType) {
        return new ObservableSet<E>(realm, (Set)set, elementType){

            @Override
            public synchronized void addChangeListener(IChangeListener listener) {
            }

            @Override
            public synchronized void addStaleListener(IStaleListener listener) {
            }

            @Override
            public synchronized void addSetChangeListener(ISetChangeListener<? super E> listener) {
            }
        };
    }

    public static <T> IObservableValue<T> proxyObservableValue(IObservableValue<T> target) {
        return new DecoratingObservableValue<T>(target, false);
    }

    public static <E> IObservableSet<E> proxyObservableSet(IObservableSet<E> target) {
        return new DecoratingObservableSet<E>(target, false);
    }

    public static <E> IObservableList<E> proxyObservableList(IObservableList<E> target) {
        return new DecoratingObservableList<E>(target, false);
    }

    public static <K, V> IObservableMap<K, V> proxyObservableMap(IObservableMap<K, V> target) {
        return new DecoratingObservableMap<K, V>(target, false);
    }

    public static <E> IObservableList<E> staticObservableList(List<E> list) {
        return Observables.staticObservableList(Realm.getDefault(), list, Object.class);
    }

    public static <E> IObservableList<E> staticObservableList(List<E> list, Object elementType) {
        return Observables.staticObservableList(Realm.getDefault(), list, elementType);
    }

    public static <E> IObservableList<E> staticObservableList(Realm realm, List<E> list) {
        return Observables.staticObservableList(realm, list, Object.class);
    }

    public static <E> IObservableList<E> staticObservableList(Realm realm, List<E> list, Object elementType) {
        return new ObservableList<E>(realm, (List)list, elementType){

            @Override
            public synchronized void addChangeListener(IChangeListener listener) {
            }

            @Override
            public synchronized void addStaleListener(IStaleListener listener) {
            }

            @Override
            public synchronized void addListChangeListener(IListChangeListener<? super E> listener) {
            }
        };
    }

    public static IObservableValue<Boolean> observeStale(IObservable observable) {
        return new StalenessObservableValue(observable);
    }

    public static <K, V> IObservableValue<V> observeMapEntry(IObservableMap<K, V> map, K key) {
        return Observables.observeMapEntry(map, key, map.getValueType());
    }

    public static <K, V> IObservableValue<V> observeMapEntry(IObservableMap<K, V> map, K key, Object valueType) {
        if (valueType == null) {
            valueType = map.getValueType();
        }
        return new MapEntryObservableValue<K, V>(map, key, valueType);
    }

    public static <K, V> IObservableFactory<K, IObservableValue<V>> mapEntryValueFactory(IObservableMap<K, V> map, Object valueType) {
        return key -> Observables.observeMapEntry(map, key, valueType);
    }

    public static <K, V> IObservableValue<V> observeDetailMapEntry(IObservableMap<K, V> map, IObservableValue<K> master, Object valueType) {
        return MasterDetailObservables.detailValue(master, Observables.mapEntryValueFactory(map, valueType), valueType);
    }

    public static <T> void pipe(IObservableValue<T> source, IObservableValue<? super T> destination) {
        destination.setValue(source.getValue());
        source.addValueChangeListener(event -> destination.setValue(event.diff.getNewValue()));
    }
}

