/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.internal.lifecycle;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.ui.lifecycle.ELifecycleService;

public class LifecycleServiceImpl
implements ELifecycleService {
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication app;
    @Inject
    private IContributionFactory factory;

    @Override
    public void registerLifecycleURI(MUIElement element, String lifecycleURI) {
        HashSet<Object> contributions = (HashSet<Object>)element.getTransientData().get("EFX_LIFECYCLE");
        if (contributions == null) {
            contributions = new HashSet<Object>();
            element.getTransientData().put("EFX_LIFECYCLE", contributions);
        }
        Object object = this.factory.create(lifecycleURI, this.app.getContext());
        contributions.add(object);
    }

    public boolean validateAnnotation(Class annotationClass, MUIElement element, IEclipseContext context) {
        return this.validateLifecycleAnnotation(annotationClass, this.getContextForParent(element), context, element);
    }

    private boolean validateLifecycleAnnotation(Class clazz, IEclipseContext parentContext, IEclipseContext partContext, MUIElement part) {
        Set set = (Set)part.getTransientData().get("EFX_LIFECYCLE");
        if (set != null) {
            for (Object object : set) {
                boolean res;
                Object invokeResult = ContextInjectionFactory.invoke(object, (Class)clazz, (IEclipseContext)parentContext, (IEclipseContext)partContext, (Object)true);
                if (invokeResult == null || (res = ((Boolean)invokeResult).booleanValue())) continue;
                return false;
            }
        }
        return true;
    }

    private IEclipseContext getContextForParent(MUIElement element) {
        return this.modelService.getContainingContext(element);
    }

    @Override
    public void unregisterLifecycleContribution(MUIElement element, Object contribution) {
        Set objects = (Set)element.getTransientData().get("EFX_LIFECYCLE");
        if (objects != null) {
            objects.remove(contribution);
        }
    }
}

