/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.Collection;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.EventProcessor;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WTrimBar;

public abstract class BaseTrimBarRenderer<N>
extends BaseRenderer<MTrimBar, WTrimBar<N>>
implements EventProcessor.ChildrenHandler<MTrimBar, MTrimElement> {
    public static final String TAG_FILLSPACE = "fillspace";

    @PostConstruct
    void init(IEventBroker eventBroker) {
        EventProcessor.attachChildProcessor(eventBroker, this);
        EventProcessor.attachVisibleProcessor(eventBroker, this);
    }

    @Override
    public void doProcessContent(MTrimBar element) {
        WTrimBar trimBar = (WTrimBar)this.getWidget((MUIElement)element);
        for (MTrimElement e : element.getChildren()) {
            WLayoutedWidget trimElementWidget;
            if (!e.isToBeRendered() || (trimElementWidget = (WLayoutedWidget)this.engineCreateWidget(e)) == null || !e.isVisible()) continue;
            trimBar.addChild(trimElementWidget);
        }
    }

    public void childRendered(MTrimBar parentElement, MUIElement element) {
        if (this.inContentProcessing((MUIElement)parentElement)) {
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        WTrimBar trimBar = (WTrimBar)this.getWidget((MUIElement)parentElement);
        WLayoutedWidget widget = (WLayoutedWidget)element.getWidget();
        if (widget instanceof WMenu) {
            trimBar.addChild(idx, widget);
        }
    }

    public void hideChild(MTrimBar container, MUIElement changedObj) {
        WTrimBar toolbar = (WTrimBar)this.getWidget((MUIElement)container);
        if (toolbar == null) {
            return;
        }
        WLayoutedWidget widget = (WLayoutedWidget)changedObj.getWidget();
        if (widget != null) {
            toolbar.removeChild(widget);
        }
    }

    @Override
    public void handleChildrenAddition(MTrimBar parent, Collection<MTrimElement> elements) {
        for (MTrimElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible()) continue;
            if (element.getWidget() == null) {
                this.engineCreateWidget(element);
                continue;
            }
            this.childRendered(parent, (MUIElement)element);
        }
    }

    @Override
    public void handleChildrenRemove(MTrimBar parent, Collection<MTrimElement> elements) {
        for (MTrimElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible() || element.getWidget() == null) continue;
            this.hideChild(parent, (MUIElement)element);
        }
    }
}

