/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.panes;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.WritableIntegerValue;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;

public class SashLayoutPane
extends Pane {
    private WritableIntegerValue minSashPercent = new SimpleIntegerProperty((Object)this, "minSashPercent", 10);
    private WritableIntegerValue marginLeft = new SimpleIntegerProperty((Object)this, "marginLeft", 0);
    private WritableIntegerValue marginRight = new SimpleIntegerProperty((Object)this, "marginRight", 0);
    private WritableIntegerValue marginTop = new SimpleIntegerProperty((Object)this, "marginTop", 0);
    private WritableIntegerValue marginBottom = new SimpleIntegerProperty((Object)this, "marginBottom", 0);
    private WritableIntegerValue sashWidth = new SimpleIntegerProperty((Object)this, "sashWidth", 4);
    private MGenericTile root;
    private List<SashRect> sashes = new ArrayList<SashRect>();
    private boolean draggingSashes = false;
    List<SashRect> sashesToDrag;

    public SashLayoutPane() {
        this.root = new MGenericTile();
        this.root.widget = this;
        this.onMouseMovedProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (!SashLayoutPane.this.draggingSashes) {
                    List<SashRect> sashList = SashLayoutPane.this.getSashRects(event.getX(), event.getY());
                    if (sashList.size() == 0) {
                        SashLayoutPane.this.setCursor(Cursor.DEFAULT);
                    } else if (sashList.size() == 1) {
                        if (sashList.get((int)0).container.horizontal) {
                            SashLayoutPane.this.setCursor(Cursor.W_RESIZE);
                        } else {
                            SashLayoutPane.this.setCursor(Cursor.S_RESIZE);
                        }
                    } else {
                        SashLayoutPane.this.setCursor(Cursor.CROSSHAIR);
                    }
                }
            }
        });
        this.onMouseDraggedProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (SashLayoutPane.this.draggingSashes) {
                    SashLayoutPane.this.adjustWeights(SashLayoutPane.this.sashesToDrag, event.getX(), event.getY());
                    SashLayoutPane.this.requestLayout();
                }
            }
        });
        this.onMouseReleasedProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                SashLayoutPane.this.draggingSashes = false;
            }
        });
        this.onMousePressedProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                SashLayoutPane.this.sashesToDrag = SashLayoutPane.this.getSashRects(event.getX(), event.getY());
                if (SashLayoutPane.this.sashesToDrag.size() > 0) {
                    SashLayoutPane.this.draggingSashes = true;
                }
            }
        });
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft.set(marginLeft);
    }

    public int getMarginLeft() {
        return this.marginLeft.get();
    }

    public void setMarginRight(int marginRight) {
        this.marginRight.set(marginRight);
    }

    public int getMarginRight() {
        return this.marginRight.get();
    }

    public void setMarginTop(int marginTop) {
        this.marginTop.set(marginTop);
    }

    public int getMarginTop() {
        return this.marginTop.get();
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom.set(marginBottom);
    }

    public int getMarginBottom() {
        return this.marginBottom.get();
    }

    public void setSashWidth(int sashWidth) {
        this.sashWidth.set(sashWidth);
    }

    public int getSashWidth() {
        return this.sashWidth.get();
    }

    protected List<SashRect> getSashRects(double x, double y) {
        ArrayList<SashRect> srs = new ArrayList<SashRect>();
        boolean inSash = false;
        for (SashRect sr : this.sashes) {
            if (!sr.rect.contains(x, y)) continue;
            inSash = true;
        }
        if (!inSash) {
            return srs;
        }
        BoundingBox target = new BoundingBox(x - 5.0, y - 5.0, 10.0, 10.0);
        for (SashRect sr : this.sashes) {
            if (!sr.rect.intersects((Bounds)target)) continue;
            srs.add(sr);
        }
        return srs;
    }

    protected void adjustWeights(List<SashRect> sashes, double curX, double curY) {
        for (SashRect sr : sashes) {
            double rightWeight;
            double leftWeight;
            double pct;
            double totalWeight = SashLayoutPane.getWeight(sr.left) + SashLayoutPane.getWeight(sr.right);
            double minSashValue = totalWeight / 100.0 * (double)this.minSashPercent.get() + 0.5;
            Bounds leftRect = this.getRectangle(sr.left);
            Bounds rightRect = this.getRectangle(sr.right);
            if (leftRect == null || rightRect == null) continue;
            if (sr.container.horizontal) {
                double right;
                double left = leftRect.getMinX();
                pct = (curX - left) / ((right = rightRect.getMinX() + rightRect.getWidth()) - left);
                leftWeight = totalWeight * pct + 0.5;
                if (leftWeight < minSashValue) {
                    leftWeight = minSashValue;
                }
                if (leftWeight > totalWeight - minSashValue) {
                    leftWeight = totalWeight - minSashValue;
                }
                rightWeight = totalWeight - leftWeight;
            } else {
                double bottom;
                double top = leftRect.getMinY();
                pct = (curY - top) / ((bottom = rightRect.getMinY() + rightRect.getHeight()) - top);
                leftWeight = (int)(totalWeight * pct + 0.5);
                if (leftWeight < minSashValue) {
                    leftWeight = minSashValue;
                }
                if (leftWeight > totalWeight - minSashValue) {
                    leftWeight = totalWeight - minSashValue;
                }
                rightWeight = totalWeight - leftWeight;
            }
            this.setWeight(sr.left, leftWeight);
            this.setWeight(sr.right, rightWeight);
        }
    }

    private void setWeight(MUIElement element, double weight) {
        element.weight = weight;
    }

    public void setConstraint(Node node, MUIControl data) {
        data.widget = node;
    }

    public MGenericTile getRoot() {
        return this.root;
    }

    protected void layoutChildren() {
        if (this.root == null) {
            return;
        }
        Bounds bounds = this.getLayoutBounds();
        bounds = new BoundingBox(bounds.getMinX() + (double)this.marginLeft.get(), bounds.getMinY() + (double)this.marginTop.get(), bounds.getWidth() - (double)(this.marginLeft.get() + this.marginRight.get()), bounds.getHeight() - (double)(this.marginTop.get() + this.marginBottom.get()));
        this.sashes.clear();
        this.tileSubNodes(bounds, this.root);
    }

    private Bounds getRectangle(MUIElement element) {
        if (element instanceof MGenericTile) {
            return (Bounds)element.widget;
        }
        if (element.widget instanceof Node) {
            return ((Node)element.widget).getBoundsInParent();
        }
        return null;
    }

    private void setRectangle(MUIElement node, Bounds bounds) {
        if (node.widget instanceof Node) {
            Node ctrl = (Node)node.widget;
            ctrl.resizeRelocate(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
        } else if (node instanceof MGenericTile) {
            BoundingBox newRect = new BoundingBox(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
            node.widget = newRect;
        }
    }

    private List<MUIElement> getVisibleChildren(MGenericTile sashContainer) {
        ArrayList<MUIElement> visKids = new ArrayList<MUIElement>();
        for (MUIElement child : sashContainer.children) {
            if (!child.isVisible()) continue;
            visKids.add(child);
        }
        return visKids;
    }

    private double totalWeight(MGenericTile node) {
        double total = 0.0;
        for (MUIElement subNode : node.children) {
            if (!subNode.isVisible()) continue;
            total += SashLayoutPane.getWeight(subNode);
        }
        return total;
    }

    private void tileSubNodes(Bounds bounds, MUIElement node) {
        if (node != this.root) {
            this.setRectangle(node, bounds);
        }
        if (!(node instanceof MGenericTile)) {
            return;
        }
        MGenericTile sashContainer = (MGenericTile)node;
        List<MUIElement> visibleChildren = this.getVisibleChildren(sashContainer);
        int childCount = visibleChildren.size();
        double availableWidth = sashContainer.horizontal ? bounds.getWidth() : bounds.getHeight();
        availableWidth -= (double)((childCount - 1) * this.sashWidth.get());
        double totalWeight = this.totalWeight(sashContainer);
        double tilePos = sashContainer.horizontal ? bounds.getMinX() : bounds.getMinY();
        MUIElement prev = null;
        for (MUIElement subNode : visibleChildren) {
            if (prev != null) {
                BoundingBox sashRect = sashContainer.horizontal ? new BoundingBox(tilePos, bounds.getMinY(), (double)this.sashWidth.get(), bounds.getHeight()) : new BoundingBox(bounds.getMinX(), tilePos, bounds.getWidth(), (double)this.sashWidth.get());
                this.sashes.add(new SashRect((Bounds)sashRect, sashContainer, prev, subNode));
                tilePos += (double)this.sashWidth.get();
            }
            double ratio = SashLayoutPane.getWeight(subNode) / totalWeight;
            double newSize = availableWidth * ratio;
            BoundingBox subBounds = sashContainer.horizontal ? new BoundingBox(tilePos, bounds.getMinY(), newSize, bounds.getHeight()) : new BoundingBox(bounds.getMinX(), tilePos, bounds.getWidth(), newSize);
            tilePos += newSize;
            this.tileSubNodes((Bounds)subBounds, subNode);
            prev = subNode;
        }
    }

    private static double getWeight(MUIElement element) {
        Double info = element.weight;
        if (info == null) {
            info = element.weight = Double.valueOf(100.0);
        }
        return info;
    }

    public static class MGenericTile
    extends MUIElement {
        boolean horizontal;
        List<MUIElement> children = new ArrayList<MUIElement>();

        public void setHorizontal(boolean horizontal) {
            this.horizontal = horizontal;
        }

        public void add(MUIElement element) {
            this.children.add(element);
        }
    }

    public static class MUIControl
    extends MUIElement {
    }

    public static abstract class MUIElement {
        Double weight;
        Object widget;
        boolean visible = true;

        public boolean isVisible() {
            return this.visible;
        }

        public void setWeight(Double weight) {
            this.weight = weight;
        }
    }

    class SashRect {
        Bounds rect;
        MGenericTile container;
        MUIElement left;
        MUIElement right;

        public SashRect(Bounds rect, MGenericTile container, MUIElement left, MUIElement right) {
            this.container = container;
            this.rect = rect;
            this.left = left;
            this.right = right;
        }
    }
}

