/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.Collection;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.workbench.Selector;
import org.eclipse.fx.ui.workbench.renderers.base.BaseItemContainerRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WToolBar;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;

public abstract class BaseToolBarRenderer<N>
extends BaseItemContainerRenderer<MToolBar, MToolBarElement, WToolBar<N>> {
    @Override
    protected void do_init(IEventBroker eventBroker) {
        final Object value = this.context.get("efx_TOOLITEM_TIMER");
        final Selector noop = m -> true;
        if (value != null && value instanceof Number) {
            Thread syncThread = new Thread("ToolItem Enablement Sync"){

                @Override
                public void run() {
                    while (true) {
                        BaseToolBarRenderer.this.checkExecute(noop);
                        try {
                            Thread.sleep(((Number)value).longValue());
                            continue;
                        }
                        catch (InterruptedException e) {
                            BaseToolBarRenderer.this.getLogger().error("Failed to sleep", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
            };
            syncThread.setDaemon(true);
            syncThread.start();
        }
    }

    @Override
    public void doProcessContent(MToolBar element) {
        WToolBar toolbar = (WToolBar)this.getWidget((MUIElement)element);
        if (toolbar == null) {
            this.getLogger().error("Could not find widget for '" + element + "'");
            return;
        }
        for (MToolBarElement item : element.getChildren()) {
            Object itemWidget;
            if (!item.isToBeRendered() || (itemWidget = this.engineCreateWidget(item)) == null || !item.isVisible()) continue;
            toolbar.addChild((WWidget<MToolBarElement>)itemWidget);
        }
    }

    @Override
    public void do_childRendered(MToolBar parentElement, MUIElement element) {
        if (this.inContentProcessing((MUIElement)parentElement)) {
            return;
        }
        WToolBar toolbar = (WToolBar)this.getWidget((MUIElement)parentElement);
        if (toolbar == null) {
            this.getLogger().error("Could not find widget for '" + parentElement + "'");
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        WWidget widget = (WWidget)element.getWidget();
        if (widget != null) {
            toolbar.addChild(idx, widget);
        } else {
            this.logger.error("The widget for element '" + element + "' should not be null.");
        }
    }

    @Override
    public void do_hideChild(MToolBar container, MUIElement changedObj) {
        WToolBar toolbar = (WToolBar)this.getWidget((MUIElement)container);
        if (toolbar == null) {
            return;
        }
        WWidget widget = (WWidget)changedObj.getWidget();
        if (widget != null) {
            toolbar.removeChild(widget);
        }
    }

    @Override
    public void handleChildrenAddition(MToolBar parent, Collection<MToolBarElement> elements) {
        for (MToolBarElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible()) continue;
            if (element.getWidget() == null) {
                this.engineCreateWidget(element);
                continue;
            }
            this.childRendered(parent, (MUIElement)element);
        }
    }

    @Override
    public void handleChildrenRemove(MToolBar parent, Collection<MToolBarElement> elements) {
        for (MToolBarElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible() || element.getWidget() == null) continue;
            this.hideChild(parent, (MUIElement)element);
        }
    }
}

