/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.di.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.image.Image;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.fx.osgi.util.LoggerCreator;
import org.eclipse.fx.ui.di.ResourceProviderService;
import org.eclipse.fx.ui.di.ResourceService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ResourceServiceImpl
implements ResourceService {
    private Map<String, PooledResource<Image>> imagePool = new HashMap<String, PooledResource<Image>>();
    private BundleContext context;

    public ResourceServiceImpl() {
        Bundle b = FrameworkUtil.getBundle(ResourceServiceImpl.class);
        this.context = b.getBundleContext();
    }

    @Override
    public ResourceService.IPooledResource<Image> getImage(@NonNull String key) throws IOException {
        return this.loadResource(key);
    }

    private <R> @NonNull ResourceService.IPooledResource<@Nullable R> loadResource(@NonNull String key) throws IOException {
        PooledResource<Object> resource = null;
        resource = this.imagePool.get(key);
        if (resource != null && resource.getResource() != null) {
            ++resource.count;
        } else {
            resource = new PooledResource<R>(this, key, this.lookupResource(key));
            this.imagePool.put(key, resource);
        }
        return resource;
    }

    private <R> R lookupResource(@NonNull String key) throws IOException {
        ResourceProviderService provider = this.lookupOSGI(key);
        if (provider != null) {
            return (R)provider.getImage(key);
        }
        throw new IOException("No provider known for '" + key + "'.");
    }

    private ResourceProviderService lookupOSGI(String key) {
        try {
            Collection refs = this.context.getServiceReferences(ResourceProviderService.class, "(" + key + "=*)");
            if (!refs.isEmpty()) {
                ServiceReference ref = (ServiceReference)refs.iterator().next();
                return (ResourceProviderService)this.context.getService(ref);
            }
        }
        catch (InvalidSyntaxException e) {
            LoggerCreator.createLogger(this.getClass()).error("Unable to query registry", (Throwable)e);
        }
        return null;
    }

    @Override
    public ResourceService.IDiposeableResourcePool getResourcePool() {
        return new ResourcePool(this);
    }

    public void removePooledResource(PooledResource<?> resource) {
        this.imagePool.remove(resource.getId());
    }

    static class PooledResource<@Nullable T>
    implements ResourceService.IPooledResource<T> {
        int count;
        private @Nullable T resource;
        private @NonNull String id;
        private ResourceServiceImpl resourceService;

        PooledResource(@NonNull ResourceServiceImpl resourceService, @NonNull String id, @Nullable T resource) {
            this.id = id;
            this.count = 1;
            this.resourceService = resourceService;
            this.resource = resource;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public T getResource() {
            return this.resource;
        }

        @Override
        public void dispose() {
            --this.count;
            if (this.count == 0) {
                this.resourceService.removePooledResource(this);
                this.resource = null;
                this.resourceService = null;
            }
        }
    }

    static class ResourcePool
    implements ResourceService.IDiposeableResourcePool {
        private final ResourceServiceImpl resourceService;
        private List<ResourceService.IPooledResource<Image>> pooledImages = new ArrayList<ResourceService.IPooledResource<Image>>();

        @Inject
        public ResourcePool(ResourceService resourceService) {
            this.resourceService = (ResourceServiceImpl)resourceService;
        }

        @Override
        public Image getImage(String imageKey) throws IOException {
            Image r;
            ResourceService.IPooledResource<Image> image = null;
            for (ResourceService.IPooledResource<Image> img : this.pooledImages) {
                if (!img.getId().equals(imageKey)) continue;
                image = img;
            }
            if (image == null) {
                image = this.resourceService.getImage(imageKey);
                this.pooledImages.add(image);
            }
            if ((r = (Image)image.getResource()) == null) {
                throw new IOException("Image could not be loaded");
            }
            return r;
        }

        @Override
        public Image getImageUnchecked(String imageKey) {
            try {
                return this.getImage(imageKey);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Override
        @PreDestroy
        public void dispose() {
            for (ResourceService.IPooledResource<Image> img : this.pooledImages) {
                img.dispose();
            }
            this.pooledImages = null;
        }
    }
}

