/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.fx.services.internal;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.code.editor.fx.services.ProposalComputer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.source.AnnotationPresenter;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class DefaultSourceViewerConfiguration
extends SourceViewerConfiguration {
    private final Input<?> input;
    private final PresentationReconciler reconciler;
    private final ProposalComputer proposalComputer;
    private final IAnnotationModel annotationModel;
    private final List<AnnotationPresenter> annotationPresenters;

    @Inject
    public DefaultSourceViewerConfiguration(Input<?> input, PresentationReconciler reconciler, @Optional ProposalComputer proposalComputer, @Optional IAnnotationModel annotationModel, @Optional AnnotationPresenter presenter) {
        this.input = input;
        this.reconciler = reconciler;
        this.proposalComputer = proposalComputer;
        this.annotationModel = annotationModel;
        this.annotationPresenters = presenter != null ? Collections.singletonList(presenter) : Collections.emptyList();
    }

    public String getStyleclassName() {
        return "source-viewer";
    }

    public final IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        return this.reconciler;
    }

    public IContentAssistant getContentAssist() {
        if (this.proposalComputer != null) {
            return new ContentAssistant(this::computeProposals);
        }
        return super.getContentAssist();
    }

    List<ICompletionProposal> computeProposals(Integer offset) {
        try {
            return this.proposalComputer.compute(new ProposalComputer.ProposalContext(this.input, offset)).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    public IAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public List<AnnotationPresenter> getAnnotationPresenters() {
        return this.annotationPresenters;
    }
}

