/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.di;

import javafx.application.Platform;
import org.eclipse.fx.core.Callback;

public abstract class Util<T> {
    public static <T> Callback<T> onFX(final Callback<T> callback) {
        if (callback instanceof SyncCallback) {
            return (SyncCallback)callback;
        }
        return new SyncCallback<T>(){

            public void call(final T value) {
                if (Platform.isFxApplicationThread()) {
                    callback.call(value);
                } else {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callback.call(value);
                        }
                    });
                }
            }
        };
    }

    static abstract class SyncCallback<T>
    implements Callback<T> {
        SyncCallback() {
        }
    }
}

