/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.formallang.Production;
import org.eclipse.xtext.util.formallang.ProductionFormatter;

public class StringProduction
implements Production<ProdElement, String> {
    protected static final Pattern WS = Pattern.compile("^[\\s]+");
    protected ProdElement root;

    public StringProduction() {
    }

    public StringProduction(String production) {
        this.root = this.parseAlt(this.lex(production));
    }

    protected ProdElement createElement(ElementType type) {
        return new ProdElement(type);
    }

    @Override
    public Iterable<ProdElement> getAlternativeChildren(ProdElement ele) {
        return ele.type == ElementType.ALTERNATIVE ? ele.children : null;
    }

    @Override
    public ProdElement getParent(ProdElement ele) {
        return ele.parent;
    }

    @Override
    public ProdElement getRoot() {
        return this.root;
    }

    @Override
    public Iterable<ProdElement> getSequentialChildren(ProdElement ele) {
        return ele.type == ElementType.SEQUENCE ? ele.children : null;
    }

    @Override
    public String getToken(ProdElement ele) {
        return ele.type == ElementType.TOKEN ? ele.value : null;
    }

    @Override
    public Iterable<ProdElement> getUnorderedChildren(ProdElement ele) {
        return ele.type == ElementType.UNOREDERED ? ele.children : null;
    }

    @Override
    public boolean isMany(ProdElement ele) {
        return ele.many;
    }

    @Override
    public boolean isOptional(ProdElement ele) {
        return ele.optional;
    }

    protected Stack<Pair<Token, String>> lex(String string) {
        int offset = 0;
        Matcher wsMatcher = WS.matcher(string);
        ArrayList matcher = Lists.newArrayList();
        for (Token t : Token.values()) {
            matcher.add(Tuples.create(t, t.pattern.matcher(string)));
        }
        Stack<Pair<Token, String>> result = new Stack<Pair<Token, String>>();
        block1: while (offset < string.length()) {
            wsMatcher.region(offset, string.length());
            if (wsMatcher.find()) {
                offset = wsMatcher.end();
                continue;
            }
            for (Pair m : matcher) {
                ((Matcher)m.getSecond()).region(offset, string.length());
                if (!((Matcher)m.getSecond()).find()) continue;
                result.add(Tuples.create(m.getFirst(), ((Matcher)m.getSecond()).group(((Matcher)m.getSecond()).groupCount() == 1 ? 1 : 0)));
                offset = ((Matcher)m.getSecond()).end();
                continue block1;
            }
            throw new RuntimeException("No valid token found at '" + string.substring(offset) + "'");
        }
        Collections.reverse(result);
        return result;
    }

    protected ProdElement parseAlt(Stack<Pair<Token, String>> tokens) {
        ProdElement first = this.parseUnordered(tokens);
        if (!tokens.isEmpty() && tokens.peek().getFirst() == Token.PIPE) {
            ProdElement uno = this.createElement(ElementType.ALTERNATIVE);
            uno.addChild(first);
            do {
                tokens.pop();
                ProdElement next = this.parseUnordered(tokens);
                uno.addChild(next);
            } while (!tokens.isEmpty() && tokens.peek().getFirst() == Token.PIPE);
            return uno;
        }
        return first;
    }

    protected void parseCardinality(Stack<Pair<Token, String>> tokens, ProdElement ele) {
        if (!tokens.isEmpty()) {
            switch (tokens.peek().getFirst()) {
                case QM: {
                    tokens.pop();
                    ele.optional = true;
                    break;
                }
                case STAR: {
                    tokens.pop();
                    ele.optional = true;
                    ele.many = true;
                    break;
                }
                case PLUS: {
                    tokens.pop();
                    ele.many = true;
                    break;
                }
            }
        }
    }

    protected ProdElement parsePrim(Stack<Pair<Token, String>> tokens) {
        Pair<Token, String> current = tokens.pop();
        switch (current.getFirst()) {
            case PL: {
                ProdElement result1 = this.parseAlt(tokens);
                if (!tokens.peek().getFirst().equals((Object)Token.PR)) {
                    throw new RuntimeException("')' expected, but " + (Object)((Object)tokens.peek().getFirst()) + " found");
                }
                tokens.pop();
                this.parseCardinality(tokens, result1);
                return result1;
            }
            case STRING: {
                ProdElement result2 = this.createElement(ElementType.TOKEN);
                result2.value = current.getSecond();
                this.parseCardinality(tokens, result2);
                return result2;
            }
            case ID: {
                ProdElement result3 = this.createElement(ElementType.TOKEN);
                result3.name = current.getSecond();
                this.parseCardinality(tokens, result3);
                return result3;
            }
        }
        throw new RuntimeException("Unexpected token " + (Object)((Object)current.getFirst()));
    }

    protected ProdElement parseSeq(Stack<Pair<Token, String>> tokens) {
        ProdElement first = this.parsePrim(tokens);
        EnumSet<Token> followers = EnumSet.of(Token.STRING, Token.PL, Token.ID);
        if (!tokens.isEmpty() && followers.contains((Object)tokens.peek().getFirst())) {
            ProdElement seq = this.createElement(ElementType.SEQUENCE);
            seq.addChild(first);
            do {
                ProdElement next = this.parsePrim(tokens);
                seq.addChild(next);
            } while (!tokens.isEmpty() && followers.contains((Object)tokens.peek().getFirst()));
            return seq;
        }
        return first;
    }

    protected ProdElement parseUnordered(Stack<Pair<Token, String>> tokens) {
        ProdElement first = this.parseSeq(tokens);
        if (!tokens.isEmpty() && tokens.peek().getFirst() == Token.AND) {
            ProdElement uno = this.createElement(ElementType.UNOREDERED);
            uno.addChild(first);
            do {
                tokens.pop();
                ProdElement next = this.parseSeq(tokens);
                uno.addChild(next);
            } while (!tokens.isEmpty() && tokens.peek().getFirst() == Token.AND);
            return uno;
        }
        return first;
    }

    public String toString() {
        if (this.root == null) {
            return "null";
        }
        return new ProductionFormatter<ProdElement, String>().format(this);
    }

    protected static enum Token {
        AND("&"),
        COLON(":"),
        EQ("="),
        ID("[a-zA-Z][a-zA-Z0-9]*"),
        PIPE("\\|"),
        PL("\\("),
        PLUS("\\+"),
        PR("\\)"),
        QM("\\?"),
        STAR("\\*"),
        STRING("'([^']*)'");

        public final Pattern pattern;

        private Token(String regex) {
            this.pattern = Pattern.compile("^" + regex);
        }
    }

    public class ProdElement {
        protected List<ProdElement> children;
        protected boolean many;
        protected String name;
        protected boolean optional;
        protected ProdElement parent;
        protected ElementType type;
        protected String value;

        public ProdElement(ElementType type) {
            this.type = type;
            if (type != ElementType.TOKEN) {
                this.children = Lists.newArrayList();
            }
        }

        public void setValue(String value) {
            this.value = value;
        }

        protected void addChild(ProdElement ele) {
            this.children.add(ele);
            ele.parent = this;
        }

        public List<ProdElement> getChildren() {
            return this.children;
        }

        public void setMany(boolean many) {
            this.many = many;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }

        public String getName() {
            return this.name;
        }

        public ProdElement getParent() {
            return this.parent;
        }

        public ElementType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isMany() {
            return this.many;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            if (this.value != null) {
                return "'" + this.value + "'";
            }
            if (this.name != null) {
                return this.name;
            }
            return new ProductionFormatter<ProdElement, String>().format(StringProduction.this, this);
        }
    }

    public static enum ElementType {
        ALTERNATIVE,
        SEQUENCE,
        TOKEN,
        UNOREDERED;

    }
}

