/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IAutowrapFormatter;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.internal.AbstractHiddenRegionFormatter;

public class SingleHiddenRegionFormatter
extends AbstractHiddenRegionFormatter {
    private final IHiddenRegionFormatting formatting;

    public SingleHiddenRegionFormatter(IHiddenRegionFormatting formatting) {
        this.formatting = formatting;
    }

    @Override
    public void autowrap() {
        Integer old = this.formatting.getAutowrap();
        if (old == null || old < 0) {
            this.formatting.setAutowrap(0);
        }
    }

    @Override
    public void autowrap(int triggerLength) {
        this.formatting.setAutowrap(triggerLength);
    }

    @Override
    public FormatterRequest getRequest() {
        return this.formatting.getRequest();
    }

    @Override
    public void indent() {
        Integer inc = this.formatting.getIndentationIncrease();
        Integer dec = this.formatting.getIndentationDecrease();
        this.formatting.setIndentationIncrease(inc == null ? 1 : inc + 1);
        this.formatting.setIndentationDecrease(dec == null ? 1 : dec + 1);
    }

    @Override
    public void noAutowrap() {
        this.formatting.setAutowrap(-1);
    }

    @Override
    public void noIndentation() {
        this.formatting.setNoIndentation(true);
    }

    @Override
    public void setNewLines(int minNewLines, int defaultNewLines, int maxNewLines) {
        this.formatting.setNewLinesMin(minNewLines);
        this.formatting.setNewLinesDefault(defaultNewLines);
        this.formatting.setNewLinesMax(maxNewLines);
    }

    @Override
    public void setOnAutowrap(IAutowrapFormatter formatter) {
        this.autowrap();
        this.formatting.setOnAutowrap(formatter);
    }

    @Override
    public void setPriority(int priority) {
        this.formatting.setPriority(priority);
    }

    @Override
    public void setSpace(String space) {
        this.formatting.setSpace(space);
    }
}

