/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.context;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContext;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;

public class ProxyContext {
    private static final String JAVAX_SERVLET_CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    private final ConcurrentMap<ContextController, ContextAttributes> attributesMap = new ConcurrentHashMap<ContextController, ContextAttributes>();
    File proxyContextTempDir;
    private ServletContext servletContext;

    public ProxyContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        File tempDir = (File)servletContext.getAttribute(JAVAX_SERVLET_CONTEXT_TEMPDIR);
        if (tempDir != null) {
            this.proxyContextTempDir = new File(tempDir, "proxytemp");
            ProxyContext.deleteDirectory(this.proxyContextTempDir);
            this.proxyContextTempDir.mkdirs();
        }
    }

    public void destroy() {
        if (this.proxyContextTempDir != null) {
            ProxyContext.deleteDirectory(this.proxyContextTempDir);
        }
    }

    public String getServletPath() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createContextAttributes(ContextController controller) {
        ConcurrentMap<ContextController, ContextAttributes> concurrentMap = this.attributesMap;
        synchronized (concurrentMap) {
            ContextAttributes contextAttributes = (ContextAttributes)this.attributesMap.get(controller);
            if (contextAttributes == null) {
                contextAttributes = new ContextAttributes(controller);
                this.attributesMap.put(controller, contextAttributes);
            }
            contextAttributes.addReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyContextAttributes(ContextController controller) {
        ConcurrentMap<ContextController, ContextAttributes> concurrentMap = this.attributesMap;
        synchronized (concurrentMap) {
            ContextAttributes contextAttributes = (ContextAttributes)this.attributesMap.get(controller);
            if (contextAttributes == null) {
                throw new IllegalStateException("too many calls");
            }
            if (contextAttributes.removeReference() == 0) {
                this.attributesMap.remove(controller);
                contextAttributes.destroy();
            }
        }
    }

    public Dictionary<String, Object> getContextAttributes(ContextController controller) {
        return (Dictionary)this.attributesMap.get(controller);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    protected static boolean deleteDirectory(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    ProxyContext.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return directory.delete();
    }

    public class ContextAttributes
    extends Dictionary<String, Object>
    implements Serializable {
        private static final long serialVersionUID = 1916670423277243587L;
        private final AtomicInteger referenceCount = new AtomicInteger();
        private final Map<String, Object> _map = new ConcurrentHashMap<String, Object>();

        public ContextAttributes(ContextController controller) {
            if (ProxyContext.this.proxyContextTempDir != null) {
                File contextTempDir = new File(ProxyContext.this.proxyContextTempDir, "hc_" + controller.hashCode());
                contextTempDir.mkdirs();
                this.put(ProxyContext.JAVAX_SERVLET_CONTEXT_TEMPDIR, (Object)contextTempDir);
            }
        }

        public void destroy() {
            File contextTempDir = (File)this.get(ProxyContext.JAVAX_SERVLET_CONTEXT_TEMPDIR);
            if (contextTempDir != null) {
                ProxyContext.deleteDirectory(contextTempDir);
            }
        }

        public int addReference() {
            return this.referenceCount.incrementAndGet();
        }

        public int removeReference() {
            return this.referenceCount.decrementAndGet();
        }

        public int referenceCount() {
            return this.referenceCount.get();
        }

        @Override
        public Enumeration<Object> elements() {
            return Collections.enumeration(this._map.values());
        }

        @Override
        public Object get(Object key) {
            return this._map.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this._map.isEmpty();
        }

        @Override
        public Enumeration<String> keys() {
            return Collections.enumeration(this._map.keySet());
        }

        @Override
        public Object put(String key, Object value) {
            return this._map.put(key, value);
        }

        @Override
        public Object remove(Object key) {
            return this._map.remove(key);
        }

        @Override
        public int size() {
            return this._map.size();
        }
    }
}

