/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.text.fx.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javafx.collections.ObservableList;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.fx.code.editor.configuration.Check;
import org.eclipse.fx.code.editor.configuration.Condition;
import org.eclipse.fx.code.editor.configuration.LanguageDef;
import org.eclipse.fx.code.editor.configuration.Partition;
import org.eclipse.fx.code.editor.configuration.Token;
import org.eclipse.fx.code.editor.configuration.TokenScanner;
import org.eclipse.fx.code.editor.configuration.TokenScanner_CharacterRule;
import org.eclipse.fx.code.editor.configuration.TokenScanner_JavaScript;
import org.eclipse.fx.code.editor.configuration.TokenScanner_Keyword;
import org.eclipse.fx.code.editor.configuration.TokenScanner_MultiLineRule;
import org.eclipse.fx.code.editor.configuration.TokenScanner_PatternRule;
import org.eclipse.fx.code.editor.configuration.TokenScanner_SingleLineRule;
import org.eclipse.fx.code.editor.configuration.text.DynamicScannerRuleCalculator;
import org.eclipse.fx.code.editor.configuration.text.Util;
import org.eclipse.fx.code.editor.configuration.text.fx.ConfigurationPresentationReconciler;
import org.eclipse.fx.core.NamedValue;
import org.eclipse.fx.text.rules.CharacterRule;
import org.eclipse.fx.text.rules.CombinedWordRule;
import org.eclipse.fx.text.rules.JavaLikeWordDetector;
import org.eclipse.fx.text.rules.RegexRule;
import org.eclipse.fx.text.ui.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class ConfigurationRuleScanner
extends RuleBasedScanner {
    public ConfigurationRuleScanner(ConfigurationPresentationReconciler reconciler, LanguageDef languageDef, Partition parition, Map<String, NamedValue<Object>> values, DynamicScannerRuleCalculator dynamicRuleCalculator) {
        ArrayList<Object> rules = new ArrayList<Object>(ConfigurationRuleScanner.getRuleCount(parition));
        HashMap<org.eclipse.jface.text.rules.Token, TokenScanner_Keyword> keyWordList = new HashMap<org.eclipse.jface.text.rules.Token, TokenScanner_Keyword>();
        for (Token st : parition.getTokenList()) {
            org.eclipse.jface.text.rules.Token token = new org.eclipse.jface.text.rules.Token((Object)new TextAttribute(languageDef.getFileSuffix() + "." + st.getName()));
            if (st.isDefaultToken()) {
                this.setDefaultReturnToken((IToken)token);
            }
            for (TokenScanner ru : st.getTokenScannerList()) {
                String endSeq;
                if (!Util.checkCondition((Condition)ru.getCondition(), values)) continue;
                if (ru instanceof TokenScanner_SingleLineRule) {
                    TokenScanner_SingleLineRule sru = (TokenScanner_SingleLineRule)ru;
                    endSeq = sru.getEndSeq();
                    rules.add(Util.wrap((Check)sru.getCheck(), (IRule)new SingleLineRule(sru.getStartSeq(), endSeq, (IToken)token, sru.getEscapedBy() != null ? sru.getEscapedBy().charAt(0) : (char)'\u0000', true)));
                    continue;
                }
                if (ru instanceof TokenScanner_MultiLineRule) {
                    TokenScanner_MultiLineRule sml = (TokenScanner_MultiLineRule)ru;
                    endSeq = sml.getEndSeq();
                    rules.add(Util.wrap((Check)sml.getCheck(), (IRule)new MultiLineRule(sml.getStartSeq(), endSeq, (IToken)token, sml.getEscapedBy() != null ? sml.getEscapedBy().charAt(0) : (char)'\u0000', true)));
                    continue;
                }
                if (ru instanceof TokenScanner_CharacterRule) {
                    TokenScanner_CharacterRule scr = (TokenScanner_CharacterRule)ru;
                    char[] c = new char[scr.getCharacterList().size()];
                    int j = 0;
                    while (j < c.length) {
                        c[j] = ((String)scr.getCharacterList().get(j)).charAt(0);
                        ++j;
                    }
                    rules.add(Util.wrap((Check)scr.getCheck(), (IRule)new CharacterRule((IToken)token, c)));
                    continue;
                }
                if (ru instanceof TokenScanner_Keyword) {
                    keyWordList.put(token, (TokenScanner_Keyword)ru);
                    continue;
                }
                if (ru instanceof TokenScanner_PatternRule) {
                    TokenScanner_PatternRule rr = (TokenScanner_PatternRule)ru;
                    rules.add(Util.wrap((Check)rr.getCheck(), (IRule)new RegexRule((IToken)token, Pattern.compile(rr.getStartPattern()), Math.max(1, rr.getStartLength()), Pattern.compile(rr.getContainmentPattern()))));
                    continue;
                }
                if (!(ru instanceof TokenScanner_JavaScript)) continue;
                TokenScanner_JavaScript jr = (TokenScanner_JavaScript)ru;
                try {
                    ScriptEngineManager engineManager = new ScriptEngineManager();
                    ScriptEngine engine = engineManager.getEngineByName("nashorn");
                    rules.add(Util.wrap((Check)jr.getCheck(), (IRule)((IRule)engine.eval(jr.getScript()))));
                }
                catch (ScriptException e) {
                    e.printStackTrace();
                }
            }
        }
        if (parition.getWhitespace() != null) {
            if (parition.getWhitespace().isJavawhiteSpace()) {
                rules.add(new WhitespaceRule(new IWhitespaceDetector(){

                    public boolean isWhitespace(char c) {
                        return Character.isWhitespace(c);
                    }
                }));
            } else {
                rules.add(new WhitespaceRule((IWhitespaceDetector)new FixedCharacterWSDetector(parition.getWhitespace().getCharacterList())));
            }
        }
        if (!keyWordList.isEmpty()) {
            JavaLikeWordDetector wordDetector = new JavaLikeWordDetector();
            CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)wordDetector, org.eclipse.jface.text.rules.Token.UNDEFINED);
            for (Map.Entry kg : keyWordList.entrySet()) {
                CombinedWordRule.WordMatcher wordRule = new CombinedWordRule.WordMatcher();
                for (String k : ((TokenScanner_Keyword)kg.getValue()).getKeywordList()) {
                    wordRule.addWord(k, (IToken)kg.getKey());
                }
                combinedWordRule.addWordMatcher(wordRule);
            }
            rules.add(combinedWordRule);
        }
        ArrayList staticRules = new ArrayList(rules);
        if (dynamicRuleCalculator != null) {
            List dynRule = dynamicRuleCalculator.getRule(parition.getName());
            if (dynRule instanceof ObservableList) {
                ((ObservableList)dynRule).addListener(o -> {
                    ArrayList newList = new ArrayList(staticRules);
                    newList.addAll(dynRule);
                    this.setRules(newList.toArray(new IRule[0]));
                    reconciler.getViewer().invalidateTextPresentation();
                });
            }
            rules.addAll(dynRule);
        }
        this.setRules(rules.toArray(new IRule[0]));
    }

    private static int getRuleCount(Partition partition) {
        int rv = 0;
        boolean hasKeyGroup = false;
        for (Token token : partition.getTokenList()) {
            rv = (int)((long)rv + token.getTokenScannerList().stream().filter(s -> !(s instanceof TokenScanner_Keyword)).count());
            if (token.getTokenScannerList().stream().filter(s -> s instanceof TokenScanner_Keyword).count() <= 0L) continue;
            hasKeyGroup = true;
        }
        if (hasKeyGroup) {
            ++rv;
        }
        if (partition.getWhitespace() != null) {
            ++rv;
        }
        return rv;
    }

    static class FixedCharacterWSDetector
    implements IWhitespaceDetector {
        private final char[] chars;

        public FixedCharacterWSDetector(List<String> list) {
            this.chars = new char[list.size()];
            int i = 0;
            for (String s : list) {
                this.chars[i++] = s.charAt(0);
            }
        }

        public boolean isWhitespace(char c) {
            char[] cArray = this.chars;
            int n = this.chars.length;
            int n2 = 0;
            while (n2 < n) {
                char ch = cArray[n2];
                if (ch == c) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    static class JSWSDectector
    implements IWhitespaceDetector {
        JSWSDectector() {
        }

        public boolean isWhitespace(char c) {
            return false;
        }
    }
}

