/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.debug.processing;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.debug.processing.ElementAdapter;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.emf.mwe.internal.core.debug.communication.Connection;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.RegisterPackage;
import org.eclipse.emf.mwe.internal.core.debug.processing.DebugMonitor;
import org.eclipse.emf.mwe.internal.core.debug.processing.RuntimeHandler;

public class RuntimeHandlerManager
implements Runnable {
    private Connection connection;
    private final DebugMonitor monitor;
    private static final Log logger = LogFactory.getLog(RuntimeHandlerManager.class);

    public RuntimeHandlerManager(DebugMonitor monitor) {
        this.monitor = monitor;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void startListener() {
        Thread thread = new Thread((Runnable)this, this.getClass().getSimpleName());
        thread.setDaemon(true);
        thread.start();
    }

    public void run() {
        try {
            while (true) {
                this.listenAndRegisterClasses();
            }
        }
        catch (Exception e) {
            if (!(e instanceof IOException)) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return;
        }
    }

    private void listenAndRegisterClasses() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        RegisterPackage packet = (RegisterPackage)this.connection.listenForPackage(RegisterPackage.class);
        String msg = null;
        if (packet.type == 1) {
            RuntimeHandler handler = null;
            for (String className : packet.classNames) {
                Class<?> clazz = ResourceLoaderFactory.createResourceLoader().loadClass(className);
                if (clazz == null) {
                    msg = "Couldn't find " + className + " in the class path.";
                    System.err.println(msg);
                    throw new ClassNotFoundException(msg);
                }
                handler = (RuntimeHandler)clazz.newInstance();
                handler.init(this.monitor, this.connection);
                handler.startListener();
            }
        } else {
            ElementAdapter adapter = null;
            for (String className : packet.classNames) {
                Class<?> clazz = ResourceLoaderFactory.createResourceLoader().loadClass(className);
                if (clazz == null) {
                    msg = "Couldn't find " + className + " in the class path.";
                    System.err.println(msg);
                    throw new ClassNotFoundException(msg);
                }
                adapter = (ElementAdapter)clazz.newInstance();
                this.monitor.addAdapter(adapter);
            }
        }
    }
}

