/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatechecker;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateChecker;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateListener;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.UpdateEvent;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class UpdateChecker
implements IUpdateChecker {
    public static boolean DEBUG = false;
    public static boolean TRACE = false;
    private HashMap<IUpdateListener, UpdateCheckThread> checkers = new HashMap();
    private final IProvisioningAgent agent;
    IProfileRegistry profileRegistry;
    IPlanner planner;

    public UpdateChecker(IProvisioningAgent agent) {
        this.agent = agent;
    }

    @Override
    public void addUpdateCheck(String profileId, IQuery<IInstallableUnit> query, long delay, long poll, IUpdateListener listener) {
        if (this.checkers.containsKey(listener)) {
            return;
        }
        this.trace("Adding update checker for " + profileId + " at " + this.getTimeStamp());
        UpdateCheckThread thread = new UpdateCheckThread(profileId, query, delay, poll, listener);
        this.checkers.put(listener, thread);
        thread.start();
    }

    @Override
    public void removeUpdateCheck(IUpdateListener listener) {
        this.checkers.remove(listener);
    }

    Collection<IInstallableUnit> checkForUpdates(String profileId, IQuery<IInstallableUnit> query) {
        IProfile profile = this.getProfileRegistry().getProfile(profileId);
        ArrayList<IInstallableUnit> iusWithUpdates = new ArrayList<IInstallableUnit>();
        if (profile == null) {
            return Collections.emptyList();
        }
        ProvisioningContext context = new ProvisioningContext(this.agent);
        context.setMetadataRepositories(this.getAvailableRepositories());
        if (query == null) {
            query = QueryUtil.createIUAnyQuery();
        }
        for (IInstallableUnit iu : profile.query(query, null)) {
            IQueryResult replacements = this.getPlanner().updatesFor(iu, context, null);
            if (replacements.isEmpty()) continue;
            iusWithUpdates.add(iu);
        }
        return iusWithUpdates;
    }

    private URI[] getAvailableRepositories() {
        IMetadataRepositoryManager repoMgr = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.class);
        URI[] repositories = repoMgr.getKnownRepositories(0);
        ArrayList<URI> available = new ArrayList<URI>();
        URI[] uRIArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            URI repositorie = uRIArray[n2];
            try {
                repoMgr.loadRepository(repositorie, null);
                available.add(repositorie);
            }
            catch (ProvisionException e) {
                LogHelper.log((IStatus)e.getStatus());
            }
            ++n2;
        }
        return available.toArray(new URI[available.size()]);
    }

    void trace(String message) {
        if (Tracing.DEBUG_UPDATE_CHECK) {
            Tracing.debug((String)message);
        }
    }

    String getTimeStamp() {
        Date d = new Date();
        SimpleDateFormat df = new SimpleDateFormat("[MM/dd/yy;HH:mm:ss:SSS]");
        return df.format(d);
    }

    IPlanner getPlanner() {
        if (this.planner == null) {
            this.planner = (IPlanner)this.agent.getService(IPlanner.class);
            if (this.planner == null) {
                throw new IllegalStateException("Provisioning system has not been initialized");
            }
        }
        return this.planner;
    }

    IProfileRegistry getProfileRegistry() {
        if (this.profileRegistry == null) {
            this.profileRegistry = (IProfileRegistry)this.agent.getService(IProfileRegistry.class);
            if (this.profileRegistry == null) {
                throw new IllegalStateException("Provisioning system has not been initialized");
            }
        }
        return this.profileRegistry;
    }

    private class UpdateCheckThread
    extends Thread {
        boolean done = false;
        long poll;
        long delay;
        IUpdateListener listener;
        String profileId;
        IQuery<IInstallableUnit> query;

        UpdateCheckThread(String profileId, IQuery<IInstallableUnit> query, long delay, long poll, IUpdateListener listener) {
            this.poll = poll;
            this.delay = delay;
            this.profileId = profileId;
            this.query = query;
            this.listener = listener;
        }

        @Override
        public void run() {
            try {
                if (this.delay != -1L && this.delay > 0L) {
                    Thread.sleep(this.delay);
                }
                while (!this.done) {
                    this.listener.checkingForUpdates();
                    UpdateChecker.this.trace("Checking for updates for " + this.profileId + " at " + UpdateChecker.this.getTimeStamp());
                    Collection<IInstallableUnit> iusWithUpdates = UpdateChecker.this.checkForUpdates(this.profileId, this.query);
                    if (iusWithUpdates.size() > 0) {
                        UpdateChecker.this.trace("Notifying listener of available updates");
                        UpdateEvent event = new UpdateEvent(this.profileId, iusWithUpdates);
                        if (!this.done) {
                            this.listener.updatesAvailable(event);
                        }
                    } else {
                        UpdateChecker.this.trace("No updates were available");
                    }
                    if (this.delay == -1L || this.delay <= 0L) {
                        this.done = true;
                        continue;
                    }
                    Thread.sleep(this.poll);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.updatechecker", "Exception in update check thread", (Throwable)e));
            }
        }
    }
}

