/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.lang.reflect.Field;
import java.security.CodeSource;
import org.eclipse.fx.core.SystemUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ReflectionUtil {
    public static Field getField(Class<?> clazz, String name) throws NoSuchFieldException {
        Class<?> searchClass = clazz;
        Field field = null;
        while (field == null && searchClass != null) {
            try {
                field = searchClass.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                searchClass = searchClass.getSuperclass();
            }
        }
        if (field == null) {
            throw new NoSuchFieldException(String.valueOf(clazz.getSimpleName()) + "." + name);
        }
        return field;
    }

    public static void setFieldValue(Object object, String name, Object value) {
        try {
            Field field = ReflectionUtil.getField(object.getClass(), name);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Could not set field value: " + object.getClass().getSimpleName() + "." + name, e);
        }
    }

    public static Object getFieldValue(Object object, String name) {
        try {
            Field field = ReflectionUtil.getField(object.getClass(), name);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Could not read field value: " + object.getClass().getSimpleName() + "." + name, e);
        }
    }

    public static String describeClass(Class<?> cl) {
        Bundle b;
        if (SystemUtils.isOsgiEnv() && (b = FrameworkUtil.getBundle(cl)) != null) {
            return String.valueOf(b.getSymbolicName()) + ":" + b.getVersion() + ":" + cl.getName();
        }
        CodeSource clazzCS = cl.getProtectionDomain().getCodeSource();
        if (clazzCS != null) {
            return clazzCS.getLocation() + ">" + cl.getName();
        }
        if (cl.getClassLoader() == null) {
            return String.valueOf(cl.getName()) + " [via bootstrap classloader]";
        }
        return cl.getName();
    }
}

