/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.core.nd.db.DBStatus;
import org.eclipse.jdt.internal.core.nd.db.Database;
import org.eclipse.jdt.internal.core.nd.db.IndexException;

final class Chunk {
    private final byte[] fBuffer = new byte[4096];
    final Database fDatabase;
    final int fSequenceNumber;
    boolean fDirty;
    boolean fCacheHitFlag;
    int fCacheIndex = -1;

    Chunk(Database db, int sequenceNumber) {
        this.fDatabase = db;
        this.fSequenceNumber = sequenceNumber;
    }

    public void makeDirty() {
        Chunk chunk;
        if (this.fSequenceNumber >= 1 && (chunk = this.fDatabase.fChunks[this.fSequenceNumber]) != this) {
            throw new IllegalStateException("CHUNK " + this.fSequenceNumber + ": found two copies. Copy 1: " + System.identityHashCode(this) + ", Copy 2: " + System.identityHashCode(chunk));
        }
        if (!this.fDirty) {
            if (Database.DEBUG_PAGE_CACHE) {
                System.out.println("CHUNK " + this.fSequenceNumber + ": dirtied - instance " + System.identityHashCode(this));
            }
            if (this.fSequenceNumber >= 1 && this.fDatabase.fMostRecentlyFetchedChunk != this) {
                throw new IllegalStateException("CHUNK " + this.fSequenceNumber + " dirtied out of order: Only the most-recently-fetched chunk is allowed to be dirtied");
            }
            this.fDirty = true;
            this.fDatabase.chunkDirtied(this);
        }
    }

    void read() throws IndexException {
        try {
            ByteBuffer buf = ByteBuffer.wrap(this.fBuffer);
            this.fDatabase.read(buf, (long)this.fSequenceNumber * 4096L);
        }
        catch (IOException e) {
            throw new IndexException((IStatus)new DBStatus(e));
        }
    }

    boolean flush() throws IndexException {
        if (Database.DEBUG_PAGE_CACHE) {
            System.out.println("CHUNK " + this.fSequenceNumber + ": flushing - instance " + System.identityHashCode(this));
        }
        boolean wasCanceled = false;
        try {
            ByteBuffer buf = ByteBuffer.wrap(this.fBuffer);
            wasCanceled = this.fDatabase.write(buf, (long)this.fSequenceNumber * 4096L);
        }
        catch (IOException e) {
            throw new IndexException((IStatus)new DBStatus(e));
        }
        this.fDirty = false;
        this.fDatabase.chunkCleaned(this);
        return wasCanceled;
    }

    static int recPtrToIndex(long offset) {
        return (int)(offset & 0xFFFL);
    }

    public void putByte(long offset, byte value) {
        this.makeDirty();
        this.fBuffer[Chunk.recPtrToIndex((long)offset)] = value;
        this.recordWrite(offset, 1);
    }

    public byte getByte(long offset) {
        return this.fBuffer[Chunk.recPtrToIndex(offset)];
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[this.fBuffer.length];
        System.arraycopy(this.fBuffer, 0, bytes, 0, this.fBuffer.length);
        return bytes;
    }

    public byte[] getBytes(long offset, int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(this.fBuffer, Chunk.recPtrToIndex(offset), bytes, 0, length);
        return bytes;
    }

    public void putBytes(long offset, byte[] bytes) {
        this.makeDirty();
        System.arraycopy(bytes, 0, this.fBuffer, Chunk.recPtrToIndex(offset), bytes.length);
        this.recordWrite(offset, bytes.length);
    }

    public void putInt(long offset, int value) {
        this.makeDirty();
        int idx = Chunk.recPtrToIndex(offset);
        Chunk.putInt(value, this.fBuffer, idx);
        this.recordWrite(offset, 4);
    }

    static final void putInt(int value, byte[] buffer, int idx) {
        buffer[idx] = (byte)(value >> 24);
        buffer[++idx] = (byte)(value >> 16);
        buffer[++idx] = (byte)(value >> 8);
        buffer[++idx] = (byte)value;
    }

    public int getInt(long offset) {
        return Chunk.getInt(this.fBuffer, Chunk.recPtrToIndex(offset));
    }

    static final int getInt(byte[] buffer, int idx) {
        return (buffer[idx] & 0xFF) << 24 | (buffer[++idx] & 0xFF) << 16 | (buffer[++idx] & 0xFF) << 8 | (buffer[++idx] & 0xFF) << 0;
    }

    static int compressFreeRecPtr(long value) {
        assert ((value & 7L) == 0L);
        int dense = (int)(value >> 3);
        return dense;
    }

    static long expandToFreeRecPtr(int value) {
        long address = (long)value & 0xFFFFFFFFL;
        return address << 3;
    }

    public void putRecPtr(long offset, long value) {
        this.makeDirty();
        int idx = Chunk.recPtrToIndex(offset);
        Database.putRecPtr(value, this.fBuffer, idx);
        this.recordWrite(offset, 4);
    }

    public void putFreeRecPtr(long offset, long value) {
        this.makeDirty();
        int idx = Chunk.recPtrToIndex(offset);
        Chunk.putInt(Chunk.compressFreeRecPtr(value), this.fBuffer, idx);
        this.recordWrite(offset, 4);
    }

    public long getRecPtr(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        return Database.getRecPtr(this.fBuffer, idx);
    }

    public long getFreeRecPtr(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        int value = Chunk.getInt(this.fBuffer, idx);
        return Chunk.expandToFreeRecPtr(value);
    }

    public void put3ByteUnsignedInt(long offset, int value) {
        this.makeDirty();
        int idx = Chunk.recPtrToIndex(offset);
        this.fBuffer[idx] = (byte)(value >> 16);
        this.fBuffer[++idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
        this.recordWrite(offset, 3);
    }

    public int get3ByteUnsignedInt(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        return (this.fBuffer[idx] & 0xFF) << 16 | (this.fBuffer[++idx] & 0xFF) << 8 | (this.fBuffer[++idx] & 0xFF) << 0;
    }

    public void putShort(long offset, short value) {
        this.makeDirty();
        int idx = Chunk.recPtrToIndex(offset);
        this.fBuffer[idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
        this.recordWrite(offset, 2);
    }

    private void recordWrite(long offset, int size) {
        this.fDatabase.getLog().recordWrite(offset, size);
    }

    public short getShort(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        return (short)(this.fBuffer[idx] << 8 | this.fBuffer[++idx] & 0xFF);
    }

    public long getLong(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        return ((long)this.fBuffer[idx] & 0xFFL) << 56 | ((long)this.fBuffer[++idx] & 0xFFL) << 48 | ((long)this.fBuffer[++idx] & 0xFFL) << 40 | ((long)this.fBuffer[++idx] & 0xFFL) << 32 | ((long)this.fBuffer[++idx] & 0xFFL) << 24 | ((long)this.fBuffer[++idx] & 0xFFL) << 16 | ((long)this.fBuffer[++idx] & 0xFFL) << 8 | ((long)this.fBuffer[++idx] & 0xFFL) << 0;
    }

    public double getDouble(long offset) {
        return Double.longBitsToDouble(this.getLong(offset));
    }

    public float getFloat(long offset) {
        return Float.intBitsToFloat(this.getInt(offset));
    }

    public void putLong(long offset, long value) {
        this.makeDirty();
        int idx = Chunk.recPtrToIndex(offset);
        this.fBuffer[idx] = (byte)(value >> 56);
        this.fBuffer[++idx] = (byte)(value >> 48);
        this.fBuffer[++idx] = (byte)(value >> 40);
        this.fBuffer[++idx] = (byte)(value >> 32);
        this.fBuffer[++idx] = (byte)(value >> 24);
        this.fBuffer[++idx] = (byte)(value >> 16);
        this.fBuffer[++idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
        this.recordWrite(offset, 8);
    }

    public void putChar(long offset, char value) {
        this.makeDirty();
        int idx = Chunk.recPtrToIndex(offset);
        this.fBuffer[idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
        this.recordWrite(offset, 2);
    }

    public void putChars(long offset, char[] chars, int start, int len) {
        this.makeDirty();
        int idx = Chunk.recPtrToIndex(offset) - 1;
        int end = start + len;
        int i = start;
        while (i < end) {
            char value = chars[i];
            this.fBuffer[++idx] = (byte)(value >> 8);
            this.fBuffer[++idx] = (byte)value;
            ++i;
        }
        this.recordWrite(offset, len * 2);
    }

    public void putCharsAsBytes(long offset, char[] chars, int start, int len) {
        this.makeDirty();
        int idx = Chunk.recPtrToIndex(offset) - 1;
        int end = start + len;
        int i = start;
        while (i < end) {
            char value = chars[i];
            this.fBuffer[++idx] = (byte)value;
            ++i;
        }
        this.recordWrite(offset, len);
    }

    public void putDouble(long offset, double value) {
        this.putLong(offset, Double.doubleToLongBits(value));
    }

    public void putFloat(long offset, float value) {
        this.putInt(offset, Float.floatToIntBits(value));
    }

    public char getChar(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        return (char)(this.fBuffer[idx] << 8 | this.fBuffer[++idx] & 0xFF);
    }

    public void getChars(long offset, char[] result, int start, int len) {
        ByteBuffer buf = ByteBuffer.wrap(this.fBuffer);
        buf.position(Chunk.recPtrToIndex(offset));
        buf.asCharBuffer().get(result, start, len);
    }

    public void getCharsFromBytes(long offset, char[] result, int start, int len) {
        int pos = Chunk.recPtrToIndex(offset);
        int i = 0;
        while (i < len) {
            result[start + i] = (char)(this.fBuffer[pos + i] & 0xFF);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    void clear(long offset, int length) {
        this.makeDirty();
        idx = Chunk.recPtrToIndex(offset);
        end = idx + length;
        if (end <= this.fBuffer.length) ** GOTO lbl8
        throw new IndexException("Attempting to clear beyond end of chunk. Chunk = " + this.fSequenceNumber + ", offset = " + offset + ", length = " + length);
lbl-1000:
        // 1 sources

        {
            this.fBuffer[idx] = 0;
            ++idx;
lbl8:
            // 2 sources

            ** while (idx < end)
        }
lbl9:
        // 1 sources

        this.recordWrite(offset, length);
    }

    void put(long offset, byte[] data, int len) {
        this.put(offset, data, 0, len);
    }

    void put(long offset, byte[] data, int dataPos, int len) {
        this.makeDirty();
        int idx = Chunk.recPtrToIndex(offset);
        System.arraycopy(data, dataPos, this.fBuffer, idx, len);
        this.recordWrite(offset, len);
    }

    public void get(long offset, byte[] data) {
        this.get(offset, data, 0, data.length);
    }

    public void get(long offset, byte[] data, int dataPos, int len) {
        int idx = Chunk.recPtrToIndex(offset);
        System.arraycopy(this.fBuffer, idx, data, dataPos, len);
    }

    public Chunk getWritableChunk() {
        Chunk result = this.fDatabase.getChunk(this.fSequenceNumber * 4096);
        result.makeDirty();
        return result;
    }
}

