/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.EGitFilePasswordProvider;
import org.eclipse.egit.core.internal.SshPreferencesMirror;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.eclipse.jgit.transport.sshd.ProxyData;
import org.eclipse.jgit.transport.sshd.ProxyDataFactory;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.eclipse.jgit.transport.sshd.agent.Connector;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;
import org.eclipse.jgit.util.StringUtils;

public class EGitSshdSessionFactory
extends SshdSessionFactory {
    public EGitSshdSessionFactory(IProxyService service) {
        super(null, (ProxyDataFactory)new EGitProxyDataFactory(service));
        SshPreferencesMirror.INSTANCE.start();
    }

    public void close() {
        SshPreferencesMirror.INSTANCE.stop();
        super.close();
    }

    public File getSshDirectory() {
        File file = super.getSshDirectory();
        if (file != null) {
            return file;
        }
        return SshPreferencesMirror.INSTANCE.getSshDirectory();
    }

    @NonNull
    protected List<Path> getDefaultIdentities(@NonNull File sshDir) {
        List<Path> defaultKeys = SshPreferencesMirror.INSTANCE.getDefaultIdentities(sshDir);
        if (defaultKeys == null || defaultKeys.isEmpty()) {
            return super.getDefaultIdentities(sshDir);
        }
        return defaultKeys;
    }

    protected String getDefaultPreferredAuthentications() {
        return SshPreferencesMirror.INSTANCE.getPreferredAuthentications();
    }

    protected ConnectorFactory getConnectorFactory() {
        ConnectorFactory factory;
        if (Platform.getPreferencesService().getBoolean("org.eclipse.egit.core", "core_ssh_agent", true, null) && (factory = super.getConnectorFactory()) != null) {
            return new WrappedSshAgentConnectorFactory(factory);
        }
        return null;
    }

    protected KeyPasswordProvider createKeyPasswordProvider(CredentialsProvider provider) {
        return new EGitFilePasswordProvider(provider);
    }

    private static class EGitProxyDataFactory
    implements ProxyDataFactory {
        private final IProxyService proxyService;

        public EGitProxyDataFactory(IProxyService service) {
            this.proxyService = service;
        }

        public ProxyData get(InetSocketAddress remoteAddress) {
            IProxyData[] data;
            block3: {
                try {
                    data = this.proxyService.select(new URI("SOCKS", "//" + remoteAddress.getHostString(), null));
                    if (data != null && data.length != 0 || (data = this.proxyService.select(new URI("HTTP", "//" + remoteAddress.getHostString(), null))) != null && data.length != 0) break block3;
                    return null;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
            return this.newData(data[0]);
        }

        private ProxyData newData(IProxyData data) {
            if (data == null) {
                return null;
            }
            InetSocketAddress proxyAddress = new InetSocketAddress(data.getHost(), data.getPort());
            char[] password = null;
            try {
                password = data.getPassword() == null ? null : data.getPassword().toCharArray();
                switch (data.getType()) {
                    case "HTTP": {
                        Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyAddress);
                        ProxyData proxyData = new ProxyData(proxy, data.getUserId(), password);
                        return proxyData;
                    }
                    case "SOCKS": {
                        Proxy proxy = new Proxy(Proxy.Type.SOCKS, proxyAddress);
                        ProxyData proxyData = new ProxyData(proxy, data.getUserId(), password);
                        return proxyData;
                    }
                }
                return null;
            }
            finally {
                if (password != null) {
                    Arrays.fill(password, '\u0000');
                }
            }
        }
    }

    private static class WrappedSshAgentConnectorFactory
    implements ConnectorFactory {
        private static final AtomicBoolean WARNED = new AtomicBoolean();
        private final ConnectorFactory delegate;

        WrappedSshAgentConnectorFactory(@NonNull ConnectorFactory realFactory) {
            this.delegate = realFactory;
        }

        public Connector create(String identityAgent, File homeDir) throws IOException {
            String preference;
            String agentConnection = identityAgent;
            if (StringUtils.isEmptyOrNull((String)identityAgent) && (preference = Platform.getPreferencesService().getString("org.eclipse.egit.core", "core_ssh_default_agent", null, null)) != null) {
                if (this.getSupportedConnectors().stream().anyMatch(d -> preference.equals(d.getIdentityAgent()))) {
                    agentConnection = preference;
                } else if (!WARNED.getAndSet(true)) {
                    Activator.logWarning(MessageFormat.format(CoreText.EGitSshdSessionFactory_sshUnknownAgentWarning, preference), null);
                }
            }
            return this.delegate.create(agentConnection, homeDir);
        }

        public boolean isSupported() {
            return this.delegate.isSupported();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Collection<ConnectorFactory.ConnectorDescriptor> getSupportedConnectors() {
            return this.delegate.getSupportedConnectors();
        }

        public ConnectorFactory.ConnectorDescriptor getDefaultConnector() {
            return this.delegate.getDefaultConnector();
        }
    }
}

