/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheTree;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;

@Command(usage="usage_ShowCacheTree")
class ShowCacheTree
extends TextBuiltin {
    ShowCacheTree() {
    }

    @Override
    protected void run() throws Exception {
        DirCache cache = this.db.readDirCache();
        DirCacheTree tree = cache.getCacheTree(false);
        if (tree == null) {
            throw ShowCacheTree.die(CLIText.get().noTREESectionInIndex);
        }
        this.show(tree);
    }

    private void show(DirCacheTree tree) throws IOException {
        this.outw.println(MessageFormat.format(CLIText.get().cacheTreePathInfo, tree.getPathString(), tree.getEntrySpan(), tree.getChildCount()));
        int i = 0;
        while (i < tree.getChildCount()) {
            this.show(tree.getChild(i));
            ++i;
        }
    }
}

