/*******************************************************************************
 * Copyright (c) 2014 Liviu Ionescu.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Liviu Ionescu - initial version
 *     		(many thanks to Code Red for providing the inspiration)
 *******************************************************************************/

package org.eclipse.embedcdt.debug.gdbjtag.ui.render.peripheral;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingTypeDelegate;
import org.eclipse.embedcdt.internal.debug.gdbjtag.ui.preferences.PeripheralRendering;

public class PeripheralRenderingDelegate implements IMemoryRenderingTypeDelegate {

	// ------------------------------------------------------------------------

	@Override
	public IMemoryRendering createRendering(String id) throws CoreException {
		return new PeripheralRendering(id);
	}

	// ------------------------------------------------------------------------
}
