/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.connection;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.net.ssl.KeyManagerFactory;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.exceptions.ServerKeyStoreException;

public final class ServerKeyStoreManager {
    private static ServerKeyStoreManager instance;
    private KeyStore keyStore;

    private ServerKeyStoreManager() {
    }

    public static synchronized ServerKeyStoreManager getInstance() {
        if (instance == null) {
            instance = new ServerKeyStoreManager();
        }
        return instance;
    }

    public String decrypt(String password) throws ServerKeyStoreException {
        try {
            if (password == null) {
                throw new ServerKeyStoreException("Password is null.");
            }
            byte[] passwordBytes = Base64.decodeBase64((byte[])password.getBytes());
            Cipher cipher = Cipher.getInstance(ServerConfiguration.getProperties().getProperty("emfstore.keystore.cipher.algorithm", "RSA"));
            cipher.init(2, this.getDecryptionKey());
            return new String(cipher.doFinal(passwordBytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServerKeyStoreException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new ServerKeyStoreException(e);
        }
        catch (InvalidKeyException e) {
            throw new ServerKeyStoreException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ServerKeyStoreException(e);
        }
        catch (BadPaddingException e) {
            throw new ServerKeyStoreException(e);
        }
    }

    private PrivateKey getDecryptionKey() throws ServerKeyStoreException {
        try {
            return (PrivateKey)this.getKeyStore().getKey(this.getKeyStoreAlias(), this.getKeyStorePassword());
        }
        catch (ServerKeyStoreException e) {
            throw new ServerKeyStoreException(e);
        }
        catch (KeyStoreException e) {
            throw new ServerKeyStoreException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServerKeyStoreException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new ServerKeyStoreException(e);
        }
    }

    public KeyStore getKeyStore() throws ServerKeyStoreException {
        if (this.keyStore == null) {
            FileInputStream fileInputStream = null;
            try {
                try {
                    this.keyStore = KeyStore.getInstance("JKS");
                    fileInputStream = new FileInputStream(ServerConfiguration.getServerKeyStorePath());
                    this.keyStore.load(fileInputStream, this.getKeyStorePassword());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ServerKeyStoreException(e);
                }
                catch (CertificateException e) {
                    throw new ServerKeyStoreException(e);
                }
                catch (FileNotFoundException e) {
                    throw new ServerKeyStoreException(e);
                }
                catch (IOException e) {
                    throw new ServerKeyStoreException(e);
                }
                catch (KeyStoreException e) {
                    throw new ServerKeyStoreException(e);
                }
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new ServerKeyStoreException(e);
                }
            }
        }
        return this.keyStore;
    }

    public KeyManagerFactory getKeyManagerFactory() throws ServerKeyStoreException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(ServerConfiguration.getProperties().getProperty("emfstore.keystore.certificate.type", "SunX509"));
            keyManagerFactory.init(this.getKeyStore(), this.getKeyStorePassword());
            return keyManagerFactory;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServerKeyStoreException(e);
        }
        catch (KeyStoreException e) {
            throw new ServerKeyStoreException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new ServerKeyStoreException(e);
        }
    }

    public void setJavaSSLProperties() {
        System.setProperty("javax.net.ssl.keyStore", ServerConfiguration.getServerKeyStorePath());
        System.setProperty("javax.net.ssl.trustStore", ServerConfiguration.getServerKeyStorePath());
        System.setProperty("javax.net.ssl.keyStorePassword", Arrays.toString(this.getKeyStorePassword()));
        System.setProperty("javax.net.ssl.trustStorePassword", Arrays.toString(this.getKeyStorePassword()));
    }

    private char[] getKeyStorePassword() {
        return ServerConfiguration.getProperties().getProperty("emfstore.keystore.password", "123456").toCharArray();
    }

    private String getKeyStoreAlias() {
        return ServerConfiguration.getProperties().getProperty("emfstore.keystore.alias", "testkeygeneratedbyotto");
    }
}

