/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.Messages;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceSetOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReferenceSetConflict
extends VisualConflict {
    private static final String MULTIREF_GIF = "multiref.gif";
    private static final String OTHER_CONTAINER_KEY = "othercontainer";
    private static final String TARGET_KEY = "target";
    private static final String MULTIREFERENCE_SET_CONFLICT_MY_KEY = "multireferencesetconflict.my";
    private static final String MULTIREFERENCE_SET_CONFLICT_THEIR_KEY = "multireferencesetconflict.their";
    private static final String MULTIREFERENCE_SET_CONFLICT_CONTAINMENT_KEY = "multireferencesetconflict.containment";
    private final boolean containmentConflict = ((MultiReferenceOperation)this.getLeftOperation()).isAdd() && !this.getLeftOperation().getModelElementId().equals(this.getRightOperation().getModelElementId());

    public MultiReferenceSetConflict(ConflictBucket conf, DecisionManager decisionManager, boolean myMultiRef) {
        super(conf, decisionManager, myMultiRef, false);
        this.init();
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        if (this.containmentConflict) {
            description.setDescription(DecisionUtil.getDescription(MULTIREFERENCE_SET_CONFLICT_CONTAINMENT_KEY, this.getDecisionManager().isBranchMerge()));
        } else if (this.isLeftMy()) {
            description.setDescription(DecisionUtil.getDescription(MULTIREFERENCE_SET_CONFLICT_MY_KEY, this.getDecisionManager().isBranchMerge()));
        } else {
            description.setDescription(DecisionUtil.getDescription(MULTIREFERENCE_SET_CONFLICT_THEIR_KEY, this.getDecisionManager().isBranchMerge()));
        }
        description.add(TARGET_KEY, this.isLeftMy() ? (ModelElementId)this.getMyOperation(MultiReferenceOperation.class).getReferencedModelElements().get(0) : this.getMyOperation(MultiReferenceSetOperation.class).getNewValue());
        description.add(OTHER_CONTAINER_KEY, this.getLeftOperation().getModelElementId());
        description.setImage(MULTIREF_GIF);
        return description;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ConflictOption myOption = new ConflictOption("", ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ConflictOption theirOption = new ConflictOption("", ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        if (this.containmentConflict) {
            EObject target = this.getDecisionManager().getModelElement((ModelElementId)((MultiReferenceOperation)this.getLeftOperation()).getReferencedModelElements().get(0));
            myOption.setOptionLabel(MessageFormat.format(Messages.MultiReference_Move_To, DecisionUtil.getClassAndName(target), DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getMyOperation().getModelElementId()))));
            theirOption.setOptionLabel(MessageFormat.format(Messages.MultiReference_Move_To, DecisionUtil.getClassAndName(target), DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getTheirOperation().getModelElementId()))));
        } else if (this.isLeftMy()) {
            EObject target = this.getDecisionManager().getModelElement((ModelElementId)this.getMyOperation(MultiReferenceOperation.class).getReferencedModelElements().get(0));
            myOption.setOptionLabel(String.valueOf(Messages.MultiReferenceSetConflict_Remove) + DecisionUtil.getClassAndName(target));
            theirOption.setOptionLabel(String.valueOf(Messages.MultiReferenceSetConflict_Set) + DecisionUtil.getClassAndName(target));
        } else {
            EObject target = this.getDecisionManager().getModelElement((ModelElementId)this.getTheirOperation(MultiReferenceOperation.class).getReferencedModelElements().get(0));
            myOption.setOptionLabel(String.valueOf(Messages.MultiReferenceSetConflict_Set) + DecisionUtil.getClassAndName(target));
            theirOption.setOptionLabel(String.valueOf(Messages.MultiReferenceSetConflict_Remove) + DecisionUtil.getClassAndName(target));
        }
        options.add(myOption);
        options.add(theirOption);
    }
}

