/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.epackages.EPackageRegistryHelper;
import org.eclipse.emf.emfstore.internal.client.ui.epackages.EPackageTreeSelectionDialog;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIRegisterEPackageController
extends AbstractEMFStoreUIController<Void> {
    private final ServerInfo serverInfo;

    public UIRegisterEPackageController(Shell shell, ESServer serverInfo) {
        super(shell);
        this.serverInfo = (ServerInfo)((ESServerImpl)serverInfo).toInternalAPI();
    }

    public void registerEPackage(ServerInfo serverInfo) throws ESException {
        EPackageTreeSelectionDialog dialog = new EPackageTreeSelectionDialog(EPackageRegistryHelper.getAvailablePackages(true));
        dialog.open();
        final EPackage pkg = dialog.getSelectedEPackage();
        if (pkg != null) {
            new ServerCall<Void>(serverInfo.getLastUsersession()){

                protected Void run() throws ESException {
                    this.getConnectionManager().registerEPackage(this.getSessionId(), pkg);
                    return null;
                }
            }.execute();
        }
    }

    @Override
    public Void doRun(IProgressMonitor monitor) {
        try {
            this.registerEPackage(this.serverInfo);
        }
        catch (ESException e) {
            RunInUI.run(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    WorkspaceUtil.logException((String)e.getMessage(), (Exception)((Object)e));
                    MessageDialog.openError((Shell)UIRegisterEPackageController.this.getShell(), (String)Messages.UIRegisterEPackageController_RegistrationFailed, (String)e.getMessage());
                    return null;
                }
            });
        }
        return null;
    }
}

