/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.IOException;
import java.io.Reader;
import org.apache.jena.atlas.io.CharStream;

public abstract class CharStreamReader
extends Reader
implements CharStream {
    private boolean isClosed = false;

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.isClosed) {
            return -1;
        }
        for (int i = off; i < off + len; ++i) {
            int x = this.advance();
            if (x == -1) {
                this.close();
                if (i == off) {
                    return -1;
                }
                return i - off;
            }
            cbuf[i] = (char)x;
        }
        return len;
    }

    @Override
    public int read() throws IOException {
        if (this.isClosed) {
            return -1;
        }
        return this.advance();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.closeStream();
    }

    @Override
    public boolean ready() throws IOException {
        return !this.isClosed;
    }

    @Override
    public abstract int advance();

    @Override
    public abstract void closeStream();
}

