/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib.cache;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.SingletonIterator;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.cache.CacheOps;

public class Cache1<K, V>
implements Cache<K, V> {
    private final BiConsumer<K, V> dropHandler;
    private K cacheKey;
    private V cacheValue;

    public Cache1() {
        this(null);
    }

    public Cache1(BiConsumer<K, V> dropHandler) {
        this.clear();
        this.dropHandler = dropHandler;
    }

    @Override
    public boolean containsKey(K key) {
        if (this.cacheKey == null) {
            return false;
        }
        return this.cacheKey.equals(key);
    }

    @Override
    public V getIfPresent(K key) {
        if (this.cacheKey == null) {
            return null;
        }
        if (this.cacheKey.equals(key)) {
            return this.cacheValue;
        }
        return null;
    }

    @Override
    public V get(K key, Function<K, V> function) {
        return CacheOps.getOrFillSync(this, key, function);
    }

    @Override
    public void clear() {
        if (this.cacheKey == null) {
            return;
        }
        K k = this.cacheKey;
        V v = this.cacheValue;
        this.cacheKey = null;
        this.cacheValue = null;
        this.notifyDrop(k, v);
    }

    @Override
    public boolean isEmpty() {
        return this.cacheKey == null;
    }

    @Override
    public Iterator<K> keys() {
        return new SingletonIterator<K>(this.cacheKey);
    }

    @Override
    public void put(K key, V thing) {
        if (Objects.equals(this.cacheKey, key) && Objects.equals(this.cacheValue, thing)) {
            return;
        }
        K k = this.cacheKey;
        V v = this.cacheValue;
        this.cacheKey = key;
        this.cacheValue = thing;
        this.notifyDrop(k, v);
    }

    @Override
    public void remove(K key) {
        if (this.cacheKey == null) {
            return;
        }
        if (this.cacheKey.equals(key)) {
            this.clear();
        }
    }

    private void notifyDrop(K key, V thing) {
        if (this.dropHandler != null && key != null) {
            this.dropHandler.accept(key, thing);
        }
    }

    @Override
    public long size() {
        return this.cacheKey == null ? 0L : 1L;
    }
}

