/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.Dyadic;
import org.apache.jena.graph.compose.Polyadic;
import org.apache.jena.graph.impl.WrappedGraph;
import org.apache.jena.mem.GraphMemBase;
import org.apache.jena.ontapi.UnionGraph;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.graph.GraphWrapper;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;

public class Graphs {
    public static Stream<Graph> directSubGraphs(Graph graph) {
        if (graph instanceof UnionGraph) {
            return ((UnionGraph)graph).subGraphs();
        }
        if (graph instanceof Polyadic) {
            return ((Polyadic)graph).getSubGraphs().stream();
        }
        if (graph instanceof Dyadic) {
            return Stream.of(((Dyadic)graph).getR());
        }
        return Stream.empty();
    }

    public static Graph getPrimary(Graph graph) {
        if (graph instanceof UnionGraph) {
            return ((UnionGraph)graph).getBaseGraph();
        }
        if (graph instanceof Polyadic) {
            return ((Polyadic)graph).getBaseGraph();
        }
        if (graph instanceof Dyadic) {
            return ((Dyadic)graph).getL();
        }
        return graph;
    }

    public static Graph unwrap(Graph graph) {
        if (Graphs.isGraphMem(graph)) {
            return graph;
        }
        ArrayDeque<Graph> candidates = new ArrayDeque<Graph>();
        candidates.add(graph);
        HashSet<Graph> seen = new HashSet<Graph>();
        while (!candidates.isEmpty()) {
            Graph g = (Graph)candidates.removeFirst();
            if (!seen.add(g)) continue;
            if (g instanceof GraphWrapper) {
                candidates.add(((GraphWrapper)g).get());
                continue;
            }
            if (g instanceof WrappedGraph) {
                candidates.add(((WrappedGraph)g).getWrapped());
                continue;
            }
            if (g instanceof UnionGraph) {
                candidates.add(((UnionGraph)g).getBaseGraph());
                continue;
            }
            if (g instanceof Polyadic) {
                candidates.add(((Polyadic)g).getBaseGraph());
                continue;
            }
            if (g instanceof Dyadic) {
                candidates.add(((Dyadic)g).getL());
                continue;
            }
            if (g instanceof InfGraph) {
                candidates.add(((InfGraph)g).getRawGraph());
            }
            return g;
        }
        return graph;
    }

    public static boolean isWrapper(Graph g) {
        return g instanceof GraphWrapper || g instanceof WrappedGraph || g instanceof UnionGraph || g instanceof Polyadic || g instanceof Dyadic || g instanceof InfGraph;
    }

    public static boolean isGraphMem(Graph graph) {
        return graph instanceof GraphMemBase;
    }

    public static boolean isGraphInf(Graph graph) {
        return graph instanceof InfGraph;
    }

    public static Stream<Graph> dataGraphs(Graph graph) {
        return Graphs.flatTree(graph, Graphs::unwrap, Graphs::directSubGraphs);
    }

    public static Stream<Graph> flatTree(Graph graph, Function<Graph, Graph> getBase, Function<Graph, Stream<Graph>> listSubGraphs) {
        if (graph == null) {
            return Stream.empty();
        }
        if (Graphs.isGraphMem(graph)) {
            return Stream.of(graph);
        }
        LinkedHashSet<Graph> res = new LinkedHashSet<Graph>();
        ArrayDeque<Graph> queue = new ArrayDeque<Graph>();
        HashSet<Graph> seen = new HashSet<Graph>();
        queue.add(graph);
        while (!queue.isEmpty()) {
            Graph g = (Graph)queue.removeFirst();
            if (!seen.add(g)) continue;
            Graph bg = getBase.apply(g);
            res.add(bg);
            listSubGraphs.apply(g).forEach(queue::add);
        }
        return res.stream();
    }

    public static boolean isSameBase(Graph left, Graph right) {
        return Objects.equals(Graphs.unwrap(left), Graphs.unwrap(right));
    }

    public static boolean isDistinct(Graph graph) {
        if (Graphs.isGraphMem(graph)) {
            return true;
        }
        if (graph instanceof UnionGraph) {
            UnionGraph u = (UnionGraph)graph;
            return u.isDistinct() || !u.hasSubGraph() && Graphs.isDistinct(Graphs.getPrimary(u));
        }
        return false;
    }

    public static boolean isSized(Graph graph) {
        if (Graphs.isGraphMem(graph)) {
            return true;
        }
        if (Graphs.directSubGraphs(graph).findFirst().isPresent()) {
            return false;
        }
        return Graphs.isGraphMem(Graphs.getPrimary(graph));
    }

    public static long size(Graph graph) {
        if (Graphs.isGraphMem(graph)) {
            return graph.size();
        }
        if (Graphs.directSubGraphs(graph).findFirst().isPresent()) {
            return Iterators.count(graph.find());
        }
        return Graphs.getPrimary(graph).size();
    }

    public static UnionGraph makeOntUnionFrom(Graph graph, Function<Graph, UnionGraph> wrapAsUnion) {
        if (graph instanceof UnionGraph) {
            return (UnionGraph)graph;
        }
        if (Graphs.isGraphMem(graph)) {
            return wrapAsUnion.apply(graph);
        }
        return Graphs.makeOntUnion(Graphs.getPrimary(graph), Graphs.dataGraphs(graph).collect(Collectors.toSet()), wrapAsUnion);
    }

    public static UnionGraph makeOntUnion(Graph graph, Collection<Graph> repository, Function<Graph, UnionGraph> wrapAsUnion) {
        ArrayDeque<Graph> graphs = new ArrayDeque<Graph>();
        graphs.add(graph);
        LinkedHashMap<String, UnionGraph> res = new LinkedHashMap<String, UnionGraph>();
        HashSet<String> seen = new HashSet<String>();
        while (!graphs.isEmpty()) {
            Set imports;
            String name;
            Graph next = (Graph)graphs.removeFirst();
            Node ontology = Graphs.findOntologyNameNode(next).orElse(null);
            if (ontology == null || (name = ontology.toString()) == null || !seen.add(name) || (imports = (Set)Iterators.addAll(Graphs.listImports(ontology, next), new HashSet())).isEmpty()) continue;
            UnionGraph parent = res.computeIfAbsent(name, s -> (UnionGraph)wrapAsUnion.apply(next));
            repository.stream().filter(it -> !imports.isEmpty()).forEach(candidate -> {
                String candidateIri = Graphs.findOntologyNameNode(candidate).filter(Node::isURI).map(Node::getURI).orElse(null);
                if (imports.contains(candidateIri)) {
                    UnionGraph child = res.computeIfAbsent(candidateIri, s -> (UnionGraph)wrapAsUnion.apply((Graph)candidate));
                    parent.addSubGraph(child);
                    graphs.add(child);
                    imports.remove(candidateIri);
                }
            });
        }
        return res.isEmpty() ? wrapAsUnion.apply(graph) : (UnionGraph)res.values().iterator().next();
    }

    public static Stream<UnionGraph> flatHierarchy(UnionGraph graph) {
        Objects.requireNonNull(graph);
        LinkedHashSet<UnionGraph> res = new LinkedHashSet<UnionGraph>();
        ArrayDeque<UnionGraph> queue = new ArrayDeque<UnionGraph>();
        queue.add(graph);
        while (!queue.isEmpty()) {
            UnionGraph next = (UnionGraph)queue.removeFirst();
            if (!res.add(next)) continue;
            next.subGraphs().filter(it -> it instanceof UnionGraph).map(it -> (UnionGraph)it).forEach(queue::add);
            next.superGraphs().forEach(queue::add);
        }
        return res.stream();
    }

    public static boolean isOntGraph(Graph graph) {
        return graph.contains(Node.ANY, RDF.type.asNode(), OWL2.Ontology.asNode());
    }

    public static boolean isOntUnionGraph(UnionGraph graph, boolean allowMultipleOntologyHeaders) {
        Node id = Graphs.findOntologyNameNode(graph.getBaseGraph(), allowMultipleOntologyHeaders).orElse(null);
        if (id == null) {
            return false;
        }
        LinkedHashMap<Node, UnionGraph> queue = new LinkedHashMap<Node, UnionGraph>();
        queue.put(id, graph);
        HashSet<Node> seen = new HashSet<Node>();
        while (!queue.isEmpty()) {
            Node nextId = (Node)queue.keySet().iterator().next();
            UnionGraph nextGraph = (UnionGraph)queue.remove(nextId);
            if (!seen.add(nextId)) continue;
            Set<String> nextImports = Graphs.getImports(nextGraph.getBaseGraph(), allowMultipleOntologyHeaders);
            Iterator children = nextGraph.subGraphs().filter(it -> it instanceof UnionGraph).map(it -> (UnionGraph)it).iterator();
            while (children.hasNext()) {
                UnionGraph g = (UnionGraph)children.next();
                Node gid = Graphs.findOntologyNameNode(g.getBaseGraph(), allowMultipleOntologyHeaders).orElse(null);
                if (gid == null || !gid.isURI() || !nextImports.contains(gid.getURI())) {
                    return false;
                }
                queue.put(gid, g);
            }
        }
        return true;
    }

    public static Node createOntologyHeaderNode(Graph graph, String uriOrNull) {
        Node header = Graphs.ontologyNode(graph).orElse(null);
        if (header != null) {
            if (uriOrNull != null && header.isURI() && header.getURI().equals(uriOrNull)) {
                return header;
            }
            if (uriOrNull == null && header.isBlank()) {
                return header;
            }
        }
        return Graphs.makeOntologyHeaderNode(graph, Graphs.createNode(uriOrNull));
    }

    public static Node makeOntologyHeaderNode(Graph graph, Node newOntology) {
        Objects.requireNonNull(graph, "graph is null");
        Objects.requireNonNull(newOntology, "ontology node is null");
        Set prev = Iterators.addAll(Iterators.flatMap(graph.find(Node.ANY, RDF.type.asNode(), OWL2.Ontology.asNode()), it -> graph.find(it.getSubject(), Node.ANY, Node.ANY)), new HashSet());
        Set subjects = prev.stream().map(Triple::getSubject).collect(Collectors.toSet());
        if (subjects.contains(newOntology)) {
            if (subjects.size() == 1) {
                return newOntology;
            }
        } else {
            graph.add(newOntology, RDF.type.asNode(), OWL2.Ontology.asNode());
        }
        prev.forEach(t -> {
            if (!newOntology.equals(t.getSubject())) {
                graph.delete((Triple)t);
            }
        });
        prev.forEach(t -> {
            if (!newOntology.equals(t.getSubject())) {
                graph.add(newOntology, t.getPredicate(), t.getObject());
            }
        });
        return newOntology;
    }

    public static Optional<Node> findOntologyNameNode(Graph graph) {
        return Graphs.findOntologyNameNode(graph, false);
    }

    public static Optional<Node> findOntologyNameNode(Graph graph, boolean allowMultipleOntologyHeaders) {
        if (graph.isClosed()) {
            throw new IllegalArgumentException("Graph is closed");
        }
        Node ontologyIri = Graphs.ontologyNode(graph, allowMultipleOntologyHeaders).orElse(null);
        if (ontologyIri == null) {
            return Optional.empty();
        }
        Optional<Node> versionIri = Graphs.findVersionIRI(graph, ontologyIri);
        if (versionIri.isPresent()) {
            return versionIri;
        }
        return Optional.of(ontologyIri);
    }

    public static Optional<Node> findVersionIRI(Graph graph, Node header) {
        Set<Node> versionNodes = Iterators.takeAsSet(graph.find(header, OWL2.versionIRI.asNode(), Node.ANY).mapWith(Triple::getObject).filterKeep(Node::isURI), 2);
        if (versionNodes.size() == 1) {
            return Optional.of(versionNodes.iterator().next());
        }
        return Optional.empty();
    }

    public static Optional<Node> ontologyNode(Graph graph, boolean allowMultipleOntologyHeaders) {
        if (allowMultipleOntologyHeaders) {
            List res = Iterators.addAll(Graphs.listOntologyNodes(graph), new ArrayList());
            if (res.isEmpty()) {
                return Optional.empty();
            }
            if (res.size() == 1) {
                return Optional.of((Node)res.get(0));
            }
            res.sort(Graphs.rootNodeComparator(graph));
            return Optional.of((Node)res.get(0));
        }
        return Graphs.ontologyNode(graph);
    }

    public static Optional<Node> ontologyNode(Graph graph) {
        ExtendedIterator<Node> ontologyNodes = Graphs.listOntologyNodes(graph);
        Set<Node> ontologyNodesSet = Iterators.takeAsSet(ontologyNodes, 2);
        if (ontologyNodesSet.size() != 1) {
            return Optional.empty();
        }
        return Optional.of(ontologyNodesSet.iterator().next());
    }

    public static Comparator<Node> rootNodeComparator(Graph graph) {
        return Comparator.comparing(Node::isURI).reversed().thenComparing(Comparator.comparingLong(x -> Iterators.count(graph.find((Node)x, Node.ANY, Node.ANY))).reversed()).thenComparing(o -> o.toString(graph.getPrefixMapping()));
    }

    public static ExtendedIterator<Node> listOntologyNodes(Graph graph) {
        return graph.find(Node.ANY, RDF.Nodes.type, OWL2.Ontology.asNode()).mapWith(t -> {
            Node n = t.getSubject();
            return n.isURI() || n.isBlank() ? n : null;
        }).filterDrop(Objects::isNull);
    }

    public static Set<String> getImports(Graph graph) {
        return Graphs.getImports(graph, false);
    }

    public static Set<String> getImports(Graph graph, boolean allowMultipleOntologyHeaders) {
        return Set.copyOf(Iterators.addAll(Graphs.listImports(graph, allowMultipleOntologyHeaders), new HashSet()));
    }

    public static boolean hasImports(Graph graph, String uri) {
        Objects.requireNonNull(uri);
        return Iterators.findFirst(Graphs.listImports(graph, false).filterKeep(uri::equals)).isPresent();
    }

    public static ExtendedIterator<String> listImports(Graph graph, boolean allowMultipleOntologyHeaders) {
        Node ontology = Graphs.ontologyNode(Objects.requireNonNull(graph), allowMultipleOntologyHeaders).orElse(null);
        if (ontology == null) {
            return NullIterator.instance();
        }
        return Graphs.listImports(ontology, graph);
    }

    private static ExtendedIterator<String> listImports(Node ontology, Graph graph) {
        return graph.find(ontology, OWL2.imports.asNode(), Node.ANY).mapWith(t -> {
            Node n = t.getObject();
            return n.isURI() ? n.getURI() : null;
        }).filterDrop(Objects::isNull);
    }

    public static ExtendedIterator<Triple> listOntHeaderTriples(Graph graph) {
        return Iterators.concat(graph.find(Node.ANY, RDF.type.asNode(), OWL2.Ontology.asNode()), graph.find(Node.ANY, OWL2.imports.asNode(), Node.ANY), graph.find(Node.ANY, OWL2.versionIRI.asNode(), Node.ANY));
    }

    public static PrefixMapping collectPrefixes(Iterable<Graph> graphs) {
        PrefixMapping res = PrefixMapping.Factory.create();
        graphs.forEach(g -> res.setNsPrefixes(g.getPrefixMapping()));
        return res.lock();
    }

    public static boolean dependsOn(Graph left, Graph right) {
        return left == right || left != null && left.dependsOn(right);
    }

    public static ExtendedIterator<Node> listSubjects(Graph graph) {
        return Iterators.create(() -> Collections.unmodifiableSet(graph.find().mapWith(Triple::getSubject).toSet()).iterator());
    }

    public static ExtendedIterator<Node> listSubjectsAndObjects(Graph graph) {
        return Iterators.create(() -> Collections.unmodifiableSet(Iterators.flatMap(graph.find(), t -> Iterators.of(new Node[]{t.getSubject(), t.getObject()})).toSet()).iterator());
    }

    public static ExtendedIterator<Node> listAllNodes(Graph graph) {
        return Iterators.create(() -> Collections.unmodifiableSet(Iterators.flatMap(graph.find(), t -> Iterators.of(new Node[]{t.getSubject(), t.getPredicate(), t.getObject()})).toSet()).iterator());
    }

    public static Node createNode(String iri) {
        return iri == null ? NodeFactory.createBlankNode() : NodeFactory.createURI(iri);
    }

    public static boolean isNamedTriple(Triple triple) {
        return triple.getObject().isURI() && triple.getSubject().isURI();
    }

    public static Triple invertTriple(Triple triple) {
        return Triple.create(triple.getObject(), triple.getPredicate(), triple.getSubject());
    }

    public static int getSpliteratorCharacteristics(Graph graph) {
        int res = 256;
        if (Graphs.isDistinct(graph)) {
            return res | 1;
        }
        return res;
    }

    public static boolean hasOneOfType(Node node, Graph graph, Set<Node> types) {
        if (types.isEmpty()) {
            return false;
        }
        if (types.size() == 1) {
            return graph.contains(node, RDF.Nodes.type, types.iterator().next());
        }
        if (Graphs.isGraphInf(graph)) {
            for (Node type : types) {
                if (!graph.contains(node, RDF.Nodes.type, type)) continue;
                return true;
            }
            return false;
        }
        return Iterators.anyMatch(graph.find(node, RDF.Nodes.type, Node.ANY), triple -> types.contains(triple.getObject()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testTypes(Node node, Graph graph, Set<Node> whiteTypes, Set<Node> blackTypes) {
        Set<Node> allTypes;
        if (Graphs.isGraphInf(graph)) {
            return Graphs.testTypesUsingContains(node, graph, whiteTypes, blackTypes);
        }
        try (ExtendedIterator<Node> findTypes = graph.find(node, RDF.Nodes.type, Node.ANY).mapWith(Triple::getObject);){
            allTypes = findTypes.toSet();
        }
        boolean hasWhiteType = false;
        for (Node type : allTypes) {
            if (blackTypes.contains(type)) {
                return false;
            }
            if (!whiteTypes.contains(type)) continue;
            hasWhiteType = true;
        }
        return hasWhiteType;
    }

    public static boolean testTypesUsingContains(Node node, Graph g, Set<Node> whiteTypes, Set<Node> blackTypes) {
        boolean hasWhiteType = false;
        boolean hasBlackType = false;
        if (whiteTypes.size() > blackTypes.size()) {
            for (Node type : whiteTypes) {
                if (!g.contains(node, RDF.Nodes.type, type)) continue;
                hasWhiteType = true;
                break;
            }
            if (!hasWhiteType) {
                return false;
            }
            for (Node type : blackTypes) {
                if (!g.contains(node, RDF.Nodes.type, type)) continue;
                hasBlackType = true;
                break;
            }
            return !hasBlackType;
        }
        for (Node type : blackTypes) {
            if (!g.contains(node, RDF.Nodes.type, type)) continue;
            hasBlackType = true;
            break;
        }
        if (hasBlackType) {
            return false;
        }
        for (Node type : whiteTypes) {
            if (!g.contains(node, RDF.Nodes.type, type)) continue;
            hasWhiteType = true;
            break;
        }
        return hasWhiteType;
    }

    static {
        JenaSystem.init();
    }
}

