/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpLib;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDiff;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLabel;
import org.apache.jena.sparql.algebra.op.OpLateral;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpN;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuad;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.builders.BuilderExpr;
import org.apache.jena.sparql.sse.builders.BuilderGraph;
import org.apache.jena.sparql.sse.builders.BuilderLib;
import org.apache.jena.sparql.sse.builders.BuilderNode;
import org.apache.jena.sparql.sse.builders.BuilderPath;
import org.apache.jena.sparql.sse.builders.BuilderTable;

public class BuilderOp {
    private static BuilderOp builderOp = new BuilderOp();
    protected Map<String, Build> dispatch = new HashMap<String, Build>();
    protected final Build buildTable = list -> {
        Item t = Item.createList(list);
        Table table = BuilderTable.build(t);
        return OpTable.create(table);
    };
    protected final Build buildBGP = list -> {
        BasicPattern triples = BuilderOp.buildBGP(list);
        return new OpBGP(triples);
    };
    protected final Build buildQuadPattern = list -> {
        Node g = null;
        BasicPattern bp = new BasicPattern();
        for (int i = 1; i < list.size(); ++i) {
            Item item = list.get(i);
            if (!item.isList()) {
                BuilderLib.broken(item, "Not a quad structure");
            }
            Quad q = BuilderGraph.buildQuad(item.getList());
            if (g == null) {
                g = q.getGraph();
            } else if (!g.equals(q.getGraph())) {
                BuilderLib.broken(item, "Quad has different graph node in quadapttern: " + q);
            }
            bp.add(q.asTriple());
        }
        OpQuadPattern op = new OpQuadPattern(g, bp);
        return op;
    };
    protected final Build buildQuadBlock = list -> {
        Object g = null;
        QuadPattern qp = new QuadPattern();
        for (int i = 1; i < list.size(); ++i) {
            Item item = list.get(i);
            if (!item.isList()) {
                BuilderLib.broken(item, "Not a quad structure");
            }
            Quad q = BuilderGraph.buildQuad(item.getList());
            qp.add(q);
        }
        OpQuadBlock op = new OpQuadBlock(qp);
        return op;
    };
    protected final Build buildTriple = list -> {
        Triple t = BuilderGraph.buildTriple(list);
        return new OpTriple(t);
    };
    protected final Build buildQuad = list -> {
        Quad q = BuilderGraph.buildQuad(list);
        return new OpQuad(q);
    };
    protected final Build buildTriplePath = list -> {
        TriplePath tp = BuilderPath.buildTriplePath(list);
        return new OpPath(tp);
    };
    protected final Build buildFilter = list -> {
        BuilderLib.checkLength(3, list, "Malformed filter");
        Item itemExpr = list.get(1);
        Item itemOp = list.get(2);
        Op op = this.build(itemOp.getList());
        ExprList exprList = BuilderExpr.buildExprOrExprList(itemExpr);
        return OpFilter.filterDirect(exprList, op);
    };
    protected final Build buildJoin = list -> {
        BuilderLib.checkLength(3, list, "Join");
        Op left = this.build(list, 1);
        Op right = this.build(list, 2);
        Op op = OpJoin.create(left, right);
        return op;
    };
    protected final Build buildSequence = list -> {
        BuilderLib.checkLengthAtLeast(2, list, "Sequence");
        OpSequence op = OpSequence.create();
        this.addOps(op, list);
        return op;
    };
    protected final Build buildDisjunction = list -> {
        BuilderLib.checkLengthAtLeast(2, list, "Disjunction");
        OpDisjunction op = OpDisjunction.create();
        this.addOps(op, list);
        return op;
    };
    protected final Build buildLeftJoin = list -> {
        Item exprItem;
        BuilderLib.checkLength(3, 4, list, "leftjoin: wanted 2 or 3 arguments");
        Op left = this.build(list, 1);
        Op right = this.build(list, 2);
        ExprList expr = null;
        if (!(list.size() != 4 || (exprItem = list.get(3)).isList() && exprItem.getList().isEmpty())) {
            expr = BuilderExpr.buildExprOrExprList(exprItem);
        }
        Op op = OpLeftJoin.create(left, right, expr);
        return op;
    };
    protected final Build buildDiff = list -> {
        BuilderLib.checkLength(3, 4, list, "diff: wanted 2 arguments");
        Op left = this.build(list, 1);
        Op right = this.build(list, 2);
        Op op = OpDiff.create(left, right);
        return op;
    };
    protected final Build buildMinus = list -> {
        BuilderLib.checkLength(3, 4, list, "minus: wanted 2 arguments");
        Op left = this.build(list, 1);
        Op right = this.build(list, 2);
        Op op = OpMinus.create(left, right);
        return op;
    };
    protected final Build buildUnion = list -> {
        BuilderLib.checkLength(3, list, "union");
        Op left = this.build(list, 1);
        Op right = this.build(list, 2);
        OpUnion op = new OpUnion(left, right);
        return op;
    };
    protected final Build buildDatasetNames = list -> {
        BuilderLib.checkLength(2, list, "datasetnames");
        Node n = BuilderNode.buildNode(list.get(1));
        return new OpDatasetNames(n);
    };
    protected final Build buildLateral = list -> {
        BuilderLib.checkLength(3, 4, list, "lateral");
        Op left = this.build(list, 1);
        Op right = this.build(list, 2);
        Op op = OpLateral.create(left, right);
        return op;
    };
    protected final Build buildConditional = list -> {
        BuilderLib.checkLength(2, 3, list, "condition");
        Op left = this.build(list, 1);
        Op right = OpLib.unit();
        if (list.size() != 2) {
            right = this.build(list, 2);
        }
        OpConditional op = new OpConditional(left, right);
        return op;
    };
    protected final Build buildGraph = list -> {
        BuilderLib.checkLength(3, list, "graph");
        Node graph = BuilderNode.buildNode(list.get(1));
        Op sub = this.build(list, 2);
        return new OpGraph(graph, sub);
    };
    protected final Build buildService = list -> {
        Node service;
        boolean silent = false;
        BuilderLib.checkLength(3, 4, list, "service");
        list = list.cdr();
        if (list.size() == 3) {
            if (!list.car().isSymbol()) {
                BuilderLib.broken(list, "Expected a keyword");
            }
            if (!list.car().getSymbol().equalsIgnoreCase("SILENT")) {
                BuilderLib.broken(list, "Service: Expected SILENT");
            }
            silent = true;
            list = list.cdr();
        }
        if (!(service = BuilderNode.buildNode(list.car())).isURI() && !service.isVariable()) {
            BuilderLib.broken(list, "Service must provide a URI or variable");
        }
        list = list.cdr();
        Op sub = this.build(list, 0);
        return new OpService(service, sub, silent);
    };
    protected final Build buildProcedure = list -> {
        BuilderLib.checkLength(4, list, "proc");
        Node procId = BuilderNode.buildNode(list.get(1));
        if (!procId.isURI()) {
            BuilderLib.broken(list, "Procedure name must be a URI");
        }
        ExprList args = BuilderExpr.buildExprOrExprList(list.get(2));
        Op sub = this.build(list, 3);
        return new OpProcedure(procId, args, sub);
    };
    protected final Build buildPropertyFunction = list -> {
        BuilderLib.checkLength(5, list, "propfunc");
        Node property = BuilderNode.buildNode(list.get(1));
        if (!property.isURI()) {
            BuilderLib.broken(list, "Property function name must be a URI");
        }
        PropFuncArg subjArg = BuilderOp.readPropFuncArg(list.get(2));
        PropFuncArg objArg = BuilderOp.readPropFuncArg(list.get(3));
        Op sub = this.build(list, 4);
        return new OpPropFunc(property, subjArg, objArg, sub);
    };
    protected final Build buildToList = list -> {
        BuilderLib.checkLength(2, list, "tolist");
        Op sub = this.build(list, 1);
        OpList op = new OpList(sub);
        return op;
    };
    protected final Build buildGroupBy = list -> {
        BuilderLib.checkLength(3, 4, list, "Group");
        VarExprList vars = BuilderExpr.buildNamedExprList(list.get(1).getList());
        ArrayList<ExprAggregator> aggregators = new ArrayList<ExprAggregator>();
        if (list.size() == 4) {
            VarExprList y = BuilderExpr.buildNamedExprList(list.get(2).getList());
            for (Var aggVar : y.getVars()) {
                Expr e2 = y.getExpr(aggVar);
                if (!(e2 instanceof ExprAggregator)) {
                    BuilderLib.broken(list, "Not a aggregate expression: " + e2);
                }
                ExprAggregator eAgg = (ExprAggregator)e2;
                eAgg.setVar(aggVar);
                aggregators.add(eAgg);
            }
        }
        Op sub = this.build(list, list.size() - 1);
        OpGroup op = OpGroup.create(sub, vars, aggregators);
        return op;
    };
    protected final Build buildOrderBy = list -> {
        BuilderLib.checkLength(3, list, "Order");
        ItemList conditions = list.get(1).getList();
        ArrayList<SortCondition> x = new ArrayList<SortCondition>();
        for (int i = 0; i < conditions.size(); ++i) {
            Item item = conditions.get(i);
            SortCondition sc = this.scBuilder(item);
            x.add(sc);
        }
        Op sub = this.build(list, 2);
        OpOrder op = new OpOrder(sub, x);
        return op;
    };
    protected final Build buildTopN = list -> {
        BuilderLib.checkLength(3, list, "top");
        int N = BuilderNode.buildInt(list.get(1).getList(), 0, -1);
        ItemList conditions = list.get(1).getList().cdr();
        ArrayList<SortCondition> x = new ArrayList<SortCondition>();
        for (int i = 0; i < conditions.size(); ++i) {
            Item item = conditions.get(i);
            SortCondition sc = this.scBuilder(item);
            x.add(sc);
        }
        Op sub = this.build(list, 2);
        OpTopN op = new OpTopN(sub, N, x);
        return op;
    };
    protected final Build buildProject = list -> {
        BuilderLib.checkLength(3, list, "project");
        Item item1 = list.get(1);
        List<Var> x = null;
        if (item1.isList()) {
            x = BuilderNode.buildVars(list.get(1).getList());
        } else if (list.get(1).isVar()) {
            Var var = BuilderNode.buildVar(item1);
            x = Collections.singletonList(var);
        } else {
            BuilderLib.broken("Not a list of variable for project: " + list.get(1));
        }
        Op sub = this.build(list, 2);
        return new OpProject(sub, x);
    };
    protected final Build buildDistinct = list -> {
        BuilderLib.checkLength(2, list, "distinct");
        Op sub = this.build(list, 1);
        return OpDistinct.create(sub);
    };
    protected final Build buildReduced = list -> {
        BuilderLib.checkLength(2, list, "reduced");
        Op sub = this.build(list, 1);
        return OpReduced.create(sub);
    };
    protected final Build buildAssign = list -> {
        BuilderLib.checkLength(3, list, "assign");
        VarExprList x = BuilderExpr.buildNamedExprOrExprList(list.get(1));
        Op sub = list.size() == 2 ? OpLib.unit() : this.build(list, 2);
        return OpAssign.create(sub, x);
    };
    protected final Build buildExtend = list -> {
        BuilderLib.checkLength(2, 3, list, "extend");
        VarExprList x = BuilderExpr.buildNamedExprOrExprList(list.get(1));
        Op sub = list.size() == 2 ? OpLib.unit() : this.build(list, 2);
        return OpExtend.create(sub, x);
    };
    protected final Build buildSlice = list -> {
        BuilderLib.checkLength(4, list, "slice");
        long start = BuilderNode.buildLong(list, 1, -1);
        long length = BuilderNode.buildLong(list, 2, -1);
        if (start == -1L) {
            start = Long.MIN_VALUE;
        }
        if (length == -1L) {
            length = Long.MIN_VALUE;
        }
        Op sub = this.build(list, 3);
        return new OpSlice(sub, start, length);
    };
    protected final Build buildNull = list -> {
        BuilderLib.checkLength(1, list, "null");
        return OpNull.create();
    };
    protected final Build buildLabel = list -> {
        BuilderLib.checkLength(2, 3, list, "label");
        Item label = list.get(1);
        Object str2 = null;
        if (label.isSymbol()) {
            str2 = label.getSymbol();
        } else if (label.isNode()) {
            if (label.getNode().isLiteral()) {
                if (label.getNode().getLiteralLanguage() == null || label.getNode().getLiteralLanguage().equals("")) {
                    str2 = label.getNode().getLiteralLexicalForm();
                }
            } else {
                str2 = label.getNode();
            }
        } else {
            BuilderLib.broken("No a symbol or a node");
        }
        if (str2 == null) {
            str2 = label.toString();
        }
        Op op = null;
        if (list.size() == 3) {
            op = this.build(list, 2);
        }
        return OpLabel.create(str2, op);
    };

    public static Op build(Item item) {
        if (item.isNode()) {
            BuilderLib.broken(item, "Attempt to build op structure from a plain node");
        }
        if (item.isSymbol()) {
            BuilderLib.broken(item, "Attempt to build op structure from a bare symbol");
        }
        if (!item.isTagged()) {
            BuilderLib.broken(item, "Attempt to build op structure from a non-tagged item");
        }
        return builderOp.build(item.getList());
    }

    public BuilderOp() {
        this.addBuild("bgp", this.buildBGP);
        this.addBuild("quadpattern", this.buildQuadPattern);
        this.addBuild("quadblock", this.buildQuadBlock);
        this.addBuild("triple", this.buildTriple);
        this.addBuild("quad", this.buildQuad);
        this.addBuild("path", this.buildTriplePath);
        this.addBuild("filter", this.buildFilter);
        this.addBuild("graph", this.buildGraph);
        this.addBuild("service", this.buildService);
        this.addBuild("proc", this.buildProcedure);
        this.addBuild("propfunc", this.buildPropertyFunction);
        this.addBuild("join", this.buildJoin);
        this.addBuild("sequence", this.buildSequence);
        this.addBuild("disjunction", this.buildDisjunction);
        this.addBuild("leftjoin", this.buildLeftJoin);
        this.addBuild("diff", this.buildDiff);
        this.addBuild("minus", this.buildMinus);
        this.addBuild("union", this.buildUnion);
        this.addBuild("datasetnames", this.buildDatasetNames);
        this.addBuild("lateral", this.buildLateral);
        this.addBuild("conditional", this.buildConditional);
        this.addBuild("tolist", this.buildToList);
        this.addBuild("group", this.buildGroupBy);
        this.addBuild("order", this.buildOrderBy);
        this.addBuild("top", this.buildTopN);
        this.addBuild("project", this.buildProject);
        this.addBuild("distinct", this.buildDistinct);
        this.addBuild("reduced", this.buildReduced);
        this.addBuild("assign", this.buildAssign);
        this.addBuild("extend", this.buildExtend);
        this.addBuild(":=", this.buildAssign);
        this.addBuild("slice", this.buildSlice);
        this.addBuild("table", this.buildTable);
        this.addBuild("null", this.buildNull);
        this.addBuild("label", this.buildLabel);
    }

    public static void add(String tag, Build builder) {
        builderOp.addBuild(tag, builder);
    }

    public static void remove(String tag) {
        builderOp.removeBuild(tag);
    }

    public static boolean contains(String tag) {
        return builderOp.containsBuild(tag);
    }

    private Op build(ItemList list) {
        Item head = list.get(0);
        String tag = head.getSymbol();
        Build bob = this.findBuild(tag);
        if (bob != null) {
            return bob.make(list);
        }
        BuilderLib.broken(head, "Unrecognized algebra operation: " + tag);
        return null;
    }

    public static BasicPattern buildBGP(Item item) {
        if (!item.isTagged("bgp")) {
            BuilderLib.broken(item, "Not a basic graph pattern");
        }
        if (!item.isList()) {
            BuilderLib.broken(item, "Not a list for a basic graph pattern");
        }
        ItemList list = item.getList();
        return BuilderOp.buildBGP(list);
    }

    private static BasicPattern buildBGP(ItemList list) {
        BasicPattern triples = new BasicPattern();
        for (int i = 1; i < list.size(); ++i) {
            Item item = list.get(i);
            if (!item.isList()) {
                BuilderLib.broken(item, "Not a triple structure");
            }
            Triple t = BuilderGraph.buildTriple(item.getList());
            triples.add(t);
        }
        return triples;
    }

    protected Op build(ItemList list, int idx) {
        return this.build(list.get(idx).getList());
    }

    protected void addBuild(String tag, Build builder) {
        this.dispatch.put(tag, builder);
    }

    protected void removeBuild(String tag) {
        this.dispatch.remove(tag);
    }

    protected boolean containsBuild(String tag) {
        return this.findBuild(tag) != null;
    }

    protected Build findBuild(String str2) {
        for (String key : this.dispatch.keySet()) {
            if (!str2.equalsIgnoreCase(key)) continue;
            return this.dispatch.get(key);
        }
        return null;
    }

    private final void addOps(OpN op, ItemList list) {
        for (int i = 1; i < list.size(); ++i) {
            Op sub = this.build(list, i);
            op.add(sub);
        }
    }

    private static final PropFuncArg readPropFuncArg(Item item) {
        if (item.isNode()) {
            return new PropFuncArg(BuilderNode.buildNode(item));
        }
        if (item.isList()) {
            return new PropFuncArg(BuilderNode.buildNodeList(item));
        }
        BuilderLib.broken(item, "Expected a property function argument (node or list of nodes");
        return null;
    }

    SortCondition scBuilder(Item item) {
        Expr expr;
        int direction = -2;
        if (item.isTagged("asc") || item.isTagged("desc")) {
            BuilderLib.checkList(item);
            BuilderLib.checkLength(2, item.getList(), "Direction corrupt");
            direction = item.isTagged("asc") ? 1 : -1;
            item = item.getList().get(1);
        }
        if ((expr = BuilderExpr.buildExpr(item)).isVariable()) {
            return new SortCondition(expr.getExprVar().asVar(), direction);
        }
        return new SortCondition(expr, direction);
    }

    @FunctionalInterface
    public static interface Build {
        public Op make(ItemList var1);
    }
}

