/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.conversion;

import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncBlockAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcNamedValue;
import org.eclipse.escet.cif.plcgen.model.functions.PlcBasicFuncDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcExplicitOutTypeFunctionDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFunctionBlockDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcPlainFuncDescription;
import org.eclipse.escet.cif.plcgen.model.types.PlcAbstractType;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcFuncBlockType;
import org.eclipse.escet.cif.plcgen.model.types.PlcGenericType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class PlcFunctionAppls {
    private final PlcTarget target;
    private PlcFuncBlockType tonBlockType = null;

    public PlcFunctionAppls(PlcTarget target) {
        this.target = target;
    }

    public PlcFuncAppl negateFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.NEGATE_OP, null, "-", PlcBasicFuncDescription.ExprBinding.UNARY_NEGATE, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE);
    }

    public PlcFuncAppl multiplyFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.MULTIPLY_OP, "MUL", "*", PlcBasicFuncDescription.ExprBinding.BINARY_MUL, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE, inN, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE);
    }

    public PlcFuncAppl divideFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.DIVIDE_OP, "DIV", "/", PlcBasicFuncDescription.ExprBinding.BINARY_DIV, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE);
    }

    public PlcFuncAppl moduloFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.MODULO_OP, "MOD", "MOD", PlcBasicFuncDescription.ExprBinding.BINARY_MOD, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE);
    }

    public PlcFuncAppl addFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.ADD_OP, "ADD", "+", PlcBasicFuncDescription.ExprBinding.BINARY_ADD, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE, inN, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE);
    }

    public PlcFuncAppl subtractFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.SUBTRACT_OP, "SUB", "-", PlcBasicFuncDescription.ExprBinding.BINARY_SUB, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE);
    }

    public PlcFuncAppl lessThanFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.LESS_THAN_OP, "LT", "<", PlcBasicFuncDescription.ExprBinding.BINARY_LESS_THAN, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl lessEqualFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.LESS_EQUAL_OP, "LE", "<=", PlcBasicFuncDescription.ExprBinding.BINARY_LESS_EQUAL, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl greaterThanFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.GREATER_THAN_OP, "GT", ">", PlcBasicFuncDescription.ExprBinding.BINARY_GREATER_THAN, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl greaterEqualFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.GREATER_EQUAL_OP, "GE", ">=", PlcBasicFuncDescription.ExprBinding.BINARY_GREATER_EQUAL, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl equalFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.EQUAL_OP, "EQ", "=", PlcBasicFuncDescription.ExprBinding.BINARY_EQUAL, (PlcAbstractType)PlcGenericType.ANY_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl unEqualFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.UNEQUAL_OP, "NE", "<>", PlcBasicFuncDescription.ExprBinding.BINARY_UNEQUAL, (PlcAbstractType)PlcGenericType.ANY_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl complementFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.COMPLEMENT_OP, "NOT", "NOT ", PlcBasicFuncDescription.ExprBinding.UNARY_NOT, (PlcAbstractType)PlcElementaryType.BOOL_TYPE, in, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl andFuncAppl(boolean shortCircuit, PlcExpression ... inN) {
        if (shortCircuit) {
            Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.AND_SHORT_CIRCUIT_OP, inN.length));
            switch (this.target.getTargetType()) {
                case S7_1500: 
                case S7_1200: 
                case S7_400: 
                case S7_300: {
                    return this.funcAppl(PlcFuncOperation.AND_SHORT_CIRCUIT_OP, "AND", "AND", PlcBasicFuncDescription.ExprBinding.BINARY_AND, (PlcAbstractType)PlcElementaryType.BOOL_TYPE, inN, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
                }
                case TWINCAT: {
                    return this.funcAppl(PlcFuncOperation.AND_SHORT_CIRCUIT_OP, "AND_THEN", "AND_THEN", PlcBasicFuncDescription.ExprBinding.BINARY_AND, (PlcAbstractType)PlcElementaryType.BOOL_TYPE, inN, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
                }
            }
            String mesg = "Short circuit AND unknown for target \"" + String.valueOf((Object)this.target.getTargetType()) + "\".";
            throw new AssertionError((Object)mesg);
        }
        return this.funcAppl(PlcFuncOperation.AND_MATH_OP, "AND", "AND", PlcBasicFuncDescription.ExprBinding.BINARY_AND, (PlcAbstractType)PlcElementaryType.BOOL_TYPE, inN, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl xorFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.XOR_OP, "XOR", "XOR", PlcBasicFuncDescription.ExprBinding.BINARY_XOR, (PlcAbstractType)PlcElementaryType.BOOL_TYPE, inN, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl orFuncAppl(boolean shortCircuit, PlcExpression ... inN) {
        if (shortCircuit) {
            Assert.check((boolean)this.target.supportsOperation(PlcFuncOperation.OR_SHORT_CIRCUIT_OP, inN.length));
            switch (this.target.getTargetType()) {
                case S7_1500: 
                case S7_1200: 
                case S7_400: 
                case S7_300: {
                    return this.funcAppl(PlcFuncOperation.OR_SHORT_CIRCUIT_OP, "OR", "OR", PlcBasicFuncDescription.ExprBinding.BINARY_OR, (PlcAbstractType)PlcElementaryType.BOOL_TYPE, inN, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
                }
                case TWINCAT: {
                    return this.funcAppl(PlcFuncOperation.OR_SHORT_CIRCUIT_OP, "OR_ELSE", "OR_ELSE", PlcBasicFuncDescription.ExprBinding.BINARY_OR, (PlcAbstractType)PlcElementaryType.BOOL_TYPE, inN, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
                }
            }
            String mesg = "Short circuit OR unknown for target \"" + String.valueOf((Object)this.target.getTargetType()) + "\".";
            throw new AssertionError((Object)mesg);
        }
        return this.funcAppl(PlcFuncOperation.OR_MATH_OP, "OR", "OR", PlcBasicFuncDescription.ExprBinding.BINARY_OR, (PlcAbstractType)PlcElementaryType.BOOL_TYPE, inN, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl castFuncAppl(PlcExpression in, PlcElementaryType outType) {
        PlcFuncOperation operation = PlcFuncOperation.CAST_OP;
        Assert.check((boolean)this.target.supportsOperation(operation, 1));
        PlcElementaryType inType = (PlcElementaryType)in.type;
        String funcName = inType.name + "_TO_" + outType.name;
        PlcExplicitOutTypeFunctionDescription func = new PlcExplicitOutTypeFunctionDescription(operation, funcName, inType, outType);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl truncFuncAppl(PlcExpression in, PlcElementaryType outType) {
        PlcFuncOperation operation = PlcFuncOperation.TRUNC_OP;
        Assert.check((boolean)this.target.supportsOperation(operation, 1));
        PlcElementaryType inType = (PlcElementaryType)in.type;
        Assert.check((boolean)PlcElementaryType.isRealType(inType));
        Assert.check((boolean)PlcElementaryType.isIntType(outType));
        PlcExplicitOutTypeFunctionDescription func = new PlcExplicitOutTypeFunctionDescription(operation, "TRUNC", inType, outType);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl selFuncAppl(PlcExpression g, PlcExpression in0, PlcExpression in1) {
        PlcFuncOperation operation = PlcFuncOperation.SEL_OP;
        Assert.check((boolean)this.target.supportsOperation(operation, 3));
        PlcBasicFuncDescription.PlcParameterDescription[] params = new PlcBasicFuncDescription.PlcParameterDescription[]{new PlcBasicFuncDescription.PlcParameterDescription("G", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, PlcElementaryType.BOOL_TYPE), new PlcBasicFuncDescription.PlcParameterDescription("IN0", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, PlcGenericType.ANY_TYPE), new PlcBasicFuncDescription.PlcParameterDescription("IN1", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, PlcGenericType.ANY_TYPE)};
        PlcBasicFuncDescription.PlcFuncTypeExtension typeExt = this.target.getTypeExtension(operation);
        PlcPlainFuncDescription func = new PlcPlainFuncDescription(operation, "SEL", params, null, PlcBasicFuncDescription.ExprBinding.NO_PRIORITY, this.target.getSupportedFuncNotations(operation, 3), PlcGenericType.ANY_TYPE, typeExt);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("G", g), new PlcNamedValue("IN0", in0), new PlcNamedValue("IN1", in1)));
    }

    public PlcFuncAppl normalizeArrayIndex(PlcExpression indexExpr, int arraySize) {
        PlcFuncAppl g = this.greaterEqualFuncAppl(indexExpr, this.target.makeStdInteger(0));
        PlcFuncAppl in0 = this.addFuncAppl(indexExpr, this.target.makeStdInteger(arraySize));
        PlcExpression in1 = indexExpr;
        return this.selFuncAppl(g, in0, in1);
    }

    public PlcFuncAppl absFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_ABS, "ABS", (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE);
    }

    public PlcFuncAppl expFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_EXP, "EXP", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl lnFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_LN, "LN", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl logFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_LOG, "LOG", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl minFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.STDLIB_MIN, "MIN", (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE, inN, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE);
    }

    public PlcFuncAppl maxFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.STDLIB_MAX, "MAX", (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE, inN, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE);
    }

    public PlcFuncAppl sqrtFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_SQRT, "SQRT", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl acosFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_ACOS, "ACOS", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl asinFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_ASIN, "ASIN", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl atanFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_ATAN, "ATAN", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl cosFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_COS, "COS", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl sinFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_SIN, "SIN", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl tanFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_TAN, "TAN", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncBlockType getTonFuncBlockType() {
        if (this.tonBlockType == null) {
            PlcBasicFuncDescription.PlcParameterDescription[] params = new PlcBasicFuncDescription.PlcParameterDescription[]{new PlcBasicFuncDescription.PlcParameterDescription("IN", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, PlcElementaryType.BOOL_TYPE), new PlcBasicFuncDescription.PlcParameterDescription("PT", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, PlcElementaryType.TIME_TYPE), new PlcBasicFuncDescription.PlcParameterDescription("Q", PlcBasicFuncDescription.PlcParamDirection.OUTPUT_ONLY, PlcElementaryType.BOOL_TYPE), new PlcBasicFuncDescription.PlcParameterDescription("ET", PlcBasicFuncDescription.PlcParamDirection.OUTPUT_ONLY, PlcElementaryType.TIME_TYPE)};
            PlcFunctionBlockDescription tonBlockDescr = new PlcFunctionBlockDescription(PlcFuncOperation.BLOCK_TON, "TON", this.target.getTonFuncBlockCallName(), params, PlcElementaryType.TIME_TYPE);
            this.tonBlockType = new PlcFuncBlockType(tonBlockDescr);
        }
        return this.tonBlockType;
    }

    private PlcFuncAppl funcAppl(PlcFuncOperation operation, String prefixText, PlcAbstractType paramType, PlcExpression in, PlcAbstractType resultType) {
        Assert.check((boolean)this.target.supportsOperation(operation, 1));
        PlcBasicFuncDescription.PlcParameterDescription[] parameterDesc = new PlcBasicFuncDescription.PlcParameterDescription[]{new PlcBasicFuncDescription.PlcParameterDescription("IN", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, paramType)};
        PlcBasicFuncDescription.PlcFuncTypeExtension typeExt = this.target.getTypeExtension(operation);
        PlcPlainFuncDescription func = new PlcPlainFuncDescription(operation, prefixText, parameterDesc, null, PlcBasicFuncDescription.ExprBinding.NO_PRIORITY, this.target.getSupportedFuncNotations(operation, 1), resultType, typeExt);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    private PlcFuncAppl funcAppl(PlcFuncOperation operation, String prefixText, String infixText, PlcBasicFuncDescription.ExprBinding exprBinding, PlcAbstractType paramType, PlcExpression in, PlcAbstractType resultType) {
        Assert.check((boolean)this.target.supportsOperation(operation, 1));
        PlcBasicFuncDescription.PlcParameterDescription[] parameterDesc = new PlcBasicFuncDescription.PlcParameterDescription[]{new PlcBasicFuncDescription.PlcParameterDescription("IN", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, paramType)};
        PlcBasicFuncDescription.PlcFuncTypeExtension typeExt = this.target.getTypeExtension(operation);
        PlcPlainFuncDescription func = new PlcPlainFuncDescription(operation, prefixText, parameterDesc, infixText, exprBinding, this.target.getSupportedFuncNotations(operation, 1), resultType, typeExt);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    private PlcFuncAppl funcAppl(PlcFuncOperation operation, String prefixText, PlcAbstractType paramType, PlcExpression[] inN, PlcAbstractType resultType) {
        Assert.check((boolean)this.target.supportsOperation(operation, inN.length));
        PlcBasicFuncDescription.PlcFuncTypeExtension typeExt = this.target.getTypeExtension(operation);
        PlcPlainFuncDescription func = new PlcPlainFuncDescription(operation, prefixText, PlcFunctionAppls.makeParamList(inN.length, paramType), null, PlcBasicFuncDescription.ExprBinding.NO_PRIORITY, this.target.getSupportedFuncNotations(operation, inN.length), resultType, typeExt);
        return new PlcFuncAppl(func, PlcFunctionAppls.makeArgumentList(inN));
    }

    private PlcFuncAppl funcAppl(PlcFuncOperation operation, String prefixText, String infixText, PlcBasicFuncDescription.ExprBinding exprBinding, PlcAbstractType paramType, PlcExpression[] inN, PlcAbstractType resultType) {
        Assert.check((boolean)this.target.supportsOperation(operation, inN.length));
        PlcBasicFuncDescription.PlcFuncTypeExtension typeExt = this.target.getTypeExtension(operation);
        PlcPlainFuncDescription func = new PlcPlainFuncDescription(operation, prefixText, PlcFunctionAppls.makeParamList(inN.length, paramType), infixText, exprBinding, this.target.getSupportedFuncNotations(operation, inN.length), resultType, typeExt);
        return new PlcFuncAppl(func, PlcFunctionAppls.makeArgumentList(inN));
    }

    private static PlcBasicFuncDescription.PlcParameterDescription[] makeParamList(int length, PlcAbstractType paramType) {
        return (PlcBasicFuncDescription.PlcParameterDescription[])IntStream.range(0, length).mapToObj(i -> new PlcBasicFuncDescription.PlcParameterDescription("IN" + (i + 1), PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, paramType)).toArray(PlcBasicFuncDescription.PlcParameterDescription[]::new);
    }

    private static List<PlcNamedValue> makeArgumentList(PlcExpression[] inN) {
        return (List)IntStream.range(0, inN.length).mapToObj(i -> new PlcNamedValue("IN" + (i + 1), inN[i])).collect(Lists.toList());
    }

    public PlcFuncBlockAppl funcBlockAppl(PlcBasicVariable variable, List<PlcNamedValue> arguments) {
        return new PlcFuncBlockAppl(variable, arguments);
    }
}

