/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.io;

import java.io.UnsupportedEncodingException;
import org.eclipse.escet.common.app.framework.io.AppStream;

public class MemAppStream
extends AppStream {
    private byte[] buf;
    private int size = 0;

    public MemAppStream() {
        this(32);
    }

    public MemAppStream(int initCapacity) {
        this.buf = new byte[initCapacity];
    }

    @Override
    protected void writeImpl(byte b) {
        if (this.size == this.buf.length) {
            byte[] old = this.buf;
            this.buf = new byte[old.length * 2];
            System.arraycopy(old, 0, this.buf, 0, this.size);
        }
        this.buf[this.size] = b;
        ++this.size;
    }

    @Override
    protected void writeImpl(byte[] bytes, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            this.writeImpl(bytes[i]);
            ++i;
        }
    }

    @Override
    protected void flushImpl() {
    }

    @Override
    protected void closeImpl() {
    }

    public String toString() {
        try {
            return new String(this.buf, 0, this.size, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

